/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.gdrive;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;

public class GoogleProvider
extends CloudProvider {
    protected final String authURL;
    protected final String redirectURL;
    protected final RepositoryService jcrService;

    public GoogleProvider(String id, String name, String authURL, String redirectURL, RepositoryService jcrService) {
        super(id, name);
        this.authURL = authURL;
        this.redirectURL = redirectURL;
        this.jcrService = jcrService;
    }

    @Deprecated
    GoogleProvider(String id, String name, String authURL, String redirectURL) {
        this(id, name, authURL, redirectURL, null);
    }

    public String getAuthURL() throws CloudDriveException {
        if (this.jcrService != null) {
            try {
                String currentRepo = this.jcrService.getCurrentRepository().getConfiguration().getName();
                return this.authURL.replace("__no_state_set__", currentRepo);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException((Throwable)e);
            }
        }
        return this.authURL;
    }

    public String getErrorMessage(String error, String errorDescription) {
        if (error.indexOf("access_denied") >= 0) {
            return "Access denied to Google Drive";
        }
        return super.getErrorMessage(error, errorDescription);
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public boolean retryOnProviderError() {
        return true;
    }
}

