/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAuthorizationCodeTokenRequest
extends AuthorizationCodeTokenRequest {
    public GoogleAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, String code, String redirectUri) {
        super(transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), code);
        this.setClientAuthentication(new ClientParametersAuthentication(clientId, clientSecret));
        this.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (GoogleAuthorizationCodeTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (GoogleAuthorizationCodeTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setScopes(String ... scopes) {
        return (GoogleAuthorizationCodeTokenRequest)super.setScopes(scopes);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setScopes(Iterable<String> scopes) {
        return (GoogleAuthorizationCodeTokenRequest)super.setScopes((Iterable)scopes);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setGrantType(String grantType) {
        return (GoogleAuthorizationCodeTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        Preconditions.checkNotNull((Object)clientAuthentication);
        return (GoogleAuthorizationCodeTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setCode(String code) {
        return (GoogleAuthorizationCodeTokenRequest)super.setCode(code);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull((Object)redirectUri);
        return (GoogleAuthorizationCodeTokenRequest)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleTokenResponse execute() throws IOException {
        return (GoogleTokenResponse)((Object)this.executeUnparsed().parseAs(GoogleTokenResponse.class));
    }
}

