/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveConfigurationException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.FileStore;
import org.exoplatform.clouddrive.exodrive.service.NotFoundException;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoDriveRepository {
    protected static final Log LOG = ExoLogger.getLogger(ExoDriveRepository.class);
    protected final String name;
    protected final File baseDir;
    protected final String baseUrl;
    protected final MimeTypeResolver mimeResolver;

    ExoDriveRepository(String name, File baseDir, String baseUrl, MimeTypeResolver mimeResolver) throws ExoDriveConfigurationException {
        this.name = name;
        this.baseUrl = baseUrl;
        this.baseDir = baseDir;
        this.mimeResolver = mimeResolver;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileStore readFile(File file, String ownerName) throws ExoDriveException {
        try {
            File metaDir = new File(file.getParent(), ".exodrive");
            File meta = new File(metaDir, file.getName() + ".edi");
            Properties metap = new Properties();
            FileInputStream in = new FileInputStream(meta);
            try {
                metap.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            String id = metap.getProperty("id");
            String type = metap.getProperty("type");
            String author = metap.getProperty("author");
            String lastUser = metap.getProperty("lastuser");
            try {
                Calendar createDate = FileStore.METAFILE_DATEFORMAT.parseCalendar(metap.getProperty("createdate"));
                Calendar modifiedDate = FileStore.METAFILE_DATEFORMAT.parseCalendar(metap.getProperty("modifiydate"));
                if (id != null && type != null && author != null && lastUser != null && createDate != null && modifiedDate != null) {
                    return new FileStore(file, id, this.fileLink(ownerName, file.getName()), type, author, author, createDate, createDate);
                }
            }
            catch (ParseException e) {
                throw new ExoDriveException("Cloud file storage " + file + " metadata inconsistent.", e);
            }
            throw new ExoDriveException("Cloud file storage " + file + " metadata inconsistent.");
        }
        catch (IOException e) {
            throw new ExoDriveException("Cannot read cloud file from storage " + file, e);
        }
    }

    File getBaseDir() {
        return this.baseDir;
    }

    File userRoot(String user) {
        return new File(this.baseDir, user);
    }

    String fileLink(String ownerName, String name) {
        return this.baseUrl + "/" + ownerName + "/" + name;
    }

    String generateId(File parentDir, String name) {
        String idpath = parentDir.getAbsolutePath() + "_secret_" + name;
        return UUID.nameUUIDFromBytes(idpath.getBytes()).toString();
    }

    public boolean exists(String ownerName, String name) {
        File file = name != null ? new File(this.userRoot(ownerName), name) : this.userRoot(ownerName);
        return file.exists();
    }

    public boolean userExists(String ownerName) {
        File file = this.userRoot(ownerName);
        return file.exists();
    }

    public boolean createUser(String ownerName) {
        File file = this.userRoot(ownerName);
        file.mkdirs();
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStore create(String ownerName, String name, String type, Calendar createDate) throws ExoDriveException {
        File parentDir = this.userRoot(ownerName);
        if (parentDir.exists()) {
            File file = new File(parentDir, name);
            try {
                if (file.createNewFile()) {
                    File metaDir = new File(parentDir, ".exodrive");
                    metaDir.mkdirs();
                    File meta = new File(metaDir, name + ".edi");
                    String id = this.generateId(parentDir, name);
                    String mimeType = type != null ? type : this.mimeResolver.getMimeType(name);
                    Properties metap = new Properties();
                    metap.put("id", id);
                    metap.put("type", mimeType);
                    metap.put("author", ownerName);
                    metap.put("lastuser", ownerName);
                    metap.put("createdate", FileStore.METAFILE_DATEFORMAT.format(createDate.getTime()));
                    metap.put("modifiydate", FileStore.METAFILE_DATEFORMAT.format(createDate.getTime()));
                    FileStore local = new FileStore(file, id, this.fileLink(ownerName, file.getName()), mimeType, ownerName, ownerName, createDate, createDate);
                    FileOutputStream out = new FileOutputStream(meta);
                    try {
                        metap.store(out, "Metadata for " + file.getAbsolutePath() + ". Generated at " + FileStore.METAFILE_DATEFORMAT.format(Calendar.getInstance().getTime()));
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                    return local;
                }
                throw new ExoDriveException("Local cloud drive exists with the same name " + file);
            }
            catch (IOException ioe) {
                throw new ExoDriveException("Cannot create cloud file in storage " + file, ioe);
            }
        }
        LOG.warn((Object)("User not found: " + ownerName + ". Requested file not created '" + name + "' as parent not found " + parentDir.getAbsolutePath()));
        throw new NotFoundException("User not found: " + ownerName + ". Requested file not created " + name);
    }

    public FileStore read(String ownerName, String name) throws ExoDriveException {
        File parentDir = this.userRoot(ownerName);
        File file = new File(parentDir, name);
        if (file.exists() && file.isFile()) {
            return this.readFile(file, ownerName);
        }
        LOG.warn((Object)("User not found: " + ownerName + ". Requested storage not exists " + parentDir.getAbsolutePath()));
        throw new NotFoundException(parentDir.exists() ? "Cloud file " + name + " not found." : "User not found " + ownerName);
    }

    public List<FileStore> listFiles(String ownerName) throws ExoDriveException {
        ArrayList<FileStore> res = new ArrayList<FileStore>();
        File parentDir = this.userRoot(ownerName);
        File[] userFiles = parentDir.listFiles();
        if (userFiles != null) {
            for (File f : userFiles) {
                if (!f.isFile()) continue;
                res.add(this.readFile(f, ownerName));
            }
        } else {
            LOG.warn((Object)("User not found: " + ownerName + ". Requested storage not exists " + parentDir.getAbsolutePath()));
            throw new NotFoundException("User not found " + ownerName);
        }
        return res;
    }

    public List<FileStore> listFiles(String ownerName, FileStore parentDir) throws ExoDriveException {
        ArrayList<FileStore> res = new ArrayList<FileStore>();
        File ownerDir = this.userRoot(ownerName);
        if (parentDir.getFile().getAbsolutePath().startsWith(ownerDir.getAbsolutePath())) {
            File[] userFiles = parentDir.getFile().listFiles();
            if (userFiles != null) {
                for (File f : parentDir.getFile().listFiles()) {
                    if (!f.isFile()) continue;
                    res.add(this.readFile(f, ownerName));
                }
            } else {
                LOG.warn((Object)("User not found: " + ownerName + ". Requested storage not exists " + parentDir.getFile().getAbsolutePath()));
                throw new NotFoundException("User not found " + ownerName);
            }
            return res;
        }
        throw new NotFoundException("Not user '" + ownerName + "' folder " + parentDir.getFile());
    }
}

