/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.AbstractJCRAction;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CloudFolderAction
extends AbstractJCRAction {
    private static Log LOG = ExoLogger.getLogger(CloudFolderAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Context context) throws Exception {
        Property prop = (Property)context.get((Object)InvocationContext.CURRENT_ITEM);
        try {
            Node cloudFolder = prop.getParent();
            if (!cloudFolder.isNodeType("ecd:cloudFolder")) return false;
            CloudDriveService drives = this.drives(context);
            CloudDrive localDrive = drives.findDrive(cloudFolder);
            if (localDrive == null) return false;
            if (!this.accept(localDrive)) return false;
            try {
                this.start(localDrive);
                localDrive.synchronize(cloudFolder);
                boolean bl = true;
                return bl;
            }
            catch (SyncNotSupportedException e) {
                LOG.error((Object)("Node cannot be stored in Cloud Drive. Action Node was: " + cloudFolder.getPath()), (Throwable)e);
                return false;
            }
            catch (NotConnectedException e) {
                LOG.error((Object)("Drive not connected. Action Node was: " + cloudFolder.getPath()), (Throwable)e);
                return false;
            }
            finally {
                this.done();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Action item isn't property of ecd:cloudFolder or invalid JCR session. Item: " + prop), (Throwable)e);
        }
        return false;
    }
}

