/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/provider")
@Produces(value={"application/json"})
@Deprecated
public class ProviderService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ProviderService.class);
    protected final CloudDriveService cloudDrives;

    public ProviderService(CloudDriveService cloudDrives) {
        this.cloudDrives = cloudDrives;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/all")
    public Set<CloudProvider> getAll(@Context UriInfo uriInfo) {
        return this.cloudDrives.getProviders();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/{providerid}")
    public Response getById(@Context UriInfo uriInfo, @PathParam(value="providerid") String providerId) {
        try {
            return Response.ok().entity((Object)this.cloudDrives.getProvider(providerId)).build();
        }
        catch (CloudDriveException e) {
            LOG.warn((Object)("Cannot return prvider by id " + providerId + ": " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

