/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.box.BoxAPI;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.box.BoxProvider;
import org.exoplatform.clouddrive.box.BoxUser;
import org.exoplatform.clouddrive.box.JCRLocalBoxDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class BoxConnector
extends CloudDriveConnector {
    public BoxConnector(RepositoryService jcrService, SessionProviderService sessionProviders, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, params);
    }

    @Override
    protected BoxProvider getProvider() {
        return (BoxProvider)super.getProvider();
    }

    @Override
    protected String getConnectorHost() {
        if (this.getConnectorSchema().equalsIgnoreCase("https")) {
            return super.getConnectorHost();
        }
        String[] host = this.connectorHost.split(":");
        StringBuilder newHost = new StringBuilder();
        newHost.append("localhost");
        if (host.length > 1) {
            newHost.append(':');
            newHost.append(host[1]);
        }
        LOG.warn((Object)"Box connector supports only HTTPS for server redirect. Switched to localhost (Box's Development Mode).");
        return newHost.toString();
    }

    @Override
    protected CloudProvider createProvider() {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(this.getConnectorSchema());
        redirectUrl.append("://");
        redirectUrl.append(this.getConnectorHost());
        redirectUrl.append("/portal/rest/clouddrive/connect/");
        redirectUrl.append(this.getProviderId());
        StringBuilder authUrl = new StringBuilder();
        authUrl.append("https://www.box.com/api/oauth2/authorize?");
        authUrl.append("response_type=code&client_id=");
        authUrl.append(this.getClientId());
        authUrl.append("&state=");
        authUrl.append("__no_state_set__");
        authUrl.append("&redirect_uri=");
        authUrl.append((CharSequence)redirectUrl);
        return new BoxProvider(this.getProviderId(), this.getProviderName(), authUrl.toString(), redirectUrl.toString(), this.jcrService);
    }

    @Override
    protected CloudUser authenticate(String code) throws CloudDriveException {
        if (code != null && code.length() > 0) {
            BoxAPI driveAPI = new API().auth(code).build();
            com.box.boxjavalibv2.dao.BoxUser buser = driveAPI.currentUser();
            BoxUser user = new BoxUser(buser.getId(), buser.getName(), buser.getLogin(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access key should not be null or empty");
    }

    @Override
    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof BoxUser) {
            BoxUser boxUser = (BoxUser)user;
            JCRLocalBoxDrive drive = new JCRLocalBoxDrive(boxUser, driveNode, this.sessionProviders);
            boxUser.api().getToken().addListener(drive);
            return drive;
        }
        throw new CloudDriveException("Not Box user: " + user);
    }

    @Override
    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkTrashed(driveNode);
        JCRLocalBoxDrive drive = new JCRLocalBoxDrive(new API(), this.getProvider(), driveNode, this.sessionProviders);
        drive.getUser().api().getToken().addListener(drive);
        return drive;
    }

    class API {
        String code;
        String refreshToken;
        String accessToken;
        long expirationTime;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String refreshToken, String accessToken, long expirationTime) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        BoxAPI build() throws BoxException, CloudDriveException {
            if (this.code != null && this.code.length() > 0) {
                return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.code, BoxConnector.this.getProvider().getRedirectUrl());
            }
            return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.accessToken, this.refreshToken, this.expirationTime);
        }
    }
}

