/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEvent;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxSharedLink;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.box.AuthTokenException;
import org.exoplatform.clouddrive.box.BoxAPI;
import org.exoplatform.clouddrive.box.BoxConnector;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.box.BoxFormatException;
import org.exoplatform.clouddrive.box.BoxProvider;
import org.exoplatform.clouddrive.box.BoxUser;
import org.exoplatform.clouddrive.googledrive.GoogleDriveException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalBoxDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    public static final long FULL_SYNC_PERIOD = 889032704L;
    protected final MimeTypeResolver mimeTypes = new MimeTypeResolver();

    public JCRLocalBoxDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders) throws CloudDriveException, RepositoryException {
        super(user, driveNode, sessionProviders);
    }

    protected JCRLocalBoxDrive(BoxConnector.API apiBuilder, BoxProvider provider, Node driveNode, SessionProviderService sessionProviders) throws RepositoryException, GoogleDriveException, CloudDriveException {
        super(JCRLocalBoxDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders);
    }

    @Override
    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", "0");
        driveNode.setProperty("ecd:url", "https://box.com/");
    }

    protected static BoxUser loadUser(BoxConnector.API apiBuilder, BoxProvider provider, Node driveNode) throws RepositoryException, BoxException, CloudDriveException {
        String refreshToken;
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("box:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("box:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("box:oauth2TokenExpirationTime").getLong();
        BoxAPI driveAPI = apiBuilder.load(refreshToken, accessToken, expirationTime).build();
        return new BoxUser(userId, username, email, provider, driveAPI);
    }

    @Override
    public void onUserTokenRefresh(UserToken token) throws BoxException {
        try {
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("box:oauth2AccessToken", token.getAccessToken());
                driveNode.setProperty("box:oauth2RefreshToken", token.getRefreshToken());
                driveNode.setProperty("box:oauth2TokenExpirationTime", token.getExpirationTime());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new BoxException("Error updating access key: " + e.getMessage(), e);
            }
        }
        catch (DriveRemovedException e) {
            throw new BoxException("Error openning drive node: " + e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new BoxException("Error reading drive node: " + e.getMessage(), e);
        }
    }

    @Override
    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    @Override
    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        Calendar now = Calendar.getInstance();
        Calendar last = this.rootNode().getProperty("box:streamDate").getDate();
        if (now.getTimeInMillis() - last.getTimeInMillis() < 889032704L) {
            return new EventsSync();
        }
        return new FullSync();
    }

    @Override
    protected JCRLocalCloudDrive.SyncFileCommand getSyncFileCommand(Node file) throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        throw new SyncNotSupportedException("File synchronization not supported");
    }

    @Override
    protected boolean isSyncSupported(CloudFile cloudFile) {
        return false;
    }

    @Override
    public BoxUser getUser() {
        return (BoxUser)this.user;
    }

    @Override
    public String getChangesLink() throws DriveRemovedException, CloudProviderException, RepositoryException {
        return this.getUser().api().getChangesLink();
    }

    @Override
    public void updateChangesLink() throws DriveRemovedException, CloudProviderException, RepositoryException {
        this.getUser().api().updateChangesLink();
    }

    @Override
    protected void checkAccess() throws CloudDriveException {
    }

    @Override
    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        this.getUser().updateToken(((BoxUser)newUser).getToken());
    }

    protected void initBoxItem(Node localNode, BoxItem item) throws RepositoryException, BoxException {
        localNode.setProperty("box:etag", item.getEtag());
        try {
            String sequenceIdStr = item.getSequenceId();
            if (sequenceIdStr != null) {
                localNode.setProperty("box:sequenceId", Long.parseLong(sequenceIdStr));
            }
        }
        catch (NumberFormatException e) {
            throw new BoxException("Error parsing sequence_id for " + localNode.getPath(), e);
        }
        localNode.setProperty("box:size", item.getSize().doubleValue());
        localNode.setProperty("box:ownedBy", item.getOwnedBy().getLogin());
        localNode.setProperty("box:description", item.getDescription());
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null) {
            localNode.setProperty("box:sharedAccess", shared.getAccess());
            localNode.setProperty("box:sharedCanDownload", shared.getPermissions().isCan_download());
        }
    }

    protected String findMimetype(String fileName) {
        String name = fileName.toUpperCase().toLowerCase();
        String ext = name.substring(name.lastIndexOf(".") + 1);
        if (ext.equals("webdoc")) {
            return "application/x-exo.box.webdoc";
        }
        return this.mimeTypes.getMimeType(fileName);
    }

    protected JCRLocalCloudFile updateItem(BoxAPI api, BoxItem item, Node parent, Node node) throws RepositoryException, CloudDriveException {
        try {
            String link;
            String embedLink;
            String downloadLink;
            boolean changed;
            long sequenceId;
            Calendar created = api.parseDate(item.getCreatedAt());
            Calendar modified = api.parseDate(item.getModifiedAt());
            String id = item.getId();
            String name = item.getName();
            boolean isFolder = item instanceof BoxFolder;
            String type = isFolder ? item.getType() : this.findMimetype(name);
            String createdBy = item.getCreatedBy().getLogin();
            String modifiedBy = item.getModifiedBy().getLogin();
            try {
                String sequenceIdStr = item.getSequenceId();
                sequenceId = sequenceIdStr != null ? Long.parseLong(sequenceIdStr) : -1L;
            }
            catch (NumberFormatException e) {
                throw new BoxFormatException("Error parsing sequence_id for " + parent.getPath() + "/" + item.getName(), e);
            }
            if (node == null) {
                node = isFolder ? this.openFolder(id, name, parent) : this.openFile(id, name, type, parent);
            }
            boolean bl = changed = node.isNew() || sequenceId >= 0L && node.getProperty("box:sequenceId").getLong() < sequenceId || !node.getProperty("box:etag").getString().equals(item.getEtag());
            if (isFolder) {
                embedLink = downloadLink = api.getLink(item);
                link = downloadLink;
                if (changed) {
                    this.initFolder(node, id, name, type, link, createdBy, modifiedBy, created, modified);
                    this.initBoxItem(node, item);
                }
            } else {
                link = downloadLink = api.getLink(item);
                embedLink = api.getEmbedLink(item);
                if (changed) {
                    this.initFile(node, id, name, type, link, embedLink, downloadLink, createdBy, modifiedBy, created, modified);
                    this.initBoxItem(node, item);
                }
            }
            return new JCRLocalCloudFile(node.getPath(), id, name, link, embedLink, downloadLink, type, createdBy, modifiedBy, created, modified, isFolder, node, changed);
        }
        catch (ParseException e) {
            throw new BoxFormatException("Error parsing date for " + parent.getPath() + "/" + item.getName(), e);
        }
    }

    protected boolean notInRange(String path, Collection<String> range) {
        for (String p : range) {
            if (!path.startsWith(p)) continue;
            return false;
        }
        return true;
    }

    protected class EventsSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final BoxAPI api;
        protected final Set<String> history;
        protected final Set<String> newHistory;
        protected final LinkedList<BoxEvent> postponed;
        protected final Map<String, JCRLocalCloudFile> applied;
        protected final Map<String, BoxItem> undeleted;
        protected final Set<String> removedIds;
        protected BoxAPI.EventsIterator events;
        protected BoxEvent nextEvent;
        protected BoxEvent lastPostponed;
        protected int prevPostponedNumber;
        protected int postponedNumber;
        protected int appliedCounter;
        protected int readCounter;

        protected EventsSync() throws RepositoryException, DriveRemovedException {
            super(JCRLocalBoxDrive.this);
            this.history = new LinkedHashSet<String>();
            this.newHistory = new LinkedHashSet<String>();
            this.postponed = new LinkedList();
            this.applied = new LinkedHashMap<String, JCRLocalCloudFile>();
            this.undeleted = new LinkedHashMap<String, BoxItem>();
            this.removedIds = new LinkedHashSet<String>();
            this.appliedCounter = 0;
            this.readCounter = 0;
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        @Override
        protected void syncFiles() throws CloudDriveException, RepositoryException {
            long localStreamPosition = this.driveRoot.getProperty("box:streamPosition").getLong();
            this.events = this.api.getEvents(localStreamPosition);
            this.iterators.add(this.events);
            for (String es : this.driveRoot.getProperty("box:streamHistory").getString().split(";")) {
                this.history.add(es);
            }
            while (this.hasNextEvent()) {
                BoxEvent event = this.nextEvent();
                BoxTypedObject source = event.getSource();
                if (source instanceof BoxItem) {
                    Node sourceNode;
                    JCRLocalCloudFile local;
                    Node parent;
                    BoxItem item = (BoxItem)source;
                    String eventType = event.getEventType();
                    String parentId = item.getParent().getId();
                    if ("0".equals(parentId)) {
                        parent = this.driveRoot;
                    } else {
                        local = this.applied(parentId);
                        if (local != null) {
                            parent = local.getNode();
                            parent.getParent().getNodes();
                        } else {
                            parent = JCRLocalBoxDrive.this.findNode(parentId);
                            if (parent == null) {
                                if (this.isRemoved(parentId) && eventType.equals("ITEM_TRASH")) continue;
                                this.postpone(event);
                                continue;
                            }
                        }
                    }
                    if (eventType.equals("ITEM_CREATE") || eventType.equals("ITEM_UPLOAD")) {
                        this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                        continue;
                    }
                    if (eventType.equals("ITEM_MOVE") || eventType.equals("ITEM_RENAME")) {
                        BoxItem undelete = this.undeleted(item.getId());
                        if (undelete != null) {
                            this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                            continue;
                        }
                        JCRLocalCloudFile local2 = this.applied(item.getId());
                        sourceNode = local2 != null ? local2.getNode() : JCRLocalBoxDrive.this.findNode(item.getId());
                        if (sourceNode != null) {
                            Node destNode = JCRLocalBoxDrive.this.moveNode(item.getId(), item.getName(), sourceNode, parent);
                            this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, destNode));
                            continue;
                        }
                        this.postpone(event);
                        continue;
                    }
                    if (eventType.equals("ITEM_TRASH")) {
                        Node node = JCRLocalBoxDrive.this.readNode(parent, item.getName(), item.getId());
                        if (node != null) {
                            String path = node.getPath();
                            node.remove();
                            this.remove(item.getId(), path);
                            continue;
                        }
                        this.postpone(event);
                        continue;
                    }
                    if (eventType.equals("ITEM_UNDELETE_VIA_TRASH")) {
                        Node place = JCRLocalBoxDrive.this.readNode(parent, item.getName(), item.getId());
                        if (place == null) {
                            this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                            continue;
                        }
                        this.undelete(item);
                        this.postpone(event);
                        continue;
                    }
                    if (eventType.equals("ITEM_COPY")) {
                        local = this.applied(item.getId());
                        if (local != null) {
                            sourceNode = local.getNode();
                            Node destNode = JCRLocalBoxDrive.this.copyNode(sourceNode, parent);
                            this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, destNode));
                            continue;
                        }
                        local = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                        this.apply(local);
                        if (!local.isFolder()) continue;
                        this.fetchChilds(local.getId(), local.getNode());
                        continue;
                    }
                    LOG.warn((Object)("Skipped unexpected event from Box Event: " + eventType));
                    continue;
                }
                LOG.warn((Object)("Skipping non Item in Box events: " + source));
            }
            if (this.hasPostponed()) {
                LOG.warn((Object)"Not all events applied for Box sync. Running full sync.");
                JCRLocalBoxDrive.this.rollback(this.driveRoot);
                FullSync fullSync = new FullSync();
                fullSync.exec();
                this.changed.clear();
                this.changed.addAll(fullSync.getFiles());
                this.removed.clear();
                this.removed.addAll(fullSync.getRemoved());
            } else {
                StringBuilder newHistoryData = new StringBuilder();
                Iterator<String> eriter = this.newHistory.iterator();
                while (eriter.hasNext()) {
                    newHistoryData.append(eriter.next());
                    if (!eriter.hasNext()) continue;
                    newHistoryData.append(';');
                }
                this.driveRoot.setProperty("box:streamHistory", newHistoryData.toString());
                this.driveRoot.setProperty("box:streamPosition", this.events.streamPosition);
                this.driveRoot.setProperty("box:streamDate", Calendar.getInstance());
            }
        }

        protected BoxFolder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext()) {
                BoxItem item = (BoxItem)items.next();
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.apply(localItem);
                    if (!localItem.isFolder()) continue;
                    this.fetchChilds(localItem.getId(), localItem.getNode());
                    continue;
                }
                throw new BoxFormatException("Fetched item was not added to local drive storage");
            }
            return items.parent;
        }

        @Deprecated
        protected String parentPath(BoxCollection path) {
            StringBuilder epath = new StringBuilder();
            Iterator pathEntries = path.getEntries().iterator();
            if (pathEntries.hasNext()) {
                BoxTypedObject root = (BoxTypedObject)pathEntries.next();
                String rootId = (String)root.getValue("id");
                if ("1".equals(rootId)) {
                    return null;
                }
                while (pathEntries.hasNext()) {
                    BoxTypedObject pe = (BoxTypedObject)pathEntries.next();
                    if (epath.length() > 1) {
                        epath.append('/');
                    }
                    epath.append(JCRLocalBoxDrive.this.cleanName((String)pe.getValue("name")));
                }
            } else {
                LOG.warn((Object)"Empty path collection");
            }
            return epath.toString();
        }

        protected BoxEvent readEvent() throws CloudDriveException {
            while (this.events.hasNext()) {
                BoxEvent next = (BoxEvent)this.events.next();
                this.newHistory.add(next.getId());
                if (this.history.contains(next.getId())) continue;
                ++this.readCounter;
                return next;
            }
            return null;
        }

        protected boolean hasNextEvent() throws CloudDriveException {
            if (this.nextEvent != null) {
                return true;
            }
            this.nextEvent = this.readEvent();
            if (this.nextEvent != null) {
                return true;
            }
            return this.postponed.size() > 0 && (this.lastPostponed == null || this.prevPostponedNumber > this.postponedNumber);
        }

        protected BoxEvent nextEvent() throws NoSuchElementException, AuthTokenException, CloudDriveException {
            BoxEvent event = null;
            if (this.nextEvent != null) {
                event = this.nextEvent;
                this.nextEvent = null;
            } else {
                event = this.readEvent();
            }
            if (event != null) {
                return event;
            }
            if (this.postponed.size() > 0) {
                BoxEvent firstPostponed;
                if (this.lastPostponed == null) {
                    this.lastPostponed = this.postponed.getLast();
                    this.postponedNumber = this.readCounter - this.appliedCounter;
                    this.prevPostponedNumber = Integer.MAX_VALUE;
                }
                if ((firstPostponed = this.postponed.poll()) == this.lastPostponed) {
                    this.prevPostponedNumber = this.postponedNumber;
                    this.postponedNumber = this.readCounter - this.appliedCounter;
                }
                return firstPostponed;
            }
            throw new NoSuchElementException("No more events.");
        }

        protected void postpone(BoxEvent event) {
            this.postponed.add(event);
        }

        protected boolean hasPostponed() {
            return this.postponed.size() > 0;
        }

        protected BoxItem undeleted(String itemId) {
            return this.undeleted.get(itemId);
        }

        protected void undelete(BoxItem item) {
            this.undeleted.put(item.getId(), item);
        }

        protected void apply(JCRLocalCloudFile local) {
            if (local.isChanged()) {
                this.applied.put(local.getId(), local);
                this.removed.remove(local.getPath());
                this.removedIds.remove(local.getId());
                this.changed.add(local);
                ++this.appliedCounter;
            }
        }

        protected JCRLocalCloudFile applied(String itemId) {
            return this.applied.get(itemId);
        }

        protected JCRLocalCloudFile remove(String itemId, String itemPath) {
            ++this.appliedCounter;
            this.removed.add(itemPath);
            this.removedIds.add(itemId);
            return this.applied.remove(itemId);
        }

        @Deprecated
        protected boolean isRemovedPath(String path) {
            for (String rpath : this.removed) {
                if (!path.startsWith(rpath)) continue;
                return true;
            }
            return false;
        }

        protected boolean isRemoved(String itemId) {
            return this.removedIds.contains(itemId);
        }
    }

    protected class FullSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final BoxAPI api;

        protected FullSync() throws RepositoryException, DriveRemovedException {
            super(JCRLocalBoxDrive.this);
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        @Override
        protected void syncFiles() throws RepositoryException, AuthTokenException, CloudDriveException {
            this.readLocalNodes();
            BoxAPI.EventsIterator eventsInit = this.api.getEvents(-1L);
            BoxFolder boxRoot = this.syncChilds("0", this.driveRoot);
            JCRLocalBoxDrive.this.initBoxItem(this.driveRoot, (BoxItem)boxRoot);
            this.driveRoot.setProperty("box:streamPosition", eventsInit.streamPosition);
            this.driveRoot.setProperty("box:streamHistory", "");
            this.driveRoot.setProperty("box:streamDate", Calendar.getInstance());
            this.nodes.remove("0");
            Iterator niter = this.nodes.values().iterator();
            while (niter.hasNext()) {
                List nls = (List)niter.next();
                niter.remove();
                for (Node n : nls) {
                    String npath = n.getPath();
                    if (!JCRLocalBoxDrive.this.notInRange(npath, this.removed)) continue;
                    this.removed.add(npath);
                    n.remove();
                }
            }
        }

        protected BoxFolder syncChilds(String folderId, Node parent) throws RepositoryException, CloudDriveException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(folderId);
            this.iterators.add(items);
            while (items.hasNext()) {
                BoxItem item = (BoxItem)items.next();
                List existing = (List)this.nodes.remove(item.getId());
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.changed.add(localItem);
                    if (existing != null) {
                        Iterator eiter = existing.iterator();
                        while (eiter.hasNext()) {
                            Node enode = (Node)eiter.next();
                            String path = localItem.getPath();
                            String epath = enode.getPath();
                            if (epath.equals(path) || !JCRLocalBoxDrive.this.notInRange(epath, this.removed)) continue;
                            this.removed.add(epath);
                            enode.remove();
                            eiter.remove();
                        }
                    }
                }
                if (!localItem.isFolder()) continue;
                this.syncChilds(localItem.getId(), localItem.getNode());
            }
            return items.parent;
        }

        @Override
        protected void exec() throws CloudDriveException, RepositoryException {
            super.exec();
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final BoxAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super(JCRLocalBoxDrive.this);
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            BoxAPI.EventsIterator eventsInit = this.api.getEvents(-1L);
            BoxFolder boxRoot = this.fetchChilds("0", this.driveRoot);
            JCRLocalBoxDrive.this.initBoxItem(this.driveRoot, (BoxItem)boxRoot);
            this.driveRoot.setProperty("ecd:url", this.api.getLink((BoxItem)boxRoot));
            this.driveRoot.setProperty("box:streamPosition", eventsInit.streamPosition);
            this.driveRoot.setProperty("box:streamHistory", "");
            this.driveRoot.setProperty("box:streamDate", Calendar.getInstance());
        }

        protected BoxFolder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext()) {
                BoxItem item = (BoxItem)items.next();
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.changed.add(localItem);
                    if (!localItem.isFolder()) continue;
                    this.fetchChilds(localItem.getId(), localItem.getNode());
                    continue;
                }
                throw new BoxFormatException("Fetched item was not added to local drive storage");
            }
            return items.parent;
        }
    }
}

