/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.googledrive;

import com.google.api.services.oauth2.model.Userinfo;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.googledrive.GoogleDriveAPI;
import org.exoplatform.clouddrive.googledrive.GoogleDriveException;
import org.exoplatform.clouddrive.googledrive.GoogleProvider;
import org.exoplatform.clouddrive.googledrive.GoogleUser;
import org.exoplatform.clouddrive.googledrive.JCRLocalGoogleDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class GoogleDriveConnector
extends CloudDriveConnector {
    public GoogleDriveConnector(RepositoryService jcrService, SessionProviderService sessionProviders, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, params);
    }

    @Override
    protected CloudProvider createProvider() {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(this.getConnectorSchema());
        redirectUrl.append("://");
        redirectUrl.append(this.getConnectorHost());
        redirectUrl.append("/portal/rest/clouddrive/connect/");
        redirectUrl.append(this.getProviderId());
        StringBuilder authUrl = new StringBuilder();
        authUrl.append("https://accounts.google.com/o/oauth2/auth?");
        authUrl.append("response_type=code&client_id=");
        authUrl.append(this.getClientId());
        authUrl.append("&approval_prompt=");
        authUrl.append("force");
        authUrl.append("&scope=");
        authUrl.append(GoogleDriveAPI.SCOPES_STRING);
        authUrl.append("&access_type=");
        authUrl.append("offline");
        authUrl.append("&state=");
        authUrl.append("__no_state_set__");
        authUrl.append("&redirect_uri=");
        authUrl.append((CharSequence)redirectUrl);
        return new GoogleProvider(this.getProviderId(), this.getProviderName(), authUrl.toString(), redirectUrl.toString(), this.jcrService);
    }

    @Override
    protected GoogleProvider getProvider() {
        return (GoogleProvider)super.getProvider();
    }

    @Override
    public GoogleUser authenticate(String code) throws CloudDriveException {
        if (code != null && code.length() > 0) {
            GoogleDriveAPI driveAPI = new API().auth(code).build();
            Userinfo userInfo = driveAPI.userInfo();
            GoogleUser user = new GoogleUser(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access key should not be null or empty");
    }

    @Override
    protected JCRLocalGoogleDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof GoogleUser) {
            return new JCRLocalGoogleDrive((GoogleUser)user, driveNode, this.sessionProviders);
        }
        throw new CloudDriveException("Not Google user: " + user);
    }

    @Override
    protected CloudDrive loadDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkTrashed(driveNode);
        return new JCRLocalGoogleDrive(new API(), this.getProvider(), driveNode, this.sessionProviders);
    }

    class API {
        String code;
        String userId;
        String refreshToken;
        String accessToken;
        long expirationTime;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String userId, String refreshToken, String accessToken, long expirationTime) {
            this.userId = userId;
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        GoogleDriveAPI build() throws GoogleDriveException, CloudDriveException {
            if (this.code != null && this.code.length() > 0) {
                return new GoogleDriveAPI(GoogleDriveConnector.this.getClientId(), GoogleDriveConnector.this.getClientSecret(), this.code, GoogleDriveConnector.this.getProvider().getRedirectUrl());
            }
            return new GoogleDriveAPI(GoogleDriveConnector.this.getClientId(), GoogleDriveConnector.this.getClientSecret(), this.userId, this.accessToken, this.refreshToken, this.expirationTime);
        }
    }
}

