/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.jcr.AbstractJCRAction;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveCloudFileAction
extends AbstractJCRAction {
    private static Log LOG = ExoLogger.getLogger(RemoveCloudFileAction.class);

    public boolean execute(Context context) throws Exception {
        Node fileNode = (Node)context.get((Object)InvocationContext.CURRENT_ITEM);
        CloudDriveService drives = this.drives(context);
        CloudDrive localDrive = drives.findDrive(fileNode);
        if (this.accept(localDrive)) {
            try {
                this.start(localDrive);
                throw new IllegalStateException(localDrive.getUser().getProvider().getName() + " file cannot be locally removed: " + fileNode.getPath());
            }
            catch (Throwable throwable) {
                this.done();
                throw throwable;
            }
        }
        return true;
    }
}

