/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.exodrive.ExoDriveProvider;
import org.exoplatform.clouddrive.exodrive.ExoDriveUser;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveRepository;
import org.exoplatform.clouddrive.exodrive.service.FileStore;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalExoDrive
extends JCRLocalCloudDrive {
    protected final ExoDriveRepository service;

    public JCRLocalExoDrive(ExoDriveUser user, ExoDriveRepository service, SessionProviderService sessionProviders, Node driveNode) throws CloudDriveException, RepositoryException {
        super(user, driveNode, sessionProviders);
        this.service = service;
    }

    @Override
    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", driveNode.getName());
        driveNode.setProperty("ecd:url", "#");
    }

    public JCRLocalExoDrive(ExoDriveRepository service, ExoDriveProvider provider, SessionProviderService sessionProviders, Node driveNode) throws CloudDriveException, RepositoryException {
        super(new ExoDriveUser(driveNode.getProperty("ecd:cloudUserName").getString(), driveNode.getProperty("ecd:userEmail").getString(), provider), driveNode, sessionProviders);
        this.service = service;
    }

    @Override
    public ExoDriveUser getUser() {
        return (ExoDriveUser)this.user;
    }

    @Override
    public String getChangesLink() throws DriveRemovedException, RepositoryException {
        return null;
    }

    @Override
    public void updateChangesLink() throws DriveRemovedException, CloudProviderException, RepositoryException {
    }

    @Override
    protected boolean isSyncSupported(CloudFile cloudFile) {
        return false;
    }

    @Override
    protected void checkAccess() throws CloudDriveException {
    }

    @Override
    protected void updateAccess(CloudUser user) throws CloudDriveException {
    }

    @Override
    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new ExoDriveConnect();
    }

    @Override
    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new ExoDriveSync();
    }

    @Override
    protected JCRLocalCloudDrive.SyncFileCommand getSyncFileCommand(Node file) throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new ExoDriveFileSync(file);
    }

    class ExoDriveFileSync
    extends JCRLocalCloudDrive.SyncFileCommand {
        public ExoDriveFileSync(Node file) throws RepositoryException, DriveRemovedException, SyncNotSupportedException {
            super(JCRLocalExoDrive.this, file);
        }

        @Override
        public long getComplete() {
            return 100L;
        }

        @Override
        public long getAvailable() {
            return 100L;
        }

        @Override
        protected void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException {
        }
    }

    class ExoDriveSync
    extends JCRLocalCloudDrive.SyncCommand {
        volatile int complete;
        volatile int available;

        public ExoDriveSync() throws RepositoryException, DriveRemovedException {
            super(JCRLocalExoDrive.this);
        }

        @Override
        protected void syncFiles() throws CloudDriveException, RepositoryException {
            try {
                List<FileStore> files = JCRLocalExoDrive.this.service.listFiles(JCRLocalExoDrive.this.user.getUsername());
                this.available = files.size();
                for (FileStore f : files) {
                    Node localNode = JCRLocalExoDrive.this.openFile(f.getId(), f.getName(), f.getType(), this.rootNode);
                    JCRLocalExoDrive.this.initFile(localNode, f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate());
                    this.changed.add(new JCRLocalCloudFile(localNode.getPath(), f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate(), false));
                    ++this.complete;
                }
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Cannot list files for user " + JCRLocalExoDrive.this.user.getUsername(), e);
            }
        }

        @Override
        public long getComplete() {
            return this.complete;
        }

        @Override
        public long getAvailable() {
            return this.available;
        }
    }

    class ExoDriveConnect
    extends JCRLocalCloudDrive.ConnectCommand {
        volatile int complete;
        volatile int available;

        public ExoDriveConnect() throws RepositoryException, DriveRemovedException {
            super(JCRLocalExoDrive.this);
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            try {
                List<FileStore> files = JCRLocalExoDrive.this.service.listFiles(JCRLocalExoDrive.this.user.getUsername());
                this.available = files.size();
                for (FileStore f : files) {
                    Node localNode = JCRLocalExoDrive.this.openFile(f.getId(), f.getName(), f.getType(), this.rootNode);
                    JCRLocalExoDrive.this.initFile(localNode, f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate());
                    this.changed.add(new JCRLocalCloudFile(localNode.getPath(), f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate(), false));
                    ++this.complete;
                }
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Cannot list files for user " + JCRLocalExoDrive.this.user.getUsername(), e);
            }
        }

        @Override
        public long getComplete() {
            return this.complete;
        }

        @Override
        public long getAvailable() {
            return this.available;
        }
    }
}

