/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;

public class FileStore {
    public static final String METADIR_NAME = ".exodrive";
    public static final String METAFILE_EXT = ".edi";
    public static final FileDateFormat METAFILE_DATEFORMAT = new FileDateFormat("yyyy-MM-dd-hh:mm:ss.SSSZ");
    public static final String META_ID = "id";
    public static final String META_TYPE = "type";
    public static final String META_AUTHOR = "author";
    public static final String META_LASTUSER = "lastuser";
    public static final String META_CREATEDATE = "createdate";
    public static final String META_MODIFIEDDATE = "modifiydate";
    public static final int IOBUFFER_SIZE = 16384;
    protected final File local;
    protected final String id;
    protected final String link;
    protected final String type;
    protected final String author;
    protected final Calendar createDate;
    protected String lastUser;
    protected Calendar modifiedDate;

    FileStore(File local, String id, String link, String type, String author, String lastUser, Calendar createDate, Calendar modifiedDate) {
        this.local = local;
        this.id = id;
        this.link = link;
        this.type = type;
        this.author = author;
        this.lastUser = lastUser;
        this.createDate = createDate;
        this.modifiedDate = modifiedDate;
    }

    public InputStream read() throws ExoDriveException {
        try {
            return new FileInputStream(this.local);
        }
        catch (FileNotFoundException e) {
            throw new ExoDriveException("File not found " + this.local.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(InputStream content) throws ExoDriveException {
        if (this.local.isFile()) {
            long l;
            FileOutputStream out = new FileOutputStream(this.local);
            try {
                FileChannel outch = out.getChannel();
                ReadableByteChannel inch = content instanceof FileInputStream && FileInputStream.class.equals(content.getClass()) ? ((FileInputStream)content).getChannel() : Channels.newChannel(content);
                long size = 0L;
                int r = 0;
                ByteBuffer buff = ByteBuffer.allocate(16384);
                buff.clear();
                while ((r = inch.read(buff)) >= 0) {
                    buff.flip();
                    do {
                        outch.write(buff);
                    } while (buff.hasRemaining());
                    buff.clear();
                    size += (long)r;
                }
                outch.force(true);
                this.update(this.author, Calendar.getInstance());
                l = size;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ExoDriveException("File cannot be saved " + this.local.getName(), e);
                }
            }
            out.close();
            return l;
        }
        throw new ExoDriveException("Cannot write to directory " + this.local.getAbsolutePath());
    }

    public void remove() throws ExoDriveException {
        if (this.local.exists()) {
            File metaDir = new File(this.local.getParent(), METADIR_NAME);
            File meta = new File(metaDir, this.local.getName() + METAFILE_EXT);
            if (!meta.delete()) {
                meta.deleteOnExit();
            }
            if (!this.local.delete()) {
                this.local.deleteOnExit();
            }
        } else {
            throw new ExoDriveException("File not found " + this.local.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(String lastUser, Calendar modifiedDate) throws ExoDriveException {
        block11: {
            try {
                if (this.local.exists() && this.local.isFile()) {
                    File metaDir = new File(this.local.getParent(), METADIR_NAME);
                    File meta = new File(metaDir, this.local.getName() + METAFILE_EXT);
                    Properties metap = new Properties();
                    FileInputStream in = new FileInputStream(meta);
                    try {
                        metap.load(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    metap.put(META_LASTUSER, lastUser);
                    metap.put(META_MODIFIEDDATE, METAFILE_DATEFORMAT.format(modifiedDate.getTime()));
                    if (lastUser != null && modifiedDate != null) {
                        this.lastUser = lastUser;
                        this.modifiedDate = modifiedDate;
                        FileOutputStream out = new FileOutputStream(meta);
                        try {
                            metap.store(out, "Metadata for " + this.local.getAbsolutePath() + ". Generated at " + METAFILE_DATEFORMAT.format(Calendar.getInstance().getTime()));
                            break block11;
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                    }
                    throw new ExoDriveException("Cloud file " + this.local.getName() + " metadata cannot be null.");
                }
                throw new ExoDriveException("Local cloud drive not exists or it's a folder " + this.local.getName());
            }
            catch (IOException ioe) {
                throw new ExoDriveException("Cannot create cloud file in storage " + this.local.getName(), ioe);
            }
        }
    }

    public String getName() {
        return this.local.getName();
    }

    public boolean isFolder() {
        return this.local.isDirectory();
    }

    public String getLastUser() {
        return this.lastUser;
    }

    public Calendar getModifiedDate() {
        return this.modifiedDate;
    }

    public String getId() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public String getType() {
        return this.type;
    }

    public String getAuthor() {
        return this.author;
    }

    public Calendar getCreateDate() {
        return this.createDate;
    }

    File getFile() {
        return this.local;
    }

    static class FileDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 2373038959548713771L;

        FileDateFormat(String pattern) {
            super(pattern);
        }

        Calendar parseCalendar(String source) throws ParseException {
            super.parse(source);
            return (Calendar)this.calendar.clone();
        }
    }
}

