/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.requests.requestobjects;

import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import org.apache.commons.lang.StringUtils;

public class BoxCollabRequestObject
extends BoxDefaultRequestObject {
    private BoxCollabRequestObject() {
    }

    public static BoxCollabRequestObject createCollaborationObject(String folderId, String userId, String login, String role) {
        MapJSONStringEntity item = BoxCollabRequestObject.getItemEntity(folderId);
        MapJSONStringEntity accessibleBy = BoxCollabRequestObject.getAccessibilityEntity(userId, login);
        return new BoxCollabRequestObject().setItem(item).setAccessibleBy(accessibleBy).setRole(role);
    }

    public static BoxCollabRequestObject updateCollaborationObject(String role) {
        return new BoxCollabRequestObject().setRole(role);
    }

    public static BoxCollabRequestObject getAllCollaborationsRequestObject(String status) {
        return new BoxCollabRequestObject().setStatus(status);
    }

    public MapJSONStringEntity getItem() {
        return (MapJSONStringEntity)this.get("item");
    }

    public MapJSONStringEntity getAccessible_by() {
        return (MapJSONStringEntity)this.get("accessible_by");
    }

    public String getRole() {
        return (String)this.get("role");
    }

    public String getStatus() {
        return this.getQueryParams().get("status");
    }

    public BoxCollabRequestObject setStatus(String status) {
        this.addQueryParam("status", status);
        return this;
    }

    private BoxCollabRequestObject setItem(MapJSONStringEntity item) {
        this.put("item", item);
        return this;
    }

    private BoxCollabRequestObject setAccessibleBy(MapJSONStringEntity accessibleBy) {
        super.put("accessible_by", accessibleBy);
        return this;
    }

    private BoxCollabRequestObject setRole(String role) {
        this.put("role", role);
        return this;
    }

    private static MapJSONStringEntity getItemEntity(String folderId) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put("id", folderId);
        entity.put("type", BoxResourceType.FOLDER.toString());
        return entity;
    }

    private static MapJSONStringEntity getAccessibilityEntity(String userId, String login) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        if (StringUtils.isNotEmpty((String)userId)) {
            entity.put("id", userId);
        }
        entity.put("login", login);
        return entity;
    }
}

