/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class CloudDriveConnector
extends BaseComponentPlugin {
    public static final String CONFIG_PROVIDER_NAME = "provider-name";
    public static final String CONFIG_PROVIDER_ID = "provider-id";
    public static final String CONFIG_CONNECTOR_HOST = "connector-host";
    public static final String CONFIG_CONNECTOR_SCHEMA = "connector-schema";
    public static final String CONFIG_PROVIDER_CLIENT_ID = "provider-client-id";
    public static final String CONFIG_PROVIDER_CLIENT_SECRET = "provider-client-secret";
    public static final int PROVIDER_REQUEST_ATTEMPTS = 3;
    public static final long PROVIDER_REQUEST_ATTEMPT_TIMEOUT = 10000L;
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveConnector.class);
    protected final Map<String, String> config;
    protected final SessionProviderService sessionProviders;
    protected final RepositoryService jcrService;
    protected final NodeFinder jcrFinder;
    protected final CloudProvider provider;
    protected final String connectorHost;
    protected final String connectorSchema;

    protected CloudDriveConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder jcrFinder, InitParams params) throws ConfigurationException {
        this.sessionProviders = sessionProviders;
        this.jcrService = jcrService;
        this.jcrFinder = jcrFinder;
        PropertiesParam param = params.getPropertiesParam("drive-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters drive-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        String connectorSchema = this.config.get(CONFIG_CONNECTOR_SCHEMA);
        if (connectorSchema == null || connectorSchema.trim().length() == 0) {
            connectorSchema = "http";
        }
        this.connectorSchema = connectorSchema;
        String connectorHost = this.config.get(CONFIG_CONNECTOR_HOST);
        if (connectorHost != null && connectorHost.length() > 0) {
            this.connectorHost = connectorHost;
        } else {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (connectorHost == null && interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (connectorHost == null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress()) continue;
                        connectorHost = address.getHostName();
                    }
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
            if (connectorHost == null) {
                try {
                    connectorHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    connectorHost = "localhost";
                }
            }
            this.connectorHost = connectorHost;
            LOG.warn((Object)("Configuration of connector-host is not set, will use " + connectorHost));
        }
        this.provider = this.createProvider();
    }

    protected SessionProvider sessionProvider() throws RepositoryException {
        return this.sessionProviders.getSessionProvider(null);
    }

    protected String getConnectorHost() {
        return this.connectorHost;
    }

    protected String getConnectorSchema() {
        return this.connectorSchema;
    }

    protected String getProviderName() {
        return this.config.get(CONFIG_PROVIDER_NAME);
    }

    protected String getProviderId() {
        return this.config.get(CONFIG_PROVIDER_ID);
    }

    protected String getClientId() {
        return this.config.get(CONFIG_PROVIDER_CLIENT_ID);
    }

    protected String getClientSecret() {
        return this.config.get(CONFIG_PROVIDER_CLIENT_SECRET);
    }

    Set<CloudDrive> loadStored(Set<Node> driveNodes) throws RepositoryException, CloudDriveException {
        HashSet<CloudDrive> connected = new HashSet<CloudDrive>();
        for (Node driveNode : driveNodes) {
            try {
                connected.add(this.loadDrive(driveNode));
            }
            catch (DriveRemovedException e) {
                LOG.warn((Object)("Node removed and cannot be loaded as Cloud Drive: " + e.getMessage()));
            }
        }
        return connected;
    }

    protected CloudProvider getProvider() {
        return this.provider;
    }

    protected abstract CloudProvider createProvider();

    protected abstract CloudUser authenticate(String var1) throws CloudDriveException;

    protected abstract CloudDrive createDrive(CloudUser var1, Node var2) throws CloudDriveException, RepositoryException;

    protected abstract CloudDrive loadDrive(Node var1) throws CloudDriveException, RepositoryException;
}

