/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/changes/")
@Produces(value={"application/json"})
public class ChangesService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ChangesService.class);
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;

    public ChangesService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @POST
    @RolesAllowed(value={"users"})
    @Deprecated
    public Response asyncSynchronization(@Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            CloudDrive.Command sync = local.synchronize();
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{\"syncDone\":\"" + sync.isDone() + "\",\"startTime\":\"" + sync.getStartTime() + "\",\"finishTime\":\"" + sync.getFinishTime() + "\"}")).build();
                        }
                        catch (RefreshAccessException e) {
                            LOG.warn((Object)"Request to cloud drive forbidden or revoked.", (Throwable)e);
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        catch (DriveRemovedException e) {
                            LOG.warn((Object)("Cannot run asynchronous syncronization on removed drive " + workspace + ":" + path + ". " + e.getMessage()));
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Synchronization canceled. " + e.getMessage())).build();
                        }
                        catch (CloudDriveException e) {
                            LOG.error((Object)("Error starting asynchronous synchronization on drive " + workspace + ":" + path), (Throwable)e);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error starting asynchronous synchronization. " + e.getMessage())).build();
                        }
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (PathNotFoundException e) {
                    LOG.warn((Object)("Cannot run asynchronous syncronization for not existing node " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Synchronization canceled. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/link/")
    @RolesAllowed(value={"users"})
    public Response getChangesLink(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            local.updateChangesLink();
                            String link = local.getChangesLink();
                            if (link != null) {
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"changesLink\":\"" + link + "\"}")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Changes link not provided").build();
                        }
                        catch (RefreshAccessException e) {
                            Throwable cause = e.getCause();
                            LOG.warn((Object)("Access to cloud drive expired, forbidden or revoked. " + e.getMessage() + (cause != null ? ". " + cause.getMessage() : "")));
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        catch (CloudDriveException e) {
                            LOG.error((Object)("Error getting changes link for drive " + workspace + ":" + path), (Throwable)e);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting changes link. " + e.getMessage())).build();
                        }
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }
}

