/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.utils;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.security.IdentityConstants;

public class IdentityHelper {
    public static final String ROOT_USER_ID = "root";
    public static final String SYSTEM_USER_ID = IdentityConstants.SYSTEM;

    private IdentityHelper() {
    }

    public static boolean isUserMatch(String user1, String user2) {
        return user1.equals(user2) || ROOT_USER_ID.equals(user1) || SYSTEM_USER_ID.equals(user1) || ROOT_USER_ID.equals(user2) || SYSTEM_USER_ID.equals(user2);
    }

    public static Node ensureOwned(Node node, Session systemSession) throws PathNotFoundException, RepositoryException {
        String currentUser = node.getSession().getUserID();
        if (!currentUser.equals(SYSTEM_USER_ID) && node.isNodeType("exo:owneable") && !node.getProperty("exo:owner").getString().equals(currentUser)) {
            Node snode = (Node)systemSession.getItem(node.getPath());
            snode.removeMixin("exo:owneable");
            snode.save();
            node.refresh(true);
            node.addMixin("exo:owneable");
            node.save();
        }
        return node;
    }
}

