/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.filetransfer;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxObject;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxMalformedResponseException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.httpentities.MultipartEntityWithProgressListener;
import com.box.boxjavalibv2.requests.UploadFileRequest;
import com.box.boxjavalibv2.requests.UploadNewVersionFileRequest;
import com.box.boxjavalibv2.resourcemanagers.BoxFilesManagerImpl;
import com.box.boxjavalibv2.utils.Utils;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;

public class BoxFileUpload {
    private final IBoxConfig mConfig;

    public BoxFileUpload(IBoxConfig config) {
        this.mConfig = config;
    }

    public BoxFile execute(BoxFilesManagerImpl manager, BoxFileUploadRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException, InterruptedException {
        UploadFileRequest request = new UploadFileRequest(this.mConfig, manager.getJSONParser(), requestObject);
        try {
            Object result = manager.getResponseAndParse(request, BoxResourceType.FILES, manager.getJSONParser());
            BoxCollection collection = (BoxCollection)manager.tryCastObject(BoxResourceType.FILES, result);
            Class<? extends BoxObject> cls = manager.getResourceHub().getClass(BoxResourceType.FILE);
            return (BoxFile)Utils.getTypedObjects(collection, cls).get(0);
        }
        catch (BoxRestException e) {
            if (this.isInterruptedMultipartException(e)) {
                throw new InterruptedException();
            }
            throw e;
        }
    }

    public BoxFile execute(String fileId, BoxFilesManagerImpl manager, BoxFileUploadRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException, InterruptedException {
        UploadNewVersionFileRequest request = new UploadNewVersionFileRequest(this.mConfig, manager.getJSONParser(), fileId, requestObject);
        try {
            Object result = manager.getResponseAndParse(request, BoxResourceType.FILE_VERSIONS, manager.getJSONParser());
            BoxCollection versions = (BoxCollection)manager.tryCastObject(BoxResourceType.FILE_VERSIONS, result);
            if (versions.getTotalCount() != 1) {
                throw new BoxMalformedResponseException(request.getExpectedResponseCode());
            }
            return (BoxFile)versions.getEntries().get(0);
        }
        catch (BoxRestException e) {
            if (this.isInterruptedMultipartException(e)) {
                throw new InterruptedException();
            }
            throw e;
        }
    }

    private boolean isInterruptedMultipartException(BoxRestException e) {
        Throwable t = e.getCause();
        return t != null && t instanceof MultipartEntityWithProgressListener.InterruptedMultipartException;
    }
}

