/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.dao.IBoxType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedHttpStatusException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedStatus;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.resourcemanagers.IBoxResourceManager;
import com.box.boxjavalibv2.responseparsers.BoxObjectResponseParser;
import com.box.boxjavalibv2.responseparsers.ErrorResponseParser;
import com.box.boxjavalibv2.utils.Utils;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.DefaultBoxRequest;
import com.box.restclientv2.responses.DefaultBoxResponse;

public abstract class AbstractBoxResourceManager
implements IBoxResourceManager {
    private final IBoxConfig mConfig;
    private final IBoxResourceHub mResourceHub;
    private final IBoxJSONParser mParser;
    private final IBoxRequestAuth mAuth;
    private final IBoxRESTClient mRestClient;

    public AbstractBoxResourceManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        this.mConfig = config;
        this.mResourceHub = resourceHub;
        this.mParser = parser;
        this.mAuth = auth;
        this.mRestClient = restClient;
    }

    public IBoxRequestAuth getAuth() {
        return this.mAuth;
    }

    protected IBoxRESTClient getRestClient() {
        return this.mRestClient;
    }

    public IBoxResourceHub getResourceHub() {
        return this.mResourceHub;
    }

    public IBoxJSONParser getJSONParser() {
        return this.mParser;
    }

    public IBoxConfig getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRequestWithNoResponseBody(DefaultBoxRequest request) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        try {
            if (response.getExpectedResponseCode() != response.getResponseStatusCode()) {
                ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
                BoxServerError error = (BoxServerError)errorParser.parse(response);
                if (error == null) {
                    throw new BoxServerException("Unexpected response code:" + response.getResponseStatusCode() + ", expecting:" + response.getExpectedResponseCode(), response.getResponseStatusCode());
                }
                throw new BoxServerException(error);
            }
        }
        finally {
            Utils.consumeHttpEntityQuietly(response.getHttpResponse().getEntity());
        }
    }

    public Object getResponseAndParseAndTryCast(DefaultBoxRequest request, IBoxType type, IBoxJSONParser parser) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        Object obj = this.getResponseAndParse(request, type, parser);
        return this.tryCastObject(type, obj);
    }

    public Object getResponseAndParse(DefaultBoxRequest request, IBoxType type, IBoxJSONParser parser) throws BoxRestException, AuthFatalFailureException {
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        BoxObjectResponseParser responseParser = new BoxObjectResponseParser(this.getClassFromType(type), parser);
        ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
        return response.parseResponse(responseParser, errorParser);
    }

    public Object tryCastObject(IBoxType expectedType, Object obj) throws BoxServerException, BoxRestException {
        if (obj instanceof BoxServerError) {
            throw new BoxServerException((BoxServerError)obj);
        }
        if (obj instanceof BoxUnexpectedStatus) {
            throw new BoxUnexpectedHttpStatusException((BoxUnexpectedStatus)obj);
        }
        Class expectedClass = this.getClassFromType(expectedType);
        if (expectedClass.isInstance(obj)) {
            return obj;
        }
        if (obj == null) {
            throw new BoxRestException("Invalid class, expected:" + expectedClass.getCanonicalName());
        }
        throw new BoxRestException("Invalid class, expected:" + expectedClass.getCanonicalName() + ";current:" + obj.getClass().getCanonicalName());
    }

    protected Class getClassFromType(IBoxType type) {
        return this.getResourceHub().getClass(type);
    }

    protected Object tryCastBoxItem(BoxResourceType type, Object item) throws BoxServerException, BoxRestException {
        return this.tryCastObject(type, item);
    }
}

