/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollaboration;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateCollaborationRequest;
import com.box.boxjavalibv2.requests.DeleteCollaborationRequest;
import com.box.boxjavalibv2.requests.GetAllCollaborationsRequest;
import com.box.boxjavalibv2.requests.GetCollaborationRequest;
import com.box.boxjavalibv2.requests.UpdateCollaborationRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxCollabRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxGetAllCollabsRequestObject;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxCollaborationsManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoxCollaborationsManagerImpl
extends AbstractBoxResourceManager
implements IBoxCollaborationsManager {
    public BoxCollaborationsManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    @Override
    public BoxCollaboration getCollaboration(String collabId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetCollaborationRequest request = new GetCollaborationRequest(this.getConfig(), this.getJSONParser(), collabId, requestObject);
        return (BoxCollaboration)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATION, this.getJSONParser());
    }

    @Override
    public BoxCollaboration createCollaboration(String folderId, BoxCollabRequestObject collabObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateCollaborationRequest request = new CreateCollaborationRequest(this.getConfig(), this.getJSONParser(), folderId, collabObject);
        return (BoxCollaboration)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATION, this.getJSONParser());
    }

    @Override
    public List<BoxCollaboration> getAllCollaborations(BoxGetAllCollabsRequestObject collabObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetAllCollaborationsRequest request = new GetAllCollaborationsRequest(this.getConfig(), this.getJSONParser(), collabObject);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATIONS, this.getJSONParser());
        return BoxCollaborationsManagerImpl.getCollaborations(collection);
    }

    @Override
    public void deleteCollaboration(String collabId, BoxDefaultRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        DeleteCollaborationRequest request = new DeleteCollaborationRequest(this.getConfig(), this.getJSONParser(), collabId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public BoxCollaboration updateCollaboration(String collabId, BoxCollabRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        UpdateCollaborationRequest request = new UpdateCollaborationRequest(this.getConfig(), this.getJSONParser(), collabId, requestObject);
        return (BoxCollaboration)super.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATION, this.getJSONParser());
    }

    @Deprecated
    public static List<BoxCollaboration> getCollaborations(BoxCollection collection) {
        ArrayList<BoxCollaboration> collabs = new ArrayList<BoxCollaboration>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxCollaboration)) continue;
            collabs.add((BoxCollaboration)object);
        }
        return collabs;
    }
}

