/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.requestsbase;

import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class BoxOAuthRequestObject
extends BoxDefaultRequestObject {
    private static final String GRANT_TYPE = "grant_type";
    private static final String CODE = "code";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String REDIRECT_URL = "redirect_url";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String REVOKE_TOKEN = "token";
    private static final String DEVICE_ID = "box_device_id";
    private static final String DEVICE_NAME = "box_device_name";

    public static BoxOAuthRequestObject createOAuthRequestObject(String code, String clientId, String clientSecret, String redirectUrl) {
        BoxOAuthRequestObject obj = new BoxOAuthRequestObject();
        return obj.setAuthCode(code).setClient(clientId, clientSecret).setRedirectUrl(redirectUrl);
    }

    public static BoxOAuthRequestObject refreshOAuthRequestObject(String refreshToken, String clientId, String clientSecret) {
        BoxOAuthRequestObject obj = new BoxOAuthRequestObject();
        return obj.setRefreshToken(refreshToken).setClient(clientId, clientSecret);
    }

    public static BoxOAuthRequestObject revokeOAuthRequestObject(String revokeToken, String clientId, String clientSecret) {
        BoxOAuthRequestObject obj = new BoxOAuthRequestObject();
        return obj.setRevokeToken(revokeToken).setClient(clientId, clientSecret);
    }

    public BoxOAuthRequestObject setRevokeToken(String token) {
        this.put(REVOKE_TOKEN, token);
        return this;
    }

    public BoxOAuthRequestObject setRefreshToken(String refreshToken) {
        this.put(GRANT_TYPE, REFRESH_TOKEN);
        this.put(REFRESH_TOKEN, refreshToken);
        return this;
    }

    public BoxOAuthRequestObject setAuthCode(String code) {
        this.put(GRANT_TYPE, AUTHORIZATION_CODE);
        this.put(CODE, code);
        return this;
    }

    public BoxOAuthRequestObject setClient(String clientId, String clientSecret) {
        this.put(CLIENT_ID, clientId);
        this.put(CLIENT_SECRET, clientSecret);
        return this;
    }

    public BoxOAuthRequestObject setRedirectUrl(String redirectUrl) {
        this.put(REDIRECT_URL, redirectUrl);
        return this;
    }

    public BoxOAuthRequestObject setDevice(String deviceId, String deviceName) {
        if (StringUtils.isNotEmpty((String)deviceId) && StringUtils.isNotEmpty((String)deviceName)) {
            this.put(DEVICE_ID, deviceId);
            this.put(DEVICE_NAME, deviceName);
        }
        return this;
    }

    public UrlEncodedFormEntity getEntity(IBoxJSONParser parser) throws BoxRestException {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry entry : this.getJSONEntity().entrySet()) {
            String strValue;
            Object value = entry.getValue();
            if (value == null || !(value instanceof String) || !StringUtils.isNotEmpty((String)(strValue = (String)value))) continue;
            pairs.add(new BasicNameValuePair((String)entry.getKey(), strValue));
        }
        try {
            return new UrlEncodedFormEntity(pairs, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }
}

