/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;

public class JCRNodeFinder
implements NodeFinder {
    protected final RepositoryService jcrService;

    public JCRNodeFinder(RepositoryService jcrService) {
        this.jcrService = jcrService;
    }

    @Override
    public Item getItem(Session userSession, String path, boolean symlinkTarget) throws PathNotFoundException, RepositoryException {
        return userSession.getItem(path);
    }

    @Override
    public Item findItem(Session userSession, String path) throws PathNotFoundException, RepositoryException {
        return userSession.getItem(path);
    }

    @Override
    public Collection<Node> findLinked(Session session, String uuid) throws PathNotFoundException, RepositoryException {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        try {
            Node target = session.getNodeByUUID(uuid);
            PropertyIterator piter = target.getReferences();
            while (piter.hasNext()) {
                res.add(piter.nextProperty().getParent());
            }
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        return res;
    }

    @Override
    public String cleanName(String name) {
        return name;
    }
}

