/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveConfigurationException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.FileStore;
import org.exoplatform.clouddrive.exodrive.service.NotFoundException;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoDriveRepository {
    protected static final Log LOG = ExoLogger.getLogger(ExoDriveRepository.class);
    protected final String name;
    protected final File baseDir;
    protected final String baseUrl;
    protected final MimeTypeResolver mimeResolver;

    ExoDriveRepository(String name, File baseDir, String baseUrl, MimeTypeResolver mimeResolver) throws ExoDriveConfigurationException {
        this.name = name;
        this.baseUrl = baseUrl;
        this.baseDir = baseDir;
        this.mimeResolver = mimeResolver;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileStore openStore(String ownerName, File file) throws ExoDriveException {
        try {
            File metaDir = new File(file.getParent(), ".exodrive");
            File meta = new File(metaDir, file.getName() + ".edi");
            Properties metap = new Properties();
            FileInputStream in = new FileInputStream(meta);
            try {
                metap.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            String id = metap.getProperty("id");
            String type = metap.getProperty("type");
            String author = metap.getProperty("author");
            String lastUser = metap.getProperty("lastuser");
            try {
                Calendar createDate = FileStore.METAFILE_DATEFORMAT.parseCalendar(metap.getProperty("createdate"));
                Calendar modifiedDate = FileStore.METAFILE_DATEFORMAT.parseCalendar(metap.getProperty("modifiydate"));
                if (id != null && type != null && author != null && lastUser != null && createDate != null && modifiedDate != null) {
                    return new FileStore(file, id, this.fileLink(ownerName, file.getName()), type, author, author, createDate, createDate);
                }
            }
            catch (ParseException e) {
                throw new ExoDriveException("Cloud file storage " + file + " metadata inconsistent.", e);
            }
            throw new ExoDriveException("Cloud file storage " + file + " metadata inconsistent.");
        }
        catch (IOException e) {
            throw new ExoDriveException("Cannot read cloud file from storage " + file, e);
        }
    }

    File getBaseDir() {
        return this.baseDir;
    }

    File userRoot(String user) {
        return new File(this.baseDir, user);
    }

    String fileLink(String ownerName, String path) {
        return this.baseUrl + "/" + ownerName + "/" + path;
    }

    String generateId(File parentDir, String path) {
        String idpath = parentDir.getAbsolutePath() + "_secret_" + path;
        return UUID.nameUUIDFromBytes(idpath.getBytes()).toString();
    }

    File findFile(File userDir, String path) throws ExoDriveException {
        List<String> pathFiles = Arrays.asList(path.split("/"));
        File parent = userDir;
        File file = null;
        Iterator<String> piter = pathFiles.iterator();
        while (piter.hasNext()) {
            String pfn = piter.next();
            File pf = new File(parent, pfn);
            if (piter.hasNext()) {
                if (pf.exists()) {
                    if (pf.isDirectory()) {
                        parent = pf;
                        continue;
                    }
                    throw new ExoDriveException("File found on the parent path '" + path + "', folder expected: " + pf.getPath());
                }
                throw new ExoDriveException("Parent path not found '" + path + "', folder doesn't exist: " + pf.getPath());
            }
            if (pf.exists()) {
                throw new ExoDriveException("File already exists " + pf.getPath());
            }
            file = pf;
        }
        return file;
    }

    public boolean exists(String ownerName, String path) {
        File file = path != null ? new File(this.userRoot(ownerName), path) : this.userRoot(ownerName);
        return file.exists();
    }

    public boolean userExists(String ownerName) {
        File file = this.userRoot(ownerName);
        return file.exists();
    }

    public boolean createUser(String ownerName) {
        File file = this.userRoot(ownerName);
        file.mkdirs();
        return file.exists();
    }

    public boolean removeUser(String ownerName) throws ExoDriveException {
        File file = this.userRoot(ownerName);
        for (FileStore fs : this.listFiles(ownerName)) {
            fs.remove();
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStore create(String ownerName, String path, String type, Calendar createDate) throws ExoDriveException {
        File userDir = this.userRoot(ownerName);
        if (userDir.exists()) {
            File file = this.findFile(userDir, path);
            if (file == null) {
                throw new ExoDriveException("File cannot be created with such path '" + path + "'");
            }
            try {
                if ("application/vnd.exoplatform.exodrive-folder".equals(type)) {
                    if (!file.mkdir()) {
                        throw new ExoDriveException("Cannot crate new folder " + file.getPath());
                    }
                } else if (!file.createNewFile()) {
                    throw new ExoDriveException("Cannot create new file" + file.getPath());
                }
                File metaDir = new File(userDir, ".exodrive");
                metaDir.mkdirs();
                File meta = new File(metaDir, path + ".edi");
                String id = this.generateId(userDir, path);
                String mimeType = type != null ? type : this.mimeResolver.getMimeType(path);
                Properties metap = new Properties();
                metap.put("id", id);
                metap.put("type", mimeType);
                metap.put("author", ownerName);
                metap.put("lastuser", ownerName);
                metap.put("createdate", FileStore.METAFILE_DATEFORMAT.format(createDate.getTime()));
                metap.put("modifiydate", FileStore.METAFILE_DATEFORMAT.format(createDate.getTime()));
                FileStore local = new FileStore(file, id, this.fileLink(ownerName, file.getName()), mimeType, ownerName, ownerName, createDate, createDate);
                FileOutputStream out = new FileOutputStream(meta);
                try {
                    metap.store(out, "Metadata for " + file.getAbsolutePath() + ". Generated at " + FileStore.METAFILE_DATEFORMAT.format(Calendar.getInstance().getTime()));
                }
                finally {
                    ((OutputStream)out).close();
                }
                return local;
            }
            catch (IOException ioe) {
                throw new ExoDriveException("Cannot create file in storage " + file, ioe);
            }
        }
        LOG.warn((Object)("User not found: " + ownerName + ". Requested file not created '" + path + "' as parent not found " + userDir.getAbsolutePath()));
        throw new NotFoundException("User not found: " + ownerName + ". Requested file not created " + path);
    }

    public FileStore read(String ownerName, String path) throws ExoDriveException {
        File userDir = this.userRoot(ownerName);
        File file = this.findFile(userDir, path);
        if (file != null && file.exists()) {
            return this.openStore(ownerName, file);
        }
        LOG.warn((Object)("User not found: " + ownerName + ". Requested storage not exists " + userDir.getAbsolutePath()));
        throw new NotFoundException(userDir.exists() ? "Cloud file " + path + " not found." : "User not found " + ownerName);
    }

    public List<FileStore> listFiles(String ownerName) throws ExoDriveException {
        ArrayList<FileStore> res = new ArrayList<FileStore>();
        File userDir = this.userRoot(ownerName);
        File[] userFiles = userDir.listFiles();
        if (userFiles != null) {
            for (File f : userFiles) {
                res.add(this.openStore(ownerName, f));
            }
        } else {
            LOG.warn((Object)("User not found: " + ownerName + ". Requested storage not exists " + userDir.getAbsolutePath()));
            throw new NotFoundException("User not found " + ownerName);
        }
        return res;
    }

    public List<FileStore> listFiles(String ownerName, FileStore parentDir) throws ExoDriveException {
        File userDir = this.userRoot(ownerName);
        if (parentDir.getFile().getAbsolutePath().startsWith(userDir.getAbsolutePath())) {
            ArrayList<FileStore> res = new ArrayList<FileStore>();
            if (parentDir.isFolder()) {
                throw new NotFoundException("Parent not a folder " + parentDir.getFile().getAbsolutePath());
            }
            File[] userFiles = parentDir.getFile().listFiles();
            if (userFiles != null) {
                for (File f : userFiles) {
                    res.add(this.openStore(ownerName, f));
                }
            } else {
                throw new NotFoundException("Cannot read parent folder " + parentDir.getFile().getAbsolutePath());
            }
            return res;
        }
        throw new NotFoundException("Not user '" + ownerName + "' folder " + parentDir.getFile());
    }
}

