/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.BaseCloudDriveListener;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.UserAlreadyConnectedException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.rest.CommandState;
import org.exoplatform.clouddrive.rest.DriveInfo;
import org.exoplatform.clouddrive.rest.DriveServiceLocator;
import org.exoplatform.clouddrive.rest.ProviderInfo;
import org.exoplatform.clouddrive.rest.ServiceResponse;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/clouddrive/connect")
@Produces(value={"application/json"})
public class ConnectService
implements ResourceContainer {
    public static final String CONNECT_COOKIE = "cloud-drive-connect-id";
    public static final String ERROR_COOKIE = "cloud-drive-error";
    public static final String INIT_COOKIE = "cloud-drive-init-id";
    public static final String INIT_COOKIE_PATH = "/portal/rest/clouddrive/connect";
    public static final int INIT_COOKIE_EXPIRE = 60;
    public static final int CONNECT_COOKIE_EXPIRE = 60;
    public static final int ERROR_COOKIE_EXPIRE = 5;
    public static final int CONNECT_REQUEST_EXPIRE = 60000;
    public static final int CONNECT_PROCESS_EXPIRE = 3600000;
    protected static final Random random = new Random();
    protected static final Log LOG = ExoLogger.getLogger(ConnectService.class);
    protected final CloudDriveService cloudDrives;
    protected final DriveServiceLocator locator;
    protected final SessionProviderService sessionProviders;
    protected final RepositoryService jcrService;
    protected final NodeFinder finder;
    protected final Map<UUID, CloudUser> authenticated = new ConcurrentHashMap<UUID, CloudUser>();
    protected final Map<UUID, ConnectInit> initiated = new ConcurrentHashMap<UUID, ConnectInit>();
    protected final Map<UUID, Long> timeline = new ConcurrentHashMap<UUID, Long>();
    protected final Map<String, ConnectProcess> active = new ConcurrentHashMap<String, ConnectProcess>();
    protected final Thread connectsCleaner;

    public ConnectService(CloudDriveService cloudDrives, DriveServiceLocator locator, RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder) {
        this.cloudDrives = cloudDrives;
        this.locator = locator;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.connectsCleaner = new Thread("Cloud Drive connections cleaner"){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    long now = System.currentTimeMillis();
                    Iterator<Map.Entry<UUID, Long>> titer = ConnectService.this.timeline.entrySet().iterator();
                    while (titer.hasNext()) {
                        Map.Entry<UUID, Long> t = titer.next();
                        if (now < t.getValue()) continue;
                        ConnectService.this.authenticated.remove(t.getKey());
                        ConnectService.this.initiated.remove(t.getKey());
                        titer.remove();
                    }
                    Iterator<Map.Entry<String, ConnectProcess>> cpiter = ConnectService.this.active.entrySet().iterator();
                    while (cpiter.hasNext()) {
                        long expireTime;
                        ConnectProcess cp = cpiter.next().getValue();
                        if (cp == null || now < (expireTime = cp.process.getStartTime() + 3600000L)) continue;
                        cpiter.remove();
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)(this.getName() + " interrupted."), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.connectsCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @RolesAllowed(value={"users"})
    public Response connectStart(@Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path, @CookieParam(value="JSESSIONID") Cookie jsessionsId, @CookieParam(value="JSESSIONIDSSO") Cookie jsessionsIdSSO, @CookieParam(value="cloud-drive-connect-id") Cookie connectId, @CookieParam(value="cloud-drive-init-id") Cookie initId) {
        ConnectResponse resp = new ConnectResponse();
        String host = this.locator.getServiceHost(uriInfo.getRequestUri().getHost());
        if (connectId != null) {
            UUID cid = UUID.fromString(connectId.getValue());
            CloudUser user = this.authenticated.remove(cid);
            this.timeline.remove(cid);
            Node userNode = null;
            Node driveNode = null;
            if (user != null) {
                if (workspace == null) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
                if (path == null) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
                Session userSession = null;
                try {
                    ConversationState convo = ConversationState.getCurrent();
                    if (convo == null) {
                        LOG.error((Object)("Error connect drive for user " + user.getEmail() + ". User identity not set: ConversationState.getCurrent() is null"));
                        Response response = resp.connectError("User identity not set.", cid.toString(), host).status(Response.Status.INTERNAL_SERVER_ERROR).build();
                        return response;
                    }
                    SessionProvider sp = this.sessionProviders.getSessionProvider(null);
                    userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
                    Item item = this.finder.findItem(userSession, path);
                    if (item.isNode()) {
                        String name;
                        userNode = (Node)item;
                        CloudDrive existing = this.cloudDrives.findDrive(userNode);
                        if (existing != null) {
                            driveNode = (Node)userSession.getItem(existing.getPath());
                            userNode = driveNode.getParent();
                            name = driveNode.getName();
                        } else {
                            name = JCRLocalCloudDrive.cleanName(user.createDriveTitle());
                        }
                        String processId = this.processId(workspace, userNode.getPath(), name);
                        resp.cookie(CONNECT_COOKIE, cid.toString(), "/", host, "Cloud Drive connect ID", 0, false);
                        ConnectProcess connect = this.active.get(processId);
                        if (connect == null || connect.error != null) {
                            if (driveNode == null) {
                                try {
                                    driveNode = userNode.getNode(name);
                                }
                                catch (PathNotFoundException pnte) {
                                    try {
                                        driveNode = userNode.addNode(name, "nt:folder");
                                        userNode.save();
                                    }
                                    catch (RepositoryException e) {
                                        this.rollback(userNode, null);
                                        LOG.error((Object)("Error creating node for the drive of user " + user.getEmail() + ". Cannot create node under " + path), (Throwable)e);
                                        Response response = resp.connectError("Error creating node for the drive: storage error.", cid.toString(), host).status(Response.Status.INTERNAL_SERVER_ERROR).build();
                                        if (userSession == null) return response;
                                        userSession.logout();
                                        return response;
                                    }
                                }
                            }
                            resp.serviceUrl(uriInfo.getRequestUriBuilder().queryParam("workspace", new Object[]{workspace}).queryParam("path", new Object[]{driveNode.getPath()}).build(new Object[0]).toASCIIString());
                            try {
                                CloudDrive local = this.cloudDrives.createDrive(user, driveNode);
                                if (local.isConnected()) {
                                    resp.status(Response.Status.CREATED);
                                    DriveInfo drive = DriveInfo.create(workspace, local);
                                    resp.drive(drive);
                                    LOG.info((Object)(drive.getTitle() + " already connected."));
                                    return resp.build();
                                }
                                connect = new ConnectProcess(workspace, local, convo);
                                this.active.put(processId, connect);
                                resp.status(connect.process.isDone() ? Response.Status.CREATED : Response.Status.ACCEPTED);
                                resp.progress(connect.process.getProgress());
                                DriveInfo drive = DriveInfo.create(workspace, local, connect.process.getFiles());
                                resp.drive(drive);
                                return resp.build();
                            }
                            catch (UserAlreadyConnectedException e) {
                                LOG.warn((Object)e.getMessage(), (Throwable)e);
                                resp.connectError(e.getMessage(), cid.toString(), host).status(Response.Status.CONFLICT);
                                return resp.build();
                            }
                            catch (CloudDriveException e) {
                                this.rollback(userNode, driveNode);
                                LOG.error((Object)("Error connecting drive for user " + user + ", " + workspace + ":" + path), (Throwable)e);
                                resp.connectError("Error connecting drive. " + e.getMessage(), cid.toString(), host).status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            return resp.build();
                        }
                        String message = "Connect to " + connect.title + " already posted and currently in progress.";
                        LOG.warn((Object)message);
                        try {
                            connect.lock.lock();
                            resp.serviceUrl(uriInfo.getRequestUriBuilder().queryParam("workspace", new Object[]{workspace}).queryParam("path", new Object[]{connect.drive.getPath()}).build(new Object[0]).toASCIIString());
                            resp.progress(connect.process.getProgress());
                            resp.drive(DriveInfo.create(workspace, connect.drive));
                            resp.connectError(message, cid.toString(), host).status(Response.Status.CONFLICT);
                            return resp.build();
                        }
                        finally {
                            connect.lock.unlock();
                        }
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a node."));
                    resp.connectError("Not a node.", cid.toString(), host).status(Response.Status.PRECONDITION_FAILED);
                    return resp.build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to connect drive " + workspace + ":" + path + ". " + e.getMessage()));
                    resp.connectError("Authentication error.", cid.toString(), host).status(Response.Status.UNAUTHORIZED);
                    return resp.build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error connecting drive for user " + user + ", node " + workspace + ":" + path), (Throwable)e);
                    this.rollback(userNode, driveNode);
                    resp.connectError("Error connecting drive: storage error.", cid.toString(), host).status(Response.Status.INTERNAL_SERVER_ERROR);
                    return resp.build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error connecting drive for user " + user + ", node " + workspace + ":" + path), e);
                    this.rollback(userNode, driveNode);
                    resp.connectError("Error connecting drive: runtime error.", cid.toString(), host).status(Response.Status.INTERNAL_SERVER_ERROR);
                    return resp.build();
                }
                finally {
                    if (userSession != null) {
                        userSession.logout();
                    }
                }
            }
            LOG.warn((Object)("User not authenticated for connectId " + connectId));
            resp.connectError("User not authenticated.", cid.toString(), host).status(Response.Status.BAD_REQUEST);
            return resp.build();
        }
        LOG.warn((Object)"Connect ID not set");
        resp.error("Connection not initiated properly.").status(Response.Status.BAD_REQUEST);
        return resp.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @RolesAllowed(value={"users"})
    public Response connectState(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        ConnectResponse resp;
        block21: {
            resp = new ConnectResponse();
            resp.serviceUrl(uriInfo.getRequestUri().toASCIIString());
            String processId = this.processId(workspace, path);
            try {
                ConnectProcess connect = this.active.get(processId);
                if (connect != null) {
                    int progress = connect.process.getProgress();
                    resp.progress(progress);
                    connect.lock.lock();
                    try {
                        if (connect.error != null) {
                            String error = connect.error.getMessage();
                            if (error == null) {
                                error = "null.";
                            }
                            if (error.indexOf("backendError") >= 0) {
                                error = "Google backend error. Try again later.";
                            }
                            resp.error(error).status(Response.Status.INTERNAL_SERVER_ERROR);
                        } else if (connect.process.isDone()) {
                            DriveInfo drive = DriveInfo.create(workspace, connect.drive, connect.process.getFiles());
                            resp.drive(drive);
                            resp.status(Response.Status.CREATED);
                        } else {
                            DriveInfo drive = DriveInfo.create(workspace, connect.drive);
                            resp.drive(drive);
                            resp.status(Response.Status.ACCEPTED);
                        }
                        break block21;
                    }
                    catch (RepositoryException e) {
                        LOG.warn((Object)("Error reading drive " + processId + ". " + e.getMessage()), (Throwable)e);
                        resp.error("Error reading drive: storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                        break block21;
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Drive removed " + processId), (Throwable)e);
                        resp.error("Drive removed '" + connect.title + "'.").status(Response.Status.BAD_REQUEST);
                        break block21;
                    }
                    finally {
                        connect.lock.unlock();
                    }
                }
                try {
                    CloudDrive drive = this.cloudDrives.findDrive(workspace, path);
                    if (drive != null) {
                        resp.progress(100).drive(DriveInfo.create(workspace, drive)).ok();
                        break block21;
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    resp.status(Response.Status.NO_CONTENT);
                }
                catch (DriveRemovedException e) {
                    LOG.warn((Object)("Drive removed " + processId), (Throwable)e);
                    resp.error("Drive removed.").status(Response.Status.BAD_REQUEST);
                }
                catch (PathNotFoundException e) {
                    LOG.warn((Object)("Node not found " + processId), (Throwable)e);
                    resp.error("Node not found.").status(Response.Status.NOT_FOUND);
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading connected drive '" + processId + "'"), (Throwable)e);
                    resp.error("Error reading connected drive: storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("Error getting state of drive '" + processId + "'. "), e);
                resp.error("Error getting state of drive.").status(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/{providerid}/")
    @Produces(value={"text/html"})
    public Response userAuth(@Context UriInfo uriInfo, @PathParam(value="providerid") String providerId, @QueryParam(value="code") String key, @QueryParam(value="state") String repoName, @QueryParam(value="error") String error, @CookieParam(value="JSESSIONID") Cookie jsessionsId, @CookieParam(value="JSESSIONIDSSO") Cookie jsessionsIdSSO, @CookieParam(value="cloud-drive-init-id") Cookie initId) {
        ConnectResponse resp = new ConnectResponse();
        String requestHost = uriInfo.getRequestUri().getHost();
        if (repoName != null && this.locator.isRedirect(requestHost)) {
            resp.location(this.locator.getServiceLink(repoName, uriInfo.getRequestUri().toString()));
            return resp.status(Response.Status.MOVED_PERMANENTLY).build();
        }
        String baseHost = this.locator.getServiceHost(requestHost);
        if (initId != null) {
            try {
                UUID iid = UUID.fromString(initId.getValue());
                ConnectInit connect = this.initiated.remove(iid);
                this.timeline.remove(iid);
                if (connect != null) {
                    CloudProvider provider = connect.provider;
                    if (provider.getId().equals(providerId)) {
                        if (error == null) {
                            if (key != null) {
                                try {
                                    CloudUser user = this.cloudDrives.authenticate(provider, key);
                                    UUID connectId = this.generateId(user.getEmail() + key);
                                    this.authenticated.put(connectId, user);
                                    this.timeline.put(connectId, System.currentTimeMillis() + 60000L + 5000L);
                                    resp.cookie(CONNECT_COOKIE, connectId.toString(), "/", connect.host, "Cloud Drive connect ID", 60, false);
                                    resp.cookie(INIT_COOKIE, iid.toString(), INIT_COOKIE_PATH, baseHost, "Cloud Drive init ID", 0, false);
                                    resp.entity("<!doctype html><html><head><script type='text/javascript'> window.close();</script></head><body><div id='messageString'>Connecting to " + user.getServiceName() + "</div></body></html>");
                                    return resp.ok().build();
                                }
                                catch (CloudDriveException e) {
                                    LOG.warn((Object)("Error authenticating user to access " + provider.getName()), (Throwable)e);
                                    return resp.authError("Authentication error on " + provider.getName(), connect.host, provider.getName(), iid.toString(), baseHost).status(Response.Status.BAD_REQUEST).build();
                                }
                            }
                            LOG.warn((Object)("Key required for " + provider.getName()));
                            return resp.authError("Key required for " + provider.getName(), connect.host, provider.getName(), iid.toString(), baseHost).status(Response.Status.BAD_REQUEST).build();
                        }
                        LOG.warn((Object)(provider.getName() + " error: " + error));
                        if (error.indexOf("access_denied") >= 0) {
                            resp.authError("Acccess denied.", connect.host, provider.getName(), iid.toString(), baseHost).status(Response.Status.FORBIDDEN);
                        } else {
                            resp.authError(error, connect.host, provider.getName(), iid.toString(), baseHost).status(Response.Status.BAD_REQUEST);
                        }
                        return resp.build();
                    }
                    LOG.error((Object)("Authentication was not initiated for " + providerId + " but request to " + provider.getId() + " recorded with id " + initId));
                    return resp.authError("Authentication not initiated to " + provider.getName(), connect.host, provider.getName(), iid.toString(), baseHost).status(Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                LOG.warn((Object)("Authentication was not initiated for " + providerId + " and id " + initId));
                return resp.authError("Authentication request expired. Try again later.", baseHost, null, iid.toString(), baseHost).status(Response.Status.BAD_REQUEST).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error initializing drive provider by id " + providerId), e);
                return resp.authError("Error initializing drive provider", baseHost).status(Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        LOG.warn((Object)("Authentication id not set for provider id " + providerId + " and key " + key));
        return resp.authError("Authentication not initiated or expired. Try again later.", baseHost).status(Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/init/{providerid}/")
    @RolesAllowed(value={"users"})
    public Response userInit(@Context UriInfo uriInfo, @PathParam(value="providerid") String providerId, @CookieParam(value="JSESSIONID") Cookie jsessionsId, @CookieParam(value="JSESSIONIDSSO") Cookie jsessionsIdSSO) {
        ConnectResponse resp = new ConnectResponse();
        try {
            CloudProvider provider = this.cloudDrives.getProvider(providerId);
            ConversationState convo = ConversationState.getCurrent();
            if (convo != null) {
                String localUser = convo.getIdentity().getUserId();
                String host = this.locator.getServiceHost(uriInfo.getRequestUri().getHost());
                UUID initId = this.generateId(localUser);
                this.initiated.put(initId, new ConnectInit(localUser, provider, host));
                this.timeline.put(initId, System.currentTimeMillis() + 60000L + 5000L);
                resp.cookie(INIT_COOKIE, initId.toString(), INIT_COOKIE_PATH, host, "Cloud Drive init ID", 60, false);
                return resp.entity(new ProviderInfo(provider)).ok().build();
            }
            LOG.warn((Object)("ConversationState not set to initialize connect to " + provider.getName()));
            return resp.error("User not authenticated to connect " + provider.getName()).status(Response.Status.UNAUTHORIZED).build();
        }
        catch (ProviderNotAvailableException e) {
            LOG.warn((Object)("Provider not found for id '" + providerId + "'"), (Throwable)e);
            return resp.error("Provider not found.").status(Response.Status.BAD_REQUEST).build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error initializing user request for drive provider " + providerId), e);
            return resp.error("Error initializing user request.").status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected UUID generateId(String name) {
        StringBuilder s = new StringBuilder();
        s.append(name);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(random.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected String processId(String workspace, String parentPath, String driveName) {
        return workspace + ":" + parentPath + "/" + driveName;
    }

    protected String processId(String workspace, String nodePath) {
        return workspace + ":" + nodePath;
    }

    protected boolean rollback(Node userNode, Node driveNode) {
        try {
            if (userNode != null) {
                if (driveNode != null) {
                    driveNode.remove();
                    userNode.save();
                }
                userNode.refresh(false);
                return true;
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error rolling back the user node: " + e.getMessage()), e);
        }
        return false;
    }

    class ConnectProcess
    extends BaseCloudDriveListener {
        final CloudDrive drive;
        final CloudDrive.Command process;
        final String title;
        final String workspaceName;
        final Lock lock = new ReentrantLock();
        Throwable error;

        ConnectProcess(String workspaceName, CloudDrive drive, ConversationState conversation) throws CloudDriveException, RepositoryException {
            this.drive = drive;
            this.title = drive.getTitle();
            this.workspaceName = workspaceName;
            this.drive.addListener(this);
            this.process = drive.connect();
            LOG.info((Object)(this.title + " connect started."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rollback() throws RepositoryException {
            SessionProvider provider = ConnectService.this.sessionProviders.getSessionProvider(null);
            Session session = provider.getSession(this.workspaceName, ConnectService.this.jcrService.getCurrentRepository());
            try {
                session.getItem(this.drive.getPath()).remove();
                session.save();
            }
            catch (PathNotFoundException e) {
            }
            catch (DriveRemovedException driveRemovedException) {
            }
            finally {
                session.logout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(CloudDriveEvent event, Throwable error, String operationName) {
            this.lock.lock();
            this.drive.removeListener(this);
            this.error = error;
            try {
                this.rollback();
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error removing the drive Node connected with error (" + error.getMessage() + "). " + e.getMessage()), e);
            }
            finally {
                this.lock.unlock();
                LOG.error((Object)(this.title + " connect failed."), error);
            }
        }

        @Override
        public void onConnect(CloudDriveEvent event) {
            ConnectService.this.active.values().remove(this);
            this.drive.removeListener(this);
            LOG.info((Object)(this.title + " successfully connected."));
        }
    }

    class ConnectInit {
        final String localUser;
        final CloudProvider provider;
        final String host;

        ConnectInit(String localUser, CloudProvider provider, String host) {
            this.localUser = localUser;
            this.provider = provider;
            this.host = host;
        }
    }

    class ConnectResponse
    extends ServiceResponse {
        String serviceUrl;
        int progress;
        DriveInfo drive;
        String error;
        String location;

        ConnectResponse() {
        }

        ConnectResponse serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        ConnectResponse progress(int progress) {
            this.progress = progress;
            return this;
        }

        ConnectResponse drive(DriveInfo drive) {
            this.drive = drive;
            return this;
        }

        ConnectResponse error(String error) {
            this.error = error;
            return this;
        }

        ConnectResponse location(String location) {
            this.location = location;
            return this;
        }

        ConnectResponse connectError(String error, String connectId, String host) {
            if (connectId != null) {
                this.cookie(ConnectService.CONNECT_COOKIE, connectId, "/", host, "Cloud Drive connect ID", 0, false);
            }
            this.cookie(ConnectService.ERROR_COOKIE, error, "/", host, "Cloud Drive connection error", 5, false);
            this.error = error;
            return this;
        }

        ConnectResponse authError(String message, String host, String providerName, String initId, String baseHost) {
            if (initId != null) {
                this.cookie(ConnectService.INIT_COOKIE, initId, ConnectService.INIT_COOKIE_PATH, baseHost, "Cloud Drive init ID", 0, false);
            }
            this.cookie(ConnectService.ERROR_COOKIE, message, "/", host, "Cloud Drive connection error", 5, false);
            super.entity("<!doctype html><html><head><script type='text/javascript'> setTimeout(function() {window.close();}, 4000);</script></head><body><div id='messageString'>" + (providerName != null ? providerName + " return error: " + message : message) + "</div></body></html>");
            return this;
        }

        ConnectResponse authError(String message, String host) {
            return this.authError(message, host, null, null, null);
        }

        @Override
        Response build() {
            if (this.drive != null) {
                super.entity(new CommandState(this.drive, this.error, this.progress, this.serviceUrl));
            } else if (this.error != null) {
                super.entity(new CommandState(this.error, this.progress, this.serviceUrl));
            } else if (this.location != null) {
                super.addHeader("Location", this.location);
                super.entity("<!doctype html><html><head></head><body><div id='redirectLink'><a href='" + this.location + "'>Use new location to the service.</a>" + "</div></body></html>");
            }
            return super.build();
        }
    }
}

