/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.rest.AcceptedCloudFile;
import org.exoplatform.clouddrive.rest.DriveInfo;
import org.exoplatform.clouddrive.rest.LinkedCloudFile;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/drive")
@Produces(value={"application/json"})
public class DriveService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(DriveService.class);
    protected static final String CONTENT_SUFIX = "/jcr:content";
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;

    public DriveService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @GET
    @RolesAllowed(value={"users"})
    public Response getDrive(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                return this.readDrive(workspace, path, false);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @POST
    @Path(value="/synchronize/")
    @RolesAllowed(value={"users"})
    public Response synchronize(@Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                return this.readDrive(workspace, path, true);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    protected Response readDrive(String workspace, String path, boolean synchronize) {
        try {
            CloudDrive local = this.cloudDrives.findDrive(workspace, path);
            if (local != null) {
                HashSet<String> removed;
                ArrayList<CloudFile> files;
                if (synchronize) {
                    try {
                        CloudDrive.Command sync = local.synchronize();
                        sync.await();
                        files = sync.getFiles();
                        removed = sync.getRemoved();
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Caller of synchronization command interrupted.", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Synchrinization interrupted. Try again later.").build();
                    }
                    catch (ExecutionException e) {
                        Throwable err = e.getCause();
                        if (err instanceof RefreshAccessException) {
                            Throwable cause = err.getCause();
                            LOG.warn((Object)("Access to cloud drive expired, forbidden or revoked. " + err.getMessage() + (cause != null ? ". " + cause.getMessage() : "")));
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        if (err instanceof NotConnectedException) {
                            LOG.warn((Object)("Cannot synchronize not connected drive. " + err.getMessage()), err);
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Drive not connected.").build();
                        }
                        if (err instanceof CloudDriveException) {
                            LOG.error((Object)("Error synchrinizing the drive. " + err.getMessage()), err);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error synchrinizing the drive. Try again later.").build();
                        }
                        if (err instanceof RepositoryException) {
                            LOG.error((Object)("Storage error. " + err.getMessage()), err);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Storage error. Synchronization canceled.").build();
                        }
                        if (err instanceof RuntimeException) {
                            LOG.error((Object)("Runtime error. " + err.getMessage()), err);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Internal server error. Synchronization canceled. Try again later.").build();
                        }
                        LOG.error((Object)("Unexpected error. " + err.getMessage()), err);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Unexpected server error. Synchronization canceled. Try again later.").build();
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)("Error synchronizing drive " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error synchronizing drive. " + e.getMessage())).build();
                    }
                }
                files = new ArrayList();
                removed = new HashSet();
                try {
                    if (!local.getPath().equals(path)) {
                        CloudFile file = local.getFile(path);
                        files.add(file);
                        if (!file.getPath().equals(path)) {
                            files.add(new LinkedCloudFile(file, path));
                        }
                    }
                }
                catch (NotCloudFileException e) {
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not yet a cloud file : " + e.getMessage()));
                    files.add(new AcceptedCloudFile(path));
                }
                return Response.ok().entity((Object)DriveInfo.create(workspace, local, files, removed)).build();
            }
            LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (LoginException e) {
            LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
        }
        catch (DriveRemovedException e) {
            LOG.error((Object)("Drive removed " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Drive removed.").build();
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)("Error reading file " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Current file was removed or renamed.").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
        }
    }

    @GET
    @Path(value="/file/")
    @RolesAllowed(value={"users"})
    public Response getFile(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            CloudFile file = local.getFile(path);
                            if (!file.getPath().equals(path)) {
                                file = new LinkedCloudFile(file, path);
                            }
                            return Response.ok().entity((Object)file).build();
                        }
                        catch (NotCloudFileException e) {
                            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new AcceptedCloudFile(path)).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive file " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading file. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/files/")
    @RolesAllowed(value={"users"})
    public Response getFiles(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        String parentPath;
                        if (local.getPath().equals(path)) {
                            parentPath = path;
                        } else {
                            try {
                                parentPath = local.getFile(path).getPath();
                            }
                            catch (NotYetCloudFileException e) {
                                parentPath = path;
                            }
                        }
                        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
                        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
                        Node parentNode = (Node)userSession.getItem(parentPath);
                        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
                        boolean hasAccepted = false;
                        NodeIterator childs = parentNode.getNodes();
                        while (childs.hasNext()) {
                            Node fileNode = childs.nextNode();
                            String filePath = fileNode.getPath();
                            try {
                                CloudFile file = local.getFile(filePath);
                                if (file == null) continue;
                                if (!file.getPath().equals(filePath)) {
                                    file = new LinkedCloudFile(file, filePath);
                                }
                                files.add(file);
                            }
                            catch (NotYetCloudFileException e) {
                                hasAccepted = true;
                                files.add(new AcceptedCloudFile(filePath));
                            }
                        }
                        Response.ResponseBuilder resp = hasAccepted ? Response.status((Response.Status)Response.Status.ACCEPTED) : Response.ok();
                        return resp.entity(files).build();
                    }
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive files in " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading files in " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading files. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading files in " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading files: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading files in " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/state/")
    @RolesAllowed(value={"users"})
    public Response getState(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            return Response.status((Response.Status)Response.Status.OK).entity(local.getState()).build();
                        }
                        catch (RefreshAccessException e) {
                            Throwable cause = e.getCause();
                            LOG.warn((Object)("Access to cloud drive expired, forbidden or revoked. " + e.getMessage() + (cause != null ? ". " + cause.getMessage() : "")));
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        catch (CloudDriveException e) {
                            LOG.error((Object)("Error getting changes link for drive " + workspace + ":" + path), (Throwable)e);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting changes link. " + e.getMessage())).build();
                        }
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }
}

