/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveManager;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.AbstractJCRAction;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveCloudFileAction
extends AbstractJCRAction {
    private static Log LOG = ExoLogger.getLogger(RemoveCloudFileAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws Exception {
        Node fileNode = (Node)context.get((Object)InvocationContext.CURRENT_ITEM);
        if (2 == (Integer)context.get((Object)InvocationContext.EVENT)) {
            CloudDriveService drives = this.drives(context);
            CloudDrive localDrive = drives.findDrive(fileNode);
            if (localDrive != null) {
                if (localDrive.isConnected()) {
                    if (this.accept(localDrive)) {
                        try {
                            this.start(localDrive);
                            try {
                                new CloudDriveManager(localDrive).initRemove(fileNode);
                            }
                            catch (SyncNotSupportedException e) {
                                LOG.error((Object)("Cannor remove cloud drive file " + fileNode.getPath() + ": " + e.getMessage()));
                            }
                        }
                        finally {
                            this.done();
                        }
                    }
                    return true;
                }
                try {
                    Node driveParent = fileNode.getSession().getItem(localDrive.getPath()).getParent();
                    if (driveParent.isNodeType("exo:trashFolder")) {
                        return true;
                    }
                }
                catch (ItemNotFoundException e) {
                    // empty catch block
                }
                LOG.warn((Object)("Cloud drive not connected " + localDrive.getPath()));
            }
        } else {
            LOG.warn((Object)(RemoveCloudFileAction.class.getName() + " supports only node removal. Check configuration. Item skipped: " + fileNode.getPath()));
        }
        return false;
    }
}

