/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.exodrive.ExoDriveProvider;
import org.exoplatform.clouddrive.exodrive.ExoDriveUser;
import org.exoplatform.clouddrive.exodrive.JCRLocalExoDrive;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveConfigurationException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveRepository;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveService;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;

public class ExoDriveConnector
extends CloudDriveConnector {
    public static final String ANONYMOUS = "__anonymous".intern();
    public static final String SYSTEM = "__system".intern();
    public static final String EMPTY = "".intern();
    protected static final Log LOG = ExoLogger.getLogger(ExoDriveConnector.class);
    protected final ExoDriveUser systemUser;
    protected final ExoDriveUser anonymousUser;
    protected final ExoDriveService service;
    protected final OrganizationService orgService;
    protected final AuthURLBuilder authUrlBuilder;

    public ExoDriveConnector(RepositoryService jcrService, SessionProviderService sessionProviders, ExoDriveService service, OrganizationService orgService, NodeFinder finder, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, params);
        this.service = service;
        this.orgService = orgService;
        this.authUrlBuilder = new AuthURLBuilder();
        this.systemUser = new ExoDriveUser(SYSTEM, EMPTY, this.provider);
        this.anonymousUser = new ExoDriveUser(ANONYMOUS, EMPTY, this.provider);
    }

    protected ExoDriveRepository repository() throws ExoDriveConfigurationException, RepositoryException {
        return this.service.open(this.jcrService.getCurrentRepository().getConfiguration().getName());
    }

    @Override
    protected CloudProvider createProvider() {
        return new ExoDriveProvider(this.getProviderId(), this.getProviderName(), this.authUrlBuilder);
    }

    @Override
    public ExoDriveUser authenticate(String code) throws CloudDriveException {
        if (code != null) {
            String userEmail;
            ConversationState convo = ConversationState.getCurrent();
            if (convo == null) {
                throw new CloudDriveException("User not authenticated (conversation not set)");
            }
            if (!code.equals(convo.getIdentity().getUserId())) {
                throw new CloudDriveException("User not authorized (conversation not the same)");
            }
            if (SYSTEM == code) {
                return this.systemUser;
            }
            if (ANONYMOUS == code) {
                return this.anonymousUser;
            }
            try {
                User user = this.orgService.getUserHandler().findUserByName(code);
                userEmail = user != null ? user.getEmail() : null;
            }
            catch (Exception e) {
                LOG.error((Object)"Error reading the user from organization service", (Throwable)e);
                userEmail = null;
            }
            if (userEmail != null) {
                try {
                    ExoDriveRepository driveRepo = this.repository();
                    if (!driveRepo.createUser(code)) {
                        throw new CloudDriveException("Cannot create user '" + code + "' folder.");
                    }
                    return new ExoDriveUser(code, userEmail, this.provider);
                }
                catch (ExoDriveConfigurationException e) {
                    throw new CloudDriveException("Error reading eXo Drive repository:", e);
                }
                catch (RepositoryException e) {
                    throw new CloudDriveException("Error getting current JCR repository:", e);
                }
            }
            throw new CloudDriveException("User not found " + code);
        }
        throw new CloudDriveException("Code key should not be null");
    }

    protected ExoDriveUser createUser(String username, String email) throws CloudDriveException {
        return new ExoDriveUser(username, email, this.provider);
    }

    @Override
    public JCRLocalExoDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof ExoDriveUser) {
            try {
                return new JCRLocalExoDrive((ExoDriveUser)user, this.repository(), this.sessionProviders, this.jcrFinder, driveNode);
            }
            catch (ExoDriveConfigurationException e) {
                throw new CloudDriveException("Error getting eXo Drive repository:", e);
            }
        }
        throw new CloudDriveException("Not eXo Drive user: " + user);
    }

    @Override
    protected CloudDrive loadDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkTrashed(driveNode);
        JCRLocalCloudDrive.migrateName(driveNode);
        try {
            return new JCRLocalExoDrive(this.repository(), (ExoDriveProvider)this.provider, this.sessionProviders, this.jcrFinder, driveNode);
        }
        catch (ExoDriveConfigurationException e) {
            throw new CloudDriveException("Error getting eXo Drive repository:", e);
        }
    }

    class AuthURLBuilder {
        AuthURLBuilder() {
        }

        String build() {
            String error;
            StringBuilder authUrl = new StringBuilder();
            authUrl.append("http://");
            try {
                authUrl.append(ExoDriveConnector.this.jcrService.getCurrentRepository().getConfiguration().getName());
                error = null;
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error getting Current Repository for repository based auth url of eXo Drive: " + e.getMessage()), (Throwable)e);
                error = "Current Repository not set.";
            }
            authUrl.append('/');
            authUrl.append(ExoDriveConnector.this.getConnectorHost());
            authUrl.append("/portal/rest/clouddrive/connect/");
            authUrl.append(ExoDriveConnector.this.getProviderId());
            authUrl.append('?');
            if (error == null) {
                authUrl.append("code=");
                ConversationState convo = ConversationState.getCurrent();
                if (convo != null) {
                    authUrl.append("code=");
                    authUrl.append(convo.getIdentity().getUserId());
                } else {
                    authUrl.append("error=");
                    authUrl.append("User not authenticated.");
                }
            } else {
                authUrl.append("error=");
                authUrl.append(error);
            }
            return authUrl.toString();
        }
    }
}

