/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive.service.rest;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveRepository;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveService;
import org.exoplatform.clouddrive.exodrive.service.FileStore;
import org.exoplatform.clouddrive.exodrive.service.NotFoundException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/exodrive")
public class ExoDrivePublicService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ExoDrivePublicService.class);
    protected final ExoDriveService service;
    protected final RepositoryService jcrService;

    public ExoDrivePublicService(RepositoryService jcrService, ExoDriveService service) {
        this.service = service;
        this.jcrService = jcrService;
    }

    @GET
    @Path(value="/{user}/{filename}")
    @Produces(value={"text/html"})
    public Response get(@Context UriInfo uriInfo, @PathParam(value="user") String user, @PathParam(value="filename") String filename) {
        try {
            ExoDriveRepository repo = this.service.read(this.jcrService.getCurrentRepository().getConfiguration().getName());
            FileStore store = repo.read(user, filename);
            InputStream content = store.read();
            return Response.ok().entity((Object)content).type(store.getType()).build();
        }
        catch (NotFoundException e) {
            LOG.warn((Object)("File not found for " + user + ". Asked file: " + filename), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Not found " + user + "/" + filename)).build();
        }
        catch (ExoDriveException e) {
            LOG.error((Object)("Error read user " + user + " file " + filename), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error read user " + user + " file " + filename + ": " + e.getMessage())).build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error read user " + user + " file " + filename), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error read user " + user + " file " + filename + ": " + e.getMessage())).build();
        }
    }
}

