/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.box.BoxAPI;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.box.BoxProvider;
import org.exoplatform.clouddrive.box.BoxUser;
import org.exoplatform.clouddrive.box.JCRLocalBoxDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class BoxConnector
extends CloudDriveConnector {
    public static final String CONFIG_LOGIN_SSO_PARTNERIDPID = "box-sso-partneridpid";
    public static final String CONFIG_LOGIN_SSO_URL = "box-sso-url";

    public BoxConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, params);
    }

    protected BoxProvider getProvider() {
        return (BoxProvider)super.getProvider();
    }

    protected String getConnectorHost() {
        if (this.getConnectorSchema().equalsIgnoreCase("https")) {
            return super.getConnectorHost();
        }
        String[] host = this.connectorHost.split(":");
        StringBuilder newHost = new StringBuilder();
        newHost.append("localhost");
        if (host.length > 1) {
            newHost.append(':');
            newHost.append(host[1]);
        }
        LOG.warn((Object)"Box connector supports only HTTPS for server redirect. Switched to localhost (Box's Development Mode).");
        return newHost.toString();
    }

    protected CloudProvider createProvider() {
        StringBuilder redirectURL = new StringBuilder();
        redirectURL.append(this.getConnectorSchema());
        redirectURL.append("://");
        redirectURL.append(this.getConnectorHost());
        redirectURL.append("/portal/rest/clouddrive/connect/");
        redirectURL.append(this.getProviderId());
        StringBuilder oauthURL = new StringBuilder();
        oauthURL.append("https://");
        if (this.loginSSO) {
            oauthURL.append("app");
        } else {
            oauthURL.append("www");
        }
        oauthURL.append(".box.com/api/oauth2/authorize?");
        oauthURL.append("response_type=code&client_id=");
        String clientId = this.getClientId();
        try {
            oauthURL.append(URLEncoder.encode(clientId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode client id " + clientId + ":" + e));
            oauthURL.append(clientId);
        }
        oauthURL.append("&state=");
        try {
            oauthURL.append(URLEncoder.encode("__no_state_set__", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode state __no_state_set__:" + e));
            oauthURL.append("__no_state_set__");
        }
        oauthURL.append("&redirect_uri=");
        StringBuilder authURL = new StringBuilder();
        if (this.loginSSO) {
            String ssoURL = (String)this.config.get(CONFIG_LOGIN_SSO_URL);
            if (ssoURL != null && (ssoURL = ssoURL.trim()).length() > 0) {
                authURL.append(ssoURL);
            } else {
                String ssoPartnerIdpId = (String)this.config.get(CONFIG_LOGIN_SSO_PARTNERIDPID);
                if (ssoPartnerIdpId != null && (ssoPartnerIdpId = ssoPartnerIdpId.trim()).length() > 0) {
                    authURL.append("https://sso.services.box.net/sp/startSSO.ping?PartnerIdpId=");
                    authURL.append(ssoPartnerIdpId);
                    authURL.append("&TargetResource=");
                } else {
                    LOG.warn((Object)"SSO enabled but box-sso-partneridpid not configured. SSO will not be forced for Box connect.");
                }
            }
            oauthURL.append((CharSequence)redirectURL);
            try {
                authURL.append(URLEncoder.encode(oauthURL.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot encode auth URL " + oauthURL.toString() + ":" + e));
                authURL.append((CharSequence)oauthURL);
            }
        } else {
            try {
                oauthURL.append(URLEncoder.encode(redirectURL.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot encode redirect URL " + redirectURL.toString() + ":" + e));
                oauthURL.append((CharSequence)redirectURL);
            }
            authURL.append((CharSequence)oauthURL);
        }
        return new BoxProvider(this.getProviderId(), this.getProviderName(), authURL.toString(), redirectURL.toString(), this.loginSSO, this.jcrService);
    }

    protected CloudUser authenticate(String code) throws CloudDriveException {
        if (code != null && code.length() > 0) {
            BoxAPI driveAPI = new API().auth(code).build();
            com.box.boxjavalibv2.dao.BoxUser buser = driveAPI.getCurrentUser();
            BoxUser user = new BoxUser(buser.getId(), buser.getName(), buser.getLogin(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access key should not be null or empty");
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof BoxUser) {
            BoxUser boxUser = (BoxUser)user;
            JCRLocalBoxDrive drive = new JCRLocalBoxDrive(boxUser, driveNode, this.sessionProviders, this.jcrFinder);
            return drive;
        }
        throw new CloudDriveException("Not Box user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        JCRLocalBoxDrive drive = new JCRLocalBoxDrive(new API(), this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder);
        return drive;
    }

    class API {
        String code;
        String refreshToken;
        String accessToken;
        long expirationTime;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String refreshToken, String accessToken, long expirationTime) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        BoxAPI build() throws BoxException, CloudDriveException {
            if (this.code != null && this.code.length() > 0) {
                return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.code, BoxConnector.this.getProvider().getRedirectURL());
            }
            return new BoxAPI(BoxConnector.this.getClientId(), BoxConnector.this.getClientSecret(), this.accessToken, this.refreshToken, this.expirationTime);
        }
    }
}

