/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateOAuthRequest;
import com.box.boxjavalibv2.requests.RefreshOAuthRequest;
import com.box.boxjavalibv2.requests.RevokeOAuthRequest;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxOAuthManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxOAuthRequestObject;

public class BoxOAuthManagerImpl
extends AbstractBoxResourceManager
implements IBoxOAuthManager {
    public BoxOAuthManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, null, restClient);
    }

    public BoxOAuthToken createOAuth(String code, String clientId, String clientSecret, String redirectUrl) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxOAuthRequestObject obj = BoxOAuthRequestObject.createOAuthRequestObject(code, clientId, clientSecret, redirectUrl);
        return this.createOAuth(obj);
    }

    public BoxOAuthToken createOAuth(String code, String clientId, String clientSecret, String redirectUrl, String deviceId, String deviceName) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxOAuthRequestObject obj = BoxOAuthRequestObject.createOAuthRequestObject(code, clientId, clientSecret, redirectUrl).setDevice(deviceId, deviceName);
        return this.createOAuth(obj);
    }

    public BoxOAuthToken createOAuth(BoxOAuthRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateOAuthRequest request = new CreateOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxOAuthToken)this.getResponseAndParseAndTryCast(request, BoxResourceType.OAUTH_DATA, this.getJSONParser());
    }

    public BoxOAuthToken refreshOAuth(String refreshToken, String clientId, String clientSecret, String deviceId, String deviceName) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxOAuthRequestObject obj = BoxOAuthRequestObject.refreshOAuthRequestObject(refreshToken, clientId, clientSecret).setDevice(deviceId, deviceName);
        return this.createOAuth(obj);
    }

    public BoxOAuthToken refreshOAuth(String refreshToken, String clientId, String clientSecret) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxOAuthRequestObject obj = BoxOAuthRequestObject.refreshOAuthRequestObject(refreshToken, clientId, clientSecret);
        return this.createOAuth(obj);
    }

    public void revokeOAuth(String accessToken, String clientId, String clientSecret) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        BoxOAuthRequestObject obj = BoxOAuthRequestObject.revokeOAuthRequestObject(accessToken, clientId, clientSecret);
        this.revokeOAuth(obj);
    }

    public BoxOAuthToken refreshOAuth(BoxOAuthRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        RefreshOAuthRequest request = new RefreshOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxOAuthToken)this.getResponseAndParseAndTryCast(request, BoxResourceType.OAUTH_DATA, this.getJSONParser());
    }

    public void revokeOAuth(BoxOAuthRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        RevokeOAuthRequest request = new RevokeOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        this.executeRequestWithNoResponseBody(request);
    }
}

