/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive;

import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.exodrive.ExoDriveProvider;
import org.exoplatform.clouddrive.exodrive.ExoDriveUser;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveRepository;
import org.exoplatform.clouddrive.exodrive.service.FileStore;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalExoDrive
extends JCRLocalCloudDrive {
    protected final ExoDriveRepository service;

    public JCRLocalExoDrive(ExoDriveUser user, ExoDriveRepository service, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, Node driveNode) throws CloudDriveException, RepositoryException {
        super(user, driveNode, sessionProviders, finder, mimeTypes);
        this.service = service;
    }

    @Override
    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", driveNode.getName());
        driveNode.setProperty("ecd:url", "#");
    }

    public JCRLocalExoDrive(ExoDriveRepository service, ExoDriveProvider provider, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, Node driveNode) throws CloudDriveException, RepositoryException {
        super(new ExoDriveUser(driveNode.getProperty("ecd:cloudUserName").getString(), driveNode.getProperty("ecd:userEmail").getString(), provider), driveNode, sessionProviders, finder, mimeTypes);
        this.service = service;
    }

    @Override
    public ExoDriveUser getUser() {
        return (ExoDriveUser)this.user;
    }

    @Override
    protected Long readChangeId() throws DriveRemovedException, RepositoryException {
        return Long.MIN_VALUE;
    }

    @Override
    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
    }

    @Override
    protected void refreshAccess() throws CloudDriveException {
    }

    @Override
    protected void updateAccess(CloudUser user) throws CloudDriveException {
    }

    @Override
    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    @Override
    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new Sync();
    }

    @Override
    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected FileAPI() {
            super(JCRLocalExoDrive.this);
        }

        String filePath(Node fileNode) throws RepositoryException, CloudDriveException {
            String nodePath = fileNode.getPath();
            String drivePath = this.rootPath();
            int si = drivePath.length() + 1;
            if (nodePath.startsWith(drivePath) && nodePath.length() > si) {
                return nodePath.substring(si);
            }
            throw new CloudDriveException("Not a drive file " + nodePath);
        }

        @Override
        public String createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            try {
                FileStore fs = JCRLocalExoDrive.this.service.create(JCRLocalExoDrive.this.user.getUsername(), this.filePath(fileNode), mimeType, created);
                fs.write(content);
                return fs.getId();
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Error creating cloud file " + this.getTitle(fileNode), e);
            }
        }

        @Override
        public String createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            try {
                FileStore fs = JCRLocalExoDrive.this.service.create(JCRLocalExoDrive.this.user.getUsername(), this.filePath(folderNode), "application/vnd.exoplatform.exodrive-folder", created);
                return fs.getId();
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Error creating cloud folder " + this.getTitle(folderNode), e);
            }
        }

        @Override
        public void updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
        }

        @Override
        public void updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
        }

        @Override
        public void updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
        }

        @Override
        public String copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            return null;
        }

        @Override
        public String copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            return null;
        }

        @Override
        public void removeFile(String id) throws CloudDriveException, RepositoryException {
        }

        @Override
        public void removeFolder(String id) throws CloudDriveException, RepositoryException {
        }

        @Override
        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            return false;
        }

        @Override
        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            return false;
        }

        @Override
        public boolean untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            return false;
        }

        @Override
        public boolean untrashFolder(Node fileNode) throws CloudDriveException, RepositoryException {
            return false;
        }

        @Override
        public boolean isTrashSupported() {
            return false;
        }

        @Override
        public CloudFile restore(String id, String path) throws NotFoundException, CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Restore not supported");
        }
    }

    class Sync
    extends JCRLocalCloudDrive.SyncCommand {
        volatile int complete;
        volatile int available;

        public Sync() throws RepositoryException, DriveRemovedException {
            super(JCRLocalExoDrive.this);
        }

        @Override
        protected void syncFiles() throws CloudDriveException, RepositoryException {
            try {
                List<FileStore> files = JCRLocalExoDrive.this.service.listFiles(JCRLocalExoDrive.this.user.getUsername());
                this.available = files.size();
                for (FileStore f : files) {
                    Node localNode = JCRLocalExoDrive.this.openFile(f.getId(), f.getName(), this.rootNode);
                    JCRLocalExoDrive.this.initFile(localNode, f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate());
                    this.changed.add(new JCRLocalCloudFile(localNode.getPath(), f.getId(), f.getName(), f.getType(), null, f.getLink(), null, f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate(), false));
                    ++this.complete;
                }
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Cannot list files for user " + JCRLocalExoDrive.this.user.getUsername(), e);
            }
        }

        @Override
        public long getComplete() {
            return this.complete;
        }

        @Override
        public long getAvailable() {
            return this.available;
        }
    }

    class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        volatile int complete;
        volatile int available;

        public Connect() throws RepositoryException, DriveRemovedException {
            super(JCRLocalExoDrive.this);
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            try {
                List<FileStore> files = JCRLocalExoDrive.this.service.listFiles(JCRLocalExoDrive.this.user.getUsername());
                this.available = files.size();
                for (FileStore f : files) {
                    Node localNode = JCRLocalExoDrive.this.openFile(f.getId(), f.getName(), this.rootNode);
                    JCRLocalExoDrive.this.initFile(localNode, f.getId(), f.getName(), f.getType(), f.getLink(), f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate());
                    this.changed.add(new JCRLocalCloudFile(localNode.getPath(), f.getId(), f.getName(), f.getType(), null, f.getLink(), null, f.getLink(), f.getLink(), f.getAuthor(), f.getAuthor(), f.getCreateDate(), f.getModifiedDate(), false));
                    ++this.complete;
                }
            }
            catch (ExoDriveException e) {
                throw new CloudDriveException("Cannot list files for user " + JCRLocalExoDrive.this.user.getUsername(), e);
            }
        }

        @Override
        public long getComplete() {
            return this.complete;
        }

        @Override
        public long getAvailable() {
            return this.available;
        }
    }
}

