/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.filetransfer;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.requests.DownloadFileRequest;
import com.box.boxjavalibv2.requests.DownloadPartialFileRequest;
import com.box.boxjavalibv2.responseparsers.ErrorResponseParser;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import com.box.restclientv2.responseparsers.DefaultFileResponseParser;
import com.box.restclientv2.responses.DefaultBoxResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class BoxFileDownload {
    private static final int DOWNLOAD_BUFFER_SIZE = 4096;
    private int progressUpdateInterval = 300;
    private final IBoxConfig mConfig;
    private final String mFileId;
    private long mBytesTransferred = 0L;
    private IFileTransferListener mListener = null;
    private final IBoxRESTClient mRestClient;

    public BoxFileDownload(IBoxConfig config, IBoxRESTClient restClient, String fileId) {
        this.mConfig = config;
        this.mFileId = fileId;
        this.mRestClient = restClient;
    }

    public void setProgressListener(IFileTransferListener listener) {
        this.mListener = listener;
    }

    public void setProgressUpdateInterval(int time) {
        this.progressUpdateInterval = time;
    }

    public void execute(IBoxRequestAuth auth, OutputStream[] outputStreams, IBoxJSONParser parser, BoxDefaultRequestObject requestObject) throws BoxRestException, IOException, BoxServerException, InterruptedException, AuthFatalFailureException {
        InputStream result = this.execute(auth, parser, requestObject);
        this.copyOut(result, outputStreams);
    }

    public void execute(IBoxRequestAuth auth, File destination, IBoxJSONParser parser, BoxDefaultRequestObject requestObject) throws BoxRestException, IOException, BoxServerException, InterruptedException, AuthFatalFailureException {
        OutputStream[] streams = new OutputStream[]{new FileOutputStream(destination)};
        this.execute(auth, streams, parser, requestObject);
    }

    public InputStream execute(IBoxRequestAuth auth, IBoxJSONParser parser, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DownloadFileRequest request = this.isPartialDownload(requestObject) ? new DownloadPartialFileRequest(this.mConfig, parser, this.mFileId, requestObject) : new DownloadFileRequest(this.mConfig, parser, this.mFileId, requestObject);
        request.setAuth(auth);
        DefaultBoxResponse response = (DefaultBoxResponse)this.mRestClient.execute(request);
        DefaultFileResponseParser responseParser = new DefaultFileResponseParser();
        ErrorResponseParser errorParser = new ErrorResponseParser(parser);
        Object result = response.parseResponse(responseParser, errorParser);
        if (result instanceof BoxServerError) {
            throw new BoxServerException((BoxServerError)result);
        }
        return (InputStream)result;
    }

    public long getBytesTransferred() {
        return this.mBytesTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOut(InputStream inputStream, OutputStream[] outputStreams) throws IOException, InterruptedException {
        byte[] buffer = new byte[4096];
        int bufferLength = 0;
        long lastOnProgressPost = 0L;
        try {
            while ((bufferLength = inputStream.read(buffer)) > 0) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                for (int i = 0; i < outputStreams.length; ++i) {
                    outputStreams[i].write(buffer, 0, bufferLength);
                }
                this.mBytesTransferred += (long)bufferLength;
                long currTime = new Date().getTime();
                if (this.mListener == null || currTime - lastOnProgressPost <= (long)this.progressUpdateInterval) continue;
                lastOnProgressPost = currTime;
                this.mListener.onProgress(this.mBytesTransferred);
            }
        }
        finally {
            IOException exception = null;
            for (int i = 0; i < outputStreams.length; ++i) {
                try {
                    outputStreams[i].flush();
                    outputStreams[i].close();
                    continue;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            if (exception != null) {
                throw exception;
            }
        }
    }

    private boolean isPartialDownload(BoxDefaultRequestObject requestObject) {
        String range;
        boolean isRangeDownload = false;
        if (requestObject != null && (range = requestObject.getRequestExtras().getHeaders().get("Range")) instanceof String && StringUtils.isNotEmpty((String)range)) {
            isRangeDownload = true;
        }
        return isRangeDownload;
    }
}

