/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.CacheLevel;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl
implements Cache {
    private static final Logger LOG = LoggerFactory.getLogger(CacheImpl.class);
    private static final long serialVersionUID = 1L;
    private List<Class<?>> levels;
    private List<Map<String, String>> levelParameters;
    private final String name;
    private CacheLevel root;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CacheImpl() {
        this.name = "Cache";
    }

    public CacheImpl(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(String[] cacheLevelConfig) {
        if (this.levels != null) {
            throw new IllegalStateException("Cache already initialize!");
        }
        if (cacheLevelConfig == null || cacheLevelConfig.length == 0) {
            throw new IllegalArgumentException("Cache config must not be empty!");
        }
        this.lock.writeLock().lock();
        try {
            this.levels = new ArrayList();
            this.levelParameters = new ArrayList<Map<String, String>>();
            for (String config : cacheLevelConfig) {
                int x = config.indexOf(32);
                if (x == -1) {
                    this.addLevel(config, null);
                    continue;
                }
                this.addLevel(config.substring(0, x), config.substring(x + 1));
            }
            this.root = this.createCacheLevel(0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addLevel(String className, String parameters) {
        Class clazz;
        try {
            clazz = ClassLoaderUtil.loadClass((String)className, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class '" + className + "' not found!", e);
        }
        if (!CacheLevel.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class '" + className + "' does not implement the CacheLevel interface!");
        }
        this.levels.add(clazz);
        if (parameters == null) {
            this.levelParameters.add(null);
        } else {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            this.levelParameters.add(parameterMap);
            for (String pair : parameters.split(",")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    parameterMap.put(keyValue[0], "");
                    continue;
                }
                parameterMap.put(keyValue[0], keyValue[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String ... keys) {
        if (keys == null) {
            return null;
        }
        if (this.levels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        Object result = null;
        this.lock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    Object var6_6 = null;
                    return var6_6;
                }
                cacheLevel = (CacheLevel)level;
            }
            result = cacheLevel.get(keys[keys.length - 1]);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object value, String ... keys) {
        if (keys == null) {
            return;
        }
        if (this.levels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        this.lock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    level = this.createCacheLevel(i + 1);
                    cacheLevel.put(level, keys[i]);
                }
                cacheLevel = (CacheLevel)level;
            }
            cacheLevel.put(value, keys[keys.length - 1]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: put [{}] = {}", new Object[]{this.name, CacheImpl.getFormattedKeys(keys), value});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String ... keys) {
        if (keys == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    return;
                }
                cacheLevel = (CacheLevel)level;
            }
            cacheLevel.remove(keys[keys.length - 1]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: removed [{}]", (Object)this.name, (Object)CacheImpl.getFormattedKeys(keys));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        this.lock.writeLock().lock();
        try {
            this.root = this.createCacheLevel(0);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: removed all", (Object)this.name);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int check(String ... keys) {
        if (keys == null) {
            return -1;
        }
        this.lock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.root;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    int n = i;
                    return n;
                }
                cacheLevel = (CacheLevel)level;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return keys.length;
    }

    @Override
    public void writeLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private CacheLevel createCacheLevel(int level) {
        if (level < 0 || level >= this.levels.size()) {
            throw new IllegalArgumentException("Cache level doesn't fit the configuration!");
        }
        Class<?> clazz = this.levels.get(level);
        CacheLevel cacheLevel = null;
        try {
            cacheLevel = (CacheLevel)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cache level problem?!", e);
        }
        cacheLevel.initialize(this.levelParameters.get(level));
        return cacheLevel;
    }

    public String toString() {
        return this.root == null ? "(no cache root)" : this.root.toString();
    }

    private static String getFormattedKeys(String[] keys) {
        assert (keys != null);
        StringBuilder sb = new StringBuilder();
        for (String k : keys) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(k);
        }
        return sb.toString();
    }
}

