/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.DbxAccountInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxDelta;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxPath;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxThumbnailFormat;
import com.dropbox.core.DbxThumbnailSize;
import com.dropbox.core.DbxUrlWithExpiration;
import com.dropbox.core.DbxWriteMode;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Maybe;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.TooManyFilesException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.Web;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DropboxAPI {
    public static final String ROOT_URL = "https://www.dropbox.com/home";
    public static final String ROOT_PATH = "/";
    public static final int DELTA_LONGPOLL_TIMEOUT = 60;
    public static final String DELTA_LONGPOLL_URL = "https://api-notify.dropbox.com/1/longpoll_delta";
    public static final String CONTENT_BASE_URL = "https://api-content.dropbox.com/1/";
    public static final String CONTENT_PREVIEW_URL = "https://api-content.dropbox.com/1/previews/auto";
    public static final String CONTENT_THUMBNAIL_URL = "https://api-content.dropbox.com/1/thumbnails/auto";
    protected static final Log LOG = ExoLogger.getLogger(DropboxAPI.class);
    private DbxClient client;
    private StoredToken token;

    DropboxAPI(DbxRequestConfig config, DbxAuthFinish authData) throws DropboxException, CloudDriveException {
        this.client = new DbxClient(config, authData.accessToken);
        this.token = new StoredToken();
        this.token.store(authData.accessToken);
        this.initUser();
    }

    DropboxAPI(DbxRequestConfig config, String accessToken) throws CloudDriveException {
        this.client = new DbxClient(config, accessToken);
        this.token = new StoredToken();
        this.token.load(accessToken, null, -1L);
        this.initUser();
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    StoredToken getToken() {
        return this.token;
    }

    DbxAccountInfo getCurrentUser() throws DropboxException, RefreshAccessException {
        try {
            return this.client.getAccountInfo();
        }
        catch (DbxException e) {
            throw new DropboxException("Error requesting account info: " + e.getMessage(), e);
        }
    }

    FileMetadata getWithChildren(String idPath, String hash) throws TooManyFilesException, DropboxException, RefreshAccessException {
        try {
            return new FileMetadata(idPath, hash);
        }
        catch (NotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> getWithChildren(" + idPath + ", " + hash + "): " + e.getMessage()));
            }
            return null;
        }
    }

    DbxEntry get(String idPath) throws DropboxException, NotFoundException, RefreshAccessException {
        try {
            DbxEntry md = this.client.getMetadata(idPath);
            return md;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            String msg = "Error requesting file Metadata service";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file Metadata service";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxClient.Downloader getContent(String idPath) throws DropboxException, NotFoundException, RefreshAccessException {
        try {
            DbxClient.Downloader downloader = this.client.startGetFile(idPath, null);
            return downloader;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            String msg = "Error requesting file content";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file content";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    String getUserFileLink(String parentPath, String name) {
        StringBuilder link = new StringBuilder(ROOT_URL);
        if (!ROOT_PATH.equals(parentPath)) {
            link.append(Web.pathEncode((String)parentPath));
        }
        link.append("?preview=").append(Web.formEncode((String)name));
        return link.toString();
    }

    String getFolderLink(String path) {
        if (ROOT_PATH.equals(path)) {
            return ROOT_URL;
        }
        return ROOT_URL + Web.pathEncode((String)path);
    }

    DbxUrlWithExpiration getDirectLink(String dbxPath) throws RefreshAccessException, DropboxException {
        if (ROOT_PATH.equals(dbxPath)) {
            return null;
        }
        try {
            DbxUrlWithExpiration dbxUrl = this.client.createTemporaryDirectUrl(dbxPath);
            return dbxUrl;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            String msg = "Error requesting file link";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file link";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxUrlWithExpiration getSharedLink(String dbxPath) throws RefreshAccessException, DropboxException {
        if (ROOT_PATH.equals(dbxPath)) {
            return null;
        }
        try {
            DbxPath.checkArg((String)"path", (String)dbxPath);
            String apiPath = "1/shares/auto" + dbxPath;
            String[] params = new String[]{"short_url", "false"};
            return (DbxUrlWithExpiration)DbxRequestUtil.doPost((DbxRequestConfig)this.client.getRequestConfig(), (String)this.client.getAccessToken(), (String)DbxHost.Default.api, (String)apiPath, (String[])params, null, (DbxRequestUtil.ResponseHandler)new DbxRequestUtil.ResponseHandler<DbxUrlWithExpiration>(){

                public DbxUrlWithExpiration handle(HttpRequestor.Response response) throws DbxException {
                    if (response.statusCode == 404) {
                        return null;
                    }
                    if (response.statusCode != 200) {
                        throw DbxRequestUtil.unexpectedStatus((HttpRequestor.Response)response);
                    }
                    DbxUrlWithExpiration uwe = (DbxUrlWithExpiration)DbxRequestUtil.readJsonFromResponse((JsonReader)DbxUrlWithExpiration.Reader, (InputStream)response.body);
                    return uwe;
                }
            });
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            String msg = "Error requesting file's shared link";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file's shared link";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxClient.Downloader getThumbnail(String dbxPath, DbxThumbnailSize size) throws DropboxException, RefreshAccessException {
        if (ROOT_PATH.equals(dbxPath)) {
            return null;
        }
        try {
            DbxThumbnailFormat format = DbxThumbnailFormat.bestForFileName((String)dbxPath, (DbxThumbnailFormat)DbxThumbnailFormat.JPEG);
            DbxClient.Downloader downloader = this.client.startGetThumbnail(size, format, dbxPath, null);
            return downloader;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            String msg = "Error requesting file thumbnail";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file thumbnail";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DeltaChanges getDeltas(String cursor) throws DropboxException, RefreshAccessException {
        return new DeltaChanges(cursor);
    }

    DbxEntry.File uploadFile(String parentId, String name, InputStream data, String updateRev) throws DropboxException, NotFoundException, RefreshAccessException, ConflictException {
        String path = this.filePath(parentId, name);
        try {
            DbxWriteMode mode = updateRev != null ? DbxWriteMode.update((String)updateRev) : DbxWriteMode.add();
            DbxEntry.File file = this.client.uploadFile(path, mode, -1L, data);
            return file;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 409) {
                String msg = "File " + path + " already exists";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new ConflictException(msg);
            }
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
        catch (DbxException e) {
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
        catch (IOException e) {
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name + ". " + e.getMessage());
        }
    }

    DbxEntry.Folder createFolder(String parentId, String name) throws DropboxException, NotFoundException, RefreshAccessException, ConflictException {
        String path = this.filePath(parentId, name);
        try {
            DbxEntry.Folder folder = this.client.createFolder(path);
            return folder;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 409) {
                String msg = "Folder " + path + " already exists";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new ConflictException(msg);
            }
            String msg = "Error creating folder ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
        catch (DbxException e) {
            String msg = "Error creating folder ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
    }

    void delete(String idPath) throws DropboxException, NotFoundException, TooManyFilesException, RefreshAccessException {
        try {
            this.client.delete(idPath);
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 404) {
                String msg = "File not found " + idPath;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new NotFoundException(msg);
            }
            if (e.statusCode == 406) {
                String msg = "Too many files would be removed at " + idPath + ". Reduce the amount of files and try again";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new TooManyFilesException(msg);
            }
            String msg = "Error deleting file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + idPath + ": (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + idPath);
        }
        catch (DbxException e) {
            String msg = "Error deleting file " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxEntry.File restoreFile(String idPath, String rev) throws DropboxException, NotFoundException, RefreshAccessException {
        try {
            DbxEntry.File file = this.client.restoreFile(idPath, rev);
            return file;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 404) {
                String msg = "File not found for restoration " + idPath;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " (rev: " + rev + "): " + e.getMessage()), (Throwable)e);
                }
                throw new NotFoundException(msg);
            }
            String msg = "Error restoring file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + idPath + " (rev: " + rev + "): (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + idPath);
        }
        catch (DbxException e) {
            String msg = "Error restoring file " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (rev: " + rev + "): " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    @Deprecated
    DbxEntry.Folder restoreFolder(String idPath, String rev) throws DropboxException, NotFoundException, RefreshAccessException {
        try {
            DbxPath.checkArgNonRoot((String)"path", (String)idPath);
            if (rev == null) {
                throw new IllegalArgumentException("'rev' can't be null");
            }
            if (rev.length() == 0) {
                throw new IllegalArgumentException("'rev' can't be empty");
            }
            String apiPath = "1/restore/auto" + idPath;
            String[] params = new String[]{"rev", rev};
            return (DbxEntry.Folder)DbxRequestUtil.doGet((DbxRequestConfig)this.client.getRequestConfig(), (String)this.client.getAccessToken(), (String)DbxHost.Default.api, (String)apiPath, (String[])params, null, (DbxRequestUtil.ResponseHandler)new DbxRequestUtil.ResponseHandler<DbxEntry.Folder>(){

                public DbxEntry.Folder handle(HttpRequestor.Response response) throws DbxException {
                    if (response.statusCode == 404) {
                        return null;
                    }
                    if (response.statusCode != 200) {
                        throw DbxRequestUtil.unexpectedStatus((HttpRequestor.Response)response);
                    }
                    return (DbxEntry.Folder)DbxRequestUtil.readJsonFromResponse((JsonReader)DbxEntry.Folder.Reader, (InputStream)response.body);
                }
            });
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            LOG.warn((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 404) {
                String msg = "Folder not found for restoration " + idPath;
                LOG.error((Object)(msg + " (rev: " + rev + "): " + e.getMessage()), (Throwable)e);
                throw new NotFoundException(msg);
            }
            String msg = "Error restoring folder ";
            LOG.error((Object)(msg + idPath + " (rev: " + rev + "): (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            throw new DropboxException(msg + idPath);
        }
        catch (DbxException e) {
            String msg = "Error restoring folder " + idPath;
            LOG.error((Object)(msg + " (rev: " + rev + "): " + e.getMessage()), (Throwable)e);
            throw new DropboxException(msg);
        }
    }

    DbxEntry move(String fromPath, String toPath) throws DropboxException, TooManyFilesException, ConflictException, NotFoundException, RefreshAccessException {
        try {
            DbxEntry item = this.client.move(fromPath, toPath);
            return item;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 403) {
                String msg = "Invalid move operation";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
                }
                throw new ConflictException(msg + ", check if destination don't have such file or folder already");
            }
            if (e.statusCode == 404) {
                String msg = "File or folder not found for move " + fromPath;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
                }
                throw new NotFoundException(msg);
            }
            if (e.statusCode == 406) {
                String msg = "Moving of " + fromPath + " involve more than the allowed amount of files";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new TooManyFilesException(msg);
            }
            String msg = "Error moving file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromPath);
        }
        catch (DbxException e) {
            String msg = "Error moving file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromPath);
        }
    }

    DbxEntry copy(String fromPath, String toPath) throws DropboxException, NotFoundException, ConflictException, RefreshAccessException, TooManyFilesException {
        try {
            DbxEntry item = this.client.copy(fromPath, toPath);
            return item;
        }
        catch (DbxException.InvalidAccessToken e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
        }
        catch (DbxException.RetryLater e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + ". Please try again later.");
        }
        catch (DbxException.BadResponseCode e) {
            if (e.statusCode == 403) {
                String msg = "Invalid copy operation";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
                }
                throw new ConflictException(msg + ", check if destination don't have such file or folder already");
            }
            if (e.statusCode == 404) {
                String msg = "File or folder not found for copying " + fromPath;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
                }
                throw new NotFoundException(msg);
            }
            if (e.statusCode == 406) {
                String msg = "Copying of " + fromPath + " involve more than the allowed amount of files";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new TooManyFilesException(msg);
            }
            String msg = "Error copying file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": (" + e.statusCode + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromPath);
        }
        catch (DbxException e) {
            String msg = "Error copying file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromPath);
        }
    }

    private void initUser() throws DropboxException, RefreshAccessException, NotFoundException {
    }

    String filePath(String parentId, String title) {
        StringBuilder path = new StringBuilder(parentId);
        if (!ROOT_PATH.equals(parentId)) {
            path.append('/');
        }
        return path.append(title).toString();
    }

    class DeltaChanges
    extends ChunkIterator<DbxDelta.Entry<DbxEntry>> {
        String cursor;
        boolean hasMore = false;
        boolean reset = false;

        DeltaChanges(String cursor) throws DropboxException, RefreshAccessException {
            this.cursor = cursor;
            this.iter = this.nextChunk();
        }

        protected Iterator<DbxDelta.Entry<DbxEntry>> nextChunk() throws DropboxException, RefreshAccessException {
            try {
                DbxDelta delta = DropboxAPI.this.client.getDelta(this.cursor);
                this.cursor = delta.cursor;
                this.hasMore = delta.hasMore;
                this.reset = delta.reset;
                return delta.entries.iterator();
            }
            catch (DbxException.InvalidAccessToken e) {
                String msg = "Invalid access credentials";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
                }
                throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
            }
            catch (DbxException.RetryLater e) {
                String msg = "Dropbox overloaded or hit rate exceeded";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg + ". Please try again later.");
            }
            catch (DbxException e) {
                String msg = "Error requesting Delta service";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg);
            }
        }

        protected boolean hasNextChunk() {
            return this.hasMore;
        }

        String getCursor() {
            return this.cursor;
        }

        boolean hasReset() {
            return this.reset;
        }
    }

    class FileMetadata
    extends ChunkIterator<DbxEntry> {
        final String idPath;
        boolean changed;
        String hash;
        DbxEntry target;

        FileMetadata(String idPath, String hash) throws TooManyFilesException, NotFoundException, DropboxException, RefreshAccessException {
            this.idPath = idPath;
            this.hash = hash;
            this.iter = this.nextChunk();
        }

        protected Iterator<DbxEntry> nextChunk() throws TooManyFilesException, NotFoundException, DropboxException, RefreshAccessException {
            try {
                DbxEntry.WithChildren metadata;
                if (this.hash == null) {
                    metadata = DropboxAPI.this.client.getMetadataWithChildren(this.idPath);
                } else {
                    Maybe maybe = DropboxAPI.this.client.getMetadataWithChildrenIfChanged(this.idPath, this.hash);
                    if (maybe.isNothing()) {
                        this.changed = false;
                        this.available(0L);
                        return Collections.emptyList().iterator();
                    }
                    metadata = (DbxEntry.WithChildren)maybe.getJust();
                }
                if (metadata == null) {
                    throw new NotFoundException("No file or folder at this path: " + this.idPath);
                }
                this.changed = true;
                this.hash = metadata.hash;
                this.target = metadata.entry;
                List children = metadata.children;
                this.available(children.size());
                return children.iterator();
            }
            catch (DbxException.InvalidAccessToken e) {
                String msg = "Invalid access credentials";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
                }
                throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
            }
            catch (DbxException.RetryLater e) {
                String msg = "Dropbox overloaded or hit rate exceeded";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg + ". Please try again later.");
            }
            catch (DbxException.BadResponseCode e) {
                if (e.statusCode == 406) {
                    String msg = "Folder " + this.idPath + " listings containing more than the specified amount of files";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    }
                    throw new TooManyFilesException(msg);
                }
                String msg = "Error requesting Metadata service";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg);
            }
            catch (DbxException e) {
                String msg = "Error requesting Metadata service";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg);
            }
        }

        protected boolean hasNextChunk() {
            return false;
        }
    }

    class StoredToken
    extends UserToken {
        StoredToken() {
        }

        void store(String accessToken) throws CloudDriveException {
            this.store(accessToken, null, -1L);
        }
    }
}

