/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveSecurity;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudDriveStorage;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.ThreadExecutor;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionException;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.picocontainer.Startable;

public class CloudFileActionService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileActionService.class);
    protected static final String SPACES_GROUP = "spaces";
    protected static final String EXO_OWNEABLE = "exo:owneable";
    protected static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    protected static final String ECD_CLOUDFILELINK = "ecd:cloudFileLink";
    protected static final String ECD_SHAREIDENTITY = "ecd:shareIdentity";
    protected static final String MIX_VERSIONABLE = "mix:versionable";
    protected static final String EXO_TRASHFOLDER = "exo:trashFolder";
    protected static final String[] READ_PERMISSION = new String[]{"read"};
    protected final CloudDriveService cloudDrive;
    protected final RepositoryService jcrService;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final SessionProviderService sessionProviders;
    protected final LinkManager linkManager;
    protected final ManageDriveService documentDrives;
    protected final TrashService trash;
    protected final Map<String, String> removedLinks = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> removedShared = new ConcurrentHashMap<String, String>();
    protected final NodeFinder finder;
    protected final ThreadExecutor workerExecutor = ThreadExecutor.getInstance();
    protected final String groupsPath;
    protected final String usersPath;

    public CloudFileActionService(CloudDriveService cloudDrive, RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, NodeHierarchyCreator hierarchyCreator, LinkManager linkManager, ManageDriveService documentDrives, TrashService trash) {
        this.cloudDrive = cloudDrive;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.hierarchyCreator = hierarchyCreator;
        this.linkManager = linkManager;
        this.documentDrives = documentDrives;
        this.trash = trash;
        this.groupsPath = hierarchyCreator.getJcrPath("groupsPath");
        this.usersPath = hierarchyCreator.getJcrPath("usersPath");
    }

    public boolean isGroupDrive(DriveData drive) {
        return drive.getHomePath().startsWith(this.groupsPath);
    }

    public boolean isUserDrive(DriveData drive) {
        return drive.getHomePath().startsWith(this.usersPath);
    }

    public Node linkShareToUser(Node fileNode, CloudDrive fileDrive, String userName) throws Exception {
        Node link;
        Node userDocs = this.getUserPublicNode(userName);
        this.shareCloudFile(fileNode, fileDrive, userName);
        NodeIterator links = this.getCloudFileLinks(fileNode, userName, true);
        if (links.getSize() == 0L) {
            link = this.linkFile((Node)this.systemSession().getItem(fileNode.getPath()), userDocs, userName);
            this.setAllPermissions(link, userName);
            userDocs.save();
        } else {
            link = links.nextNode();
        }
        return link;
    }

    public DriveData getUserDrive(String userName) throws Exception {
        DriveData userDrive = null;
        String homePath = null;
        Iterator diter = this.documentDrives.getPersonalDrives(userName).iterator();
        while (diter.hasNext()) {
            DriveData drive = (DriveData)diter.next();
            String path = drive.getHomePath();
            if (!path.startsWith(this.usersPath) || !path.endsWith("/Private")) continue;
            homePath = path;
            userDrive = drive;
            if (homePath.indexOf("${userId}") < 0) break;
            if (diter.hasNext()) continue;
            homePath = Utils.getPersonalDrivePath((String)homePath, (String)userName);
            userDrive.setHomePath(homePath);
            break;
        }
        return userDrive;
    }

    public Node getUserPublicNode(String userName) throws Exception {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            String userPublic = this.hierarchyCreator.getJcrPath("userPublic");
            return this.hierarchyCreator.getUserNode(ssp, userName).getNode(userPublic != null ? userPublic : "Public");
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    public void removeLinks(Node fileNode, String shareIdentity) throws RepositoryException {
        NodeIterator niter = this.getCloudFileLinks(fileNode, shareIdentity, true);
        while (niter.hasNext()) {
            Node linkNode = niter.nextNode();
            Node parent = linkNode.getParent();
            linkNode.remove();
            parent.save();
        }
    }

    public DriveData getNodeDrive(Node node) throws Exception {
        String groupId = this.getDriveNameFromPath(node.getPath());
        return groupId != null ? this.documentDrives.getDriveByName(groupId) : null;
    }

    @Deprecated
    public String getDriveNameFromPath(String nodePath) throws CloudFileActionException {
        List allDrives;
        try {
            allDrives = this.documentDrives.getAllDrives();
        }
        catch (Exception e) {
            throw new CloudFileActionException("Error reading document drives: " + e.getMessage(), new ApplicationMessage("CloudFile.msg.ErrorReadingDrives", null, 0));
        }
        for (DriveData drive : allDrives) {
            String drivePath = drive.getHomePath();
            if (!nodePath.startsWith(drivePath)) continue;
            if (drivePath.startsWith(this.groupsPath) || drivePath.startsWith(this.usersPath)) {
                // empty if block
            }
            return drive.getName();
        }
        return null;
    }

    public Node linkFile(Node srcNode, Node destNode, String destIdentity) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        String linkTitle;
        String linkName = srcNode.getName();
        Node linkNode = this.linkManager.createLink(destNode, null, srcNode, linkName, linkTitle = this.documentName(srcNode));
        if (linkNode.canAddMixin(ECD_CLOUDFILELINK)) {
            linkNode.addMixin(ECD_CLOUDFILELINK);
            if (destIdentity != null) {
                linkNode.setProperty(ECD_SHAREIDENTITY, destIdentity);
            }
        } else {
            LOG.warn((Object)("Cannot add mixin ecd:cloudFileLink to symlink " + linkNode.getPath()));
        }
        return linkNode;
    }

    public Node markRemoveLink(Node linkNode) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        if (linkNode.isNodeType(ECD_CLOUDFILELINK)) {
            try {
                Node target = this.linkManager.getTarget(linkNode, true);
                String cloudFileUUID = target.getUUID();
                this.removedLinks.put(linkNode.getPath(), cloudFileUUID);
                try {
                    this.removedShared.put(cloudFileUUID, linkNode.getProperty(ECD_SHAREIDENTITY).getString());
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                return target;
            }
            catch (ItemNotFoundException e) {
                LOG.warn((Object)("Cloud File link has no target node: " + linkNode.getPath() + ". " + e.getMessage()));
            }
        } else {
            LOG.warn((Object)("Not cloud file link: node " + linkNode.getPath() + " not of type " + ECD_CLOUDFILELINK));
        }
        return null;
    }

    public void shareCloudFile(final Node fileNode, CloudDrive cloudDrive, final String ... identities) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sharing Cloud File " + fileNode.getPath() + " of " + cloudDrive + " to " + " " + Arrays.toString(identities)));
        }
        CloudDriveStorage srcStorage = (CloudDriveStorage)cloudDrive;
        srcStorage.localChange((CloudDriveStorage.Change)new CloudDriveStorage.Change<Void>(){

            public Void apply() throws RepositoryException {
                Node parent = fileNode.getParent();
                CloudFileActionService.this.setParentPermissions(parent, identities);
                CloudFileActionService.this.setPermissions(fileNode, identities);
                parent.save();
                return null;
            }
        });
        CloudDriveSecurity srcSecurity = (CloudDriveSecurity)cloudDrive;
        if (srcSecurity.isSharingSupported()) {
            srcSecurity.shareFile(fileNode, identities);
        }
    }

    public void unshareCloudFile(final Node fileNode, CloudDrive cloudDrive, final String ... identities) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unsharing Cloud File " + fileNode.getPath() + " of " + cloudDrive + " from " + " " + Arrays.toString(identities)));
        }
        CloudDriveStorage srcStorage = (CloudDriveStorage)cloudDrive;
        srcStorage.localChange((CloudDriveStorage.Change)new CloudDriveStorage.Change<Void>(){

            public Void apply() throws RepositoryException {
                Node parent = fileNode.getParent();
                CloudFileActionService.this.removePermissions(fileNode, true, identities);
                CloudFileActionService.this.removePermissions(parent, false, identities);
                parent.save();
                return null;
            }
        });
    }

    public void start() {
        try {
            this.listenFileLinks();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error starting symlinks remove listener", (Throwable)e);
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listenFileLinks() throws RepositoryException {
        Session session = this.systemSession();
        try {
            ObservationManager observation = session.getWorkspace().getObservationManager();
            observation.addEventListener((EventListener)new LinkTrashListener(), 1, null, false, null, new String[]{EXO_TRASHFOLDER}, false);
            observation.addEventListener((EventListener)new LinkRemoveListener(), 8, null, false, null, new String[]{ECD_CLOUDFILELINK}, false);
        }
        finally {
            session.logout();
        }
    }

    protected void setPermissions(Node node, String ... identities) throws AccessControlException, RepositoryException {
        this.setPermissions(node, true, true, identities);
    }

    protected void setPermissions(Node node, boolean deep, boolean forcePrivilegeable, String ... identities) throws AccessControlException, RepositoryException {
        ExtendedNode target = (ExtendedNode)node;
        boolean setPermissions = true;
        if (target.canAddMixin(EXO_PRIVILEGEABLE)) {
            if (forcePrivilegeable) {
                target.addMixin(EXO_PRIVILEGEABLE);
            } else {
                setPermissions = false;
            }
        }
        if (setPermissions) {
            for (String identity : identities) {
                target.setPermission(identity, READ_PERMISSION);
            }
        }
        if (deep) {
            NodeIterator niter = target.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.setPermissions(child, true, false, identities);
            }
        }
    }

    protected void removePermissions(Node node, boolean deep, String ... identities) throws AccessControlException, RepositoryException {
        ExtendedNode target = (ExtendedNode)node;
        if (target.isNodeType(EXO_PRIVILEGEABLE)) {
            for (String identity : identities) {
                target.removePermission(identity, "read");
            }
        }
        if (deep) {
            NodeIterator niter = target.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.removePermissions(child, true, identities);
            }
        }
    }

    protected void setParentPermissions(Node parent, String ... identities) throws AccessControlException, RepositoryException {
        NodeIterator citer = parent.getNodes();
        while (citer.hasNext()) {
            ExtendedNode child = (ExtendedNode)citer.nextNode();
            if (!child.canAddMixin(EXO_PRIVILEGEABLE)) continue;
            child.addMixin(EXO_PRIVILEGEABLE);
        }
        this.setPermissions(parent, false, true, identities);
    }

    protected void setAllPermissions(Node node, String ... identities) throws AccessControlException, RepositoryException {
        ExtendedNode target = (ExtendedNode)node;
        if (target.canAddMixin(EXO_PRIVILEGEABLE)) {
            target.addMixin(EXO_PRIVILEGEABLE);
        }
        for (String identity : identities) {
            target.setPermission(identity, PermissionType.ALL);
        }
    }

    protected String documentName(Node document) throws RepositoryException {
        try {
            return document.getProperty("exo:title").getString();
        }
        catch (PathNotFoundException te) {
            try {
                return document.getProperty("exo:name").getString();
            }
            catch (PathNotFoundException ne) {
                return document.getName();
            }
        }
    }

    protected Session systemSession() throws RepositoryException {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            ManageableRepository jcrRepository = this.jcrService.getCurrentRepository();
            String workspaceName = jcrRepository.getConfiguration().getDefaultWorkspaceName();
            return ssp.getSession(workspaceName, jcrRepository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected NodeIterator getCloudFileLinks(Node targetNode, String shareIdentity, boolean useSystemSession) throws RepositoryException {
        StringBuilder queryCode = new StringBuilder().append("SELECT * FROM ").append(ECD_CLOUDFILELINK).append(" WHERE exo:uuid='").append(targetNode.getUUID()).append("'");
        if (shareIdentity != null && shareIdentity.length() > 0) {
            queryCode.append(" AND ecd:shareIdentity='").append(shareIdentity).append("'");
        }
        QueryManager queryManager = useSystemSession ? this.systemSession().getWorkspace().getQueryManager() : targetNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryCode.toString(), "sql");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    protected class LinkTrashListener
    implements EventListener {
        private final Queue<String> processingLinks = new ConcurrentLinkedQueue<String>();

        protected LinkTrashListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    final String eventPath = event.getPath();
                    Session session = CloudFileActionService.this.systemSession();
                    Item linkItem = session.getItem(eventPath);
                    if (!linkItem.isNode() || !CloudFileActionService.this.linkManager.isLink(linkItem)) continue;
                    try {
                        Node fileNode = CloudFileActionService.this.linkManager.getTarget((Node)linkItem, true);
                        CloudDrive localDrive = CloudFileActionService.this.cloudDrive.findDrive(fileNode);
                        if (localDrive != null) {
                            if (localDrive.isConnected()) {
                                String cloudFileUUID;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud File link trashed. User: " + event.getUserID() + ". Path: " + eventPath));
                                }
                                if (this.processingLinks.contains(cloudFileUUID = fileNode.getUUID())) continue;
                                this.processingLinks.add(cloudFileUUID);
                                CloudFileActionService.this.removedLinks.values().remove(cloudFileUUID);
                                CloudFileActionService.this.removedLinks.put(eventPath, cloudFileUUID);
                                CloudFileActionService.this.workerExecutor.submit(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(2000L);
                                            Item linkItem = CloudFileActionService.this.systemSession().getItem(eventPath);
                                            if (linkItem.isNode()) {
                                                Node linkNode = (Node)linkItem;
                                                Node parent = linkNode.getParent();
                                                linkNode.remove();
                                                parent.save();
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)("Cloud File link '" + linkItem.getName() + "' successfully removed from the Trash."));
                                                }
                                            }
                                        }
                                        catch (PathNotFoundException e) {
                                            LOG.warn((Object)("Cloud File " + eventPath + " node already removed directly from JCR: " + e.getMessage()));
                                        }
                                        catch (InterruptedException e) {
                                            LOG.warn((Object)("Cloud File symlink remover interrupted " + e.getMessage()));
                                            Thread.currentThread().interrupt();
                                        }
                                        catch (Throwable e) {
                                            LOG.error((Object)("Error removing node of Cloud File " + eventPath + ". " + e.getMessage()), e);
                                        }
                                        finally {
                                            LinkTrashListener.this.processingLinks.remove(cloudFileUUID);
                                        }
                                    }
                                });
                                continue;
                            }
                            LOG.warn((Object)("Cloud Drive not connected for " + fileNode.getPath() + ". Drive: " + localDrive));
                            continue;
                        }
                        LOG.warn((Object)("Cloud Drive not found for " + fileNode.getPath()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Symlink " + eventPath + " removal error: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    try {
                        LOG.debug((Object)("Trashed item not found " + event.getPath() + ". " + e.getMessage()), (Throwable)e);
                    }
                    catch (RepositoryException repositoryException) {
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Symlink listener error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected class LinkRemoveListener
    implements EventListener {
        protected LinkRemoveListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    String identity;
                    String linkPath;
                    String cloudFileUUID;
                    String eventPath = event.getPath();
                    if (!eventPath.endsWith(CloudFileActionService.ECD_SHAREIDENTITY)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cloud File link removed. User: " + event.getUserID() + ". Path: " + eventPath));
                    }
                    if ((cloudFileUUID = CloudFileActionService.this.removedLinks.remove(linkPath = eventPath.substring(0, eventPath.indexOf(CloudFileActionService.ECD_SHAREIDENTITY) - 1))) == null || (identity = CloudFileActionService.this.removedShared.get(cloudFileUUID)) == null) continue;
                    Session session = CloudFileActionService.this.systemSession();
                    try {
                        Node fileNode = session.getNodeByUUID(cloudFileUUID);
                        CloudDrive localDrive = CloudFileActionService.this.cloudDrive.findDrive(fileNode);
                        if (localDrive == null || CloudFileActionService.this.getCloudFileLinks(fileNode, identity, true).getSize() != 0L) continue;
                        DriveData documentDrive = null;
                        if (identity.startsWith("/")) {
                            documentDrive = CloudFileActionService.this.documentDrives.getDriveByName(identity.replace('/', '.'));
                            if (documentDrive != null) {
                                CloudFileActionService.this.unshareCloudFile(fileNode, localDrive, documentDrive.getAllPermissions());
                            }
                        } else {
                            documentDrive = CloudFileActionService.this.getUserDrive(identity);
                            if (documentDrive != null) {
                                CloudFileActionService.this.unshareCloudFile(fileNode, localDrive, identity);
                            }
                        }
                        if (documentDrive != null || !LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cannot find documents drive for " + fileNode.getPath() + ". Unsharing not complete for this node."));
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Cloud File unsharing canceled due to removed drive: " + e.getMessage() + ". Path: " + eventPath));
                    }
                    catch (NotCloudDriveException e) {
                        LOG.warn((Object)("Cloud File unsharing not possible for not cloud drives: " + e.getMessage() + ". Path: " + eventPath));
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Cloud File unsharing error: " + e.getMessage() + ". Path: " + eventPath), e);
                    }
                    finally {
                        session.logout();
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Symlink removal listener error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

