/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.testing.compute;

import java.io.IOException;
import org.exoplatform.shaded.google.api.client.http.LowLevelHttpRequest;
import org.exoplatform.shaded.google.api.client.http.LowLevelHttpResponse;
import org.exoplatform.shaded.google.api.client.json.GenericJson;
import org.exoplatform.shaded.google.api.client.json.JsonFactory;
import org.exoplatform.shaded.google.api.client.json.jackson2.JacksonFactory;
import org.exoplatform.shaded.google.api.client.testing.http.MockHttpTransport;
import org.exoplatform.shaded.google.api.client.testing.http.MockLowLevelHttpRequest;
import org.exoplatform.shaded.google.api.client.testing.http.MockLowLevelHttpResponse;
import org.exoplatform.shaded.google.api.client.util.Beta;

@Beta
public class MockMetadataServerTransport
extends MockHttpTransport {
    private static final String METADATA_TOKEN_SERVER_URL = "http://metadata/computeMetadata/v1/instance/service-accounts/default/token";
    private static final String METADATA_SERVER_URL = "http://metadata.google.internal";
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    String accessToken;
    Integer tokenRequestStatusCode;

    public MockMetadataServerTransport(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenRequestStatusCode(Integer tokenRequestStatusCode) {
        this.tokenRequestStatusCode = tokenRequestStatusCode;
    }

    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        if (url.equals(METADATA_TOKEN_SERVER_URL)) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockMetadataServerTransport.this.tokenRequestStatusCode != null) {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setStatusCode(MockMetadataServerTransport.this.tokenRequestStatusCode).setContent("Token Fetch Error");
                        return response;
                    }
                    String metadataRequestHeader = this.getFirstHeaderValue("X-Google-Metadata-Request");
                    if (!"true".equals(metadataRequestHeader)) {
                        throw new IOException("Metadata request header not found.");
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(JSON_FACTORY);
                    refreshContents.put("access_token", (Object)MockMetadataServerTransport.this.accessToken);
                    refreshContents.put("expires_in", (Object)3600000);
                    refreshContents.put("token_type", (Object)"Bearer");
                    String refreshText = refreshContents.toPrettyString();
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                    return response;
                }
            };
            return request;
        }
        if (url.equals(METADATA_SERVER_URL)) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.addHeader("Metadata-Flavor", "Google");
                    return response;
                }
            };
            return request;
        }
        return super.buildRequest(method, url);
    }
}

