/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.json.JsonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;

public final class DbxHost
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final DbxHost Default = new DbxHost("api.dropbox.com", "api-content.dropbox.com", "www.dropbox.com", "api-notify.dropbox.com");
    public final String api;
    public final String content;
    public final String web;
    public final String notify;
    public static final JsonReader<DbxHost> Reader = new JsonReader<DbxHost>(){

        @Override
        public DbxHost read(JsonParser parser) throws IOException, JsonReadException {
            JsonToken t = parser.getCurrentToken();
            if (t == JsonToken.VALUE_STRING) {
                String s = parser.getText();
                JsonReader.nextToken(parser);
                return DbxHost.fromBaseHost(s);
            }
            if (t == JsonToken.START_OBJECT) {
                JsonLocation top = parser.getTokenLocation();
                1.nextToken(parser);
                String api = null;
                String content = null;
                String web = null;
                String notify = null;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("api")) {
                            api = JsonReader.StringReader.readField(parser, fieldName, api);
                            continue;
                        }
                        if (fieldName.equals("content")) {
                            content = JsonReader.StringReader.readField(parser, fieldName, content);
                            continue;
                        }
                        if (fieldName.equals("web")) {
                            web = JsonReader.StringReader.readField(parser, fieldName, web);
                            continue;
                        }
                        if (fieldName.equals("notify")) {
                            notify = JsonReader.StringReader.readField(parser, fieldName, notify);
                            continue;
                        }
                        throw new JsonReadException("unknown field", parser.getCurrentLocation());
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (api == null) {
                    throw new JsonReadException("missing field \"api\"", top);
                }
                if (content == null) {
                    throw new JsonReadException("missing field \"content\"", top);
                }
                if (web == null) {
                    throw new JsonReadException("missing field \"web\"", top);
                }
                if (notify == null) {
                    throw new JsonReadException("missing field \"notify\"", top);
                }
                return new DbxHost(api, content, web, notify);
            }
            throw new JsonReadException("expecting a string or an object", parser.getTokenLocation());
        }
    };
    public static final JsonWriter<DbxHost> Writer = new JsonWriter<DbxHost>(){

        @Override
        public void write(DbxHost host, JsonGenerator g) throws IOException {
            String base = host.inferBaseHost();
            if (base != null) {
                g.writeString(base);
            } else {
                g.writeStartObject();
                g.writeStringField("api", host.api);
                g.writeStringField("content", host.content);
                g.writeStringField("web", host.web);
                g.writeStringField("notify", host.notify);
                g.writeEndObject();
            }
        }
    };

    public DbxHost(String api, String content, String web, String notify) {
        this.api = api;
        this.content = content;
        this.web = web;
        this.notify = notify;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.equals((DbxHost)o);
    }

    public boolean equals(DbxHost o) {
        return this.api.equals(o.api) && this.content.equals(o.content) && this.web.equals(o.web);
    }

    public int hashCode() {
        return this.api.hashCode() + this.content.hashCode() + this.web.hashCode();
    }

    private static DbxHost fromBaseHost(String s) {
        return new DbxHost("api-" + s, "api-content-" + s, "meta-" + s, "api-notify-" + s);
    }

    private String inferBaseHost() {
        if (this.web.startsWith("meta-") && this.api.startsWith("api-") && this.content.startsWith("api-content-") && this.notify.startsWith("api-notify-")) {
            String webBase = this.web.substring("meta-".length());
            String apiBase = this.api.substring("api-".length());
            String contentBase = this.content.substring("api-content-".length());
            String notifyBase = this.notify.substring("api-notify-".length());
            if (webBase.equals(apiBase) && webBase.equals(contentBase) && webBase.equals(notifyBase)) {
                return webBase;
            }
        }
        return null;
    }
}

