/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.ExpectedSharedContentLinkMetadata;
import com.dropbox.core.v2.sharing.FilePermission;
import com.dropbox.core.v2.sharing.FolderPolicy;
import com.dropbox.core.v2.sharing.SharedContentLinkMetadata;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class SharedFileMetadata {
    protected final AccessLevel accessType;
    protected final String id;
    protected final ExpectedSharedContentLinkMetadata expectedLinkMetadata;
    protected final SharedContentLinkMetadata linkMetadata;
    protected final String name;
    protected final List<String> ownerDisplayNames;
    protected final Team ownerTeam;
    protected final String parentSharedFolderId;
    protected final String pathDisplay;
    protected final String pathLower;
    protected final List<FilePermission> permissions;
    protected final FolderPolicy policy;
    protected final String previewUrl;
    protected final Date timeInvited;

    public SharedFileMetadata(String id, String name, FolderPolicy policy, String previewUrl, AccessLevel accessType, ExpectedSharedContentLinkMetadata expectedLinkMetadata, SharedContentLinkMetadata linkMetadata, List<String> ownerDisplayNames, Team ownerTeam, String parentSharedFolderId, String pathDisplay, String pathLower, List<FilePermission> permissions, Date timeInvited) {
        this.accessType = accessType;
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 4) {
            throw new IllegalArgumentException("String 'id' is shorter than 4");
        }
        if (!Pattern.matches("id:.+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        this.expectedLinkMetadata = expectedLinkMetadata;
        this.linkMetadata = linkMetadata;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (ownerDisplayNames != null) {
            for (String string : ownerDisplayNames) {
                if (string != null) continue;
                throw new IllegalArgumentException("An item in list 'ownerDisplayNames' is null");
            }
        }
        this.ownerDisplayNames = ownerDisplayNames;
        this.ownerTeam = ownerTeam;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        this.pathDisplay = pathDisplay;
        this.pathLower = pathLower;
        if (permissions != null) {
            for (FilePermission filePermission : permissions) {
                if (filePermission != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        if (previewUrl == null) {
            throw new IllegalArgumentException("Required value for 'previewUrl' is null");
        }
        this.previewUrl = previewUrl;
        this.timeInvited = LangUtil.truncateMillis(timeInvited);
    }

    public SharedFileMetadata(String id, String name, FolderPolicy policy, String previewUrl) {
        this(id, name, policy, previewUrl, null, null, null, null, null, null, null, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public ExpectedSharedContentLinkMetadata getExpectedLinkMetadata() {
        return this.expectedLinkMetadata;
    }

    public SharedContentLinkMetadata getLinkMetadata() {
        return this.linkMetadata;
    }

    public List<String> getOwnerDisplayNames() {
        return this.ownerDisplayNames;
    }

    public Team getOwnerTeam() {
        return this.ownerTeam;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getPathDisplay() {
        return this.pathDisplay;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public List<FilePermission> getPermissions() {
        return this.permissions;
    }

    public Date getTimeInvited() {
        return this.timeInvited;
    }

    public static Builder newBuilder(String id, String name, FolderPolicy policy, String previewUrl) {
        return new Builder(id, name, policy, previewUrl);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.id, this.expectedLinkMetadata, this.linkMetadata, this.name, this.ownerDisplayNames, this.ownerTeam, this.parentSharedFolderId, this.pathDisplay, this.pathLower, this.permissions, this.policy, this.previewUrl, this.timeInvited});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFileMetadata other = (SharedFileMetadata)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.name != other.name && !this.name.equals(other.name) || this.policy != other.policy && !this.policy.equals(other.policy) || this.previewUrl != other.previewUrl && !this.previewUrl.equals(other.previewUrl) || this.accessType != other.accessType && (this.accessType == null || !this.accessType.equals((Object)other.accessType)) || this.expectedLinkMetadata != other.expectedLinkMetadata && (this.expectedLinkMetadata == null || !this.expectedLinkMetadata.equals(other.expectedLinkMetadata)) || this.linkMetadata != other.linkMetadata && (this.linkMetadata == null || !this.linkMetadata.equals(other.linkMetadata)) || this.ownerDisplayNames != other.ownerDisplayNames && (this.ownerDisplayNames == null || !this.ownerDisplayNames.equals(other.ownerDisplayNames)) || this.ownerTeam != other.ownerTeam && (this.ownerTeam == null || !this.ownerTeam.equals(other.ownerTeam)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.pathDisplay != other.pathDisplay && (this.pathDisplay == null || !this.pathDisplay.equals(other.pathDisplay)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.timeInvited != other.timeInvited && (this.timeInvited == null || !this.timeInvited.equals(other.timeInvited)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedFileMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFileMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("policy");
            FolderPolicy.Serializer.INSTANCE.serialize(value.policy, g);
            g.writeFieldName("preview_url");
            StoneSerializers.string().serialize(value.previewUrl, g);
            if (value.accessType != null) {
                g.writeFieldName("access_type");
                StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).serialize(value.accessType, g);
            }
            if (value.expectedLinkMetadata != null) {
                g.writeFieldName("expected_link_metadata");
                StoneSerializers.nullableStruct(ExpectedSharedContentLinkMetadata.Serializer.INSTANCE).serialize(value.expectedLinkMetadata, g);
            }
            if (value.linkMetadata != null) {
                g.writeFieldName("link_metadata");
                StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).serialize(value.linkMetadata, g);
            }
            if (value.ownerDisplayNames != null) {
                g.writeFieldName("owner_display_names");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.ownerDisplayNames, g);
            }
            if (value.ownerTeam != null) {
                g.writeFieldName("owner_team");
                StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).serialize(value.ownerTeam, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.pathDisplay != null) {
                g.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g);
            }
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(FilePermission.Serializer.INSTANCE)).serialize(value.permissions, g);
            }
            if (value.timeInvited != null) {
                g.writeFieldName("time_invited");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.timeInvited, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFileMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_timeInvited;
            List<FilePermission> f_permissions;
            String f_pathLower;
            String f_pathDisplay;
            String f_parentSharedFolderId;
            Team f_ownerTeam;
            List<String> f_ownerDisplayNames;
            SharedContentLinkMetadata f_linkMetadata;
            ExpectedSharedContentLinkMetadata f_expectedLinkMetadata;
            AccessLevel f_accessType;
            String f_previewUrl;
            FolderPolicy f_policy;
            String f_name;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_name = null;
                f_policy = null;
                f_previewUrl = null;
                f_accessType = null;
                f_expectedLinkMetadata = null;
                f_linkMetadata = null;
                f_ownerDisplayNames = null;
                f_ownerTeam = null;
                f_parentSharedFolderId = null;
                f_pathDisplay = null;
                f_pathLower = null;
                f_permissions = null;
                f_timeInvited = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("policy".equals(field)) {
                        f_policy = (FolderPolicy)FolderPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("preview_url".equals(field)) {
                        f_previewUrl = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("access_type".equals(field)) {
                        f_accessType = StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("expected_link_metadata".equals(field)) {
                        f_expectedLinkMetadata = StoneSerializers.nullableStruct(ExpectedSharedContentLinkMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("link_metadata".equals(field)) {
                        f_linkMetadata = StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("owner_display_names".equals(field)) {
                        f_ownerDisplayNames = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    if ("owner_team".equals(field)) {
                        f_ownerTeam = StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(FilePermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("time_invited".equals(field)) {
                        f_timeInvited = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_policy == null) {
                    throw new JsonParseException(p, "Required field \"policy\" missing.");
                }
                if (f_previewUrl == null) {
                    throw new JsonParseException(p, "Required field \"preview_url\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFileMetadata value = new SharedFileMetadata(f_id, f_name, f_policy, f_previewUrl, f_accessType, f_expectedLinkMetadata, f_linkMetadata, f_ownerDisplayNames, f_ownerTeam, f_parentSharedFolderId, f_pathDisplay, f_pathLower, f_permissions, f_timeInvited);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String id;
        protected final String name;
        protected final FolderPolicy policy;
        protected final String previewUrl;
        protected AccessLevel accessType;
        protected ExpectedSharedContentLinkMetadata expectedLinkMetadata;
        protected SharedContentLinkMetadata linkMetadata;
        protected List<String> ownerDisplayNames;
        protected Team ownerTeam;
        protected String parentSharedFolderId;
        protected String pathDisplay;
        protected String pathLower;
        protected List<FilePermission> permissions;
        protected Date timeInvited;

        protected Builder(String id, String name, FolderPolicy policy, String previewUrl) {
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 4) {
                throw new IllegalArgumentException("String 'id' is shorter than 4");
            }
            if (!Pattern.matches("id:.+", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (policy == null) {
                throw new IllegalArgumentException("Required value for 'policy' is null");
            }
            this.policy = policy;
            if (previewUrl == null) {
                throw new IllegalArgumentException("Required value for 'previewUrl' is null");
            }
            this.previewUrl = previewUrl;
            this.accessType = null;
            this.expectedLinkMetadata = null;
            this.linkMetadata = null;
            this.ownerDisplayNames = null;
            this.ownerTeam = null;
            this.parentSharedFolderId = null;
            this.pathDisplay = null;
            this.pathLower = null;
            this.permissions = null;
            this.timeInvited = null;
        }

        public Builder withAccessType(AccessLevel accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder withExpectedLinkMetadata(ExpectedSharedContentLinkMetadata expectedLinkMetadata) {
            this.expectedLinkMetadata = expectedLinkMetadata;
            return this;
        }

        public Builder withLinkMetadata(SharedContentLinkMetadata linkMetadata) {
            this.linkMetadata = linkMetadata;
            return this;
        }

        public Builder withOwnerDisplayNames(List<String> ownerDisplayNames) {
            if (ownerDisplayNames != null) {
                for (String x : ownerDisplayNames) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'ownerDisplayNames' is null");
                }
            }
            this.ownerDisplayNames = ownerDisplayNames;
            return this;
        }

        public Builder withOwnerTeam(Team ownerTeam) {
            this.ownerTeam = ownerTeam;
            return this;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withPathDisplay(String pathDisplay) {
            this.pathDisplay = pathDisplay;
            return this;
        }

        public Builder withPathLower(String pathLower) {
            this.pathLower = pathLower;
            return this;
        }

        public Builder withPermissions(List<FilePermission> permissions) {
            if (permissions != null) {
                for (FilePermission x : permissions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'permissions' is null");
                }
            }
            this.permissions = permissions;
            return this;
        }

        public Builder withTimeInvited(Date timeInvited) {
            this.timeInvited = LangUtil.truncateMillis(timeInvited);
            return this;
        }

        public SharedFileMetadata build() {
            return new SharedFileMetadata(this.id, this.name, this.policy, this.previewUrl, this.accessType, this.expectedLinkMetadata, this.linkMetadata, this.ownerDisplayNames, this.ownerTeam, this.parentSharedFolderId, this.pathDisplay, this.pathLower, this.permissions, this.timeInvited);
        }
    }
}

