/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.jcr;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.impl.NodeFinderImpl;
import org.exoplatform.services.jcr.RepositoryService;

public class CMSNodeFinder
extends NodeFinderImpl
implements NodeFinder {
    public CMSNodeFinder(RepositoryService repositoryService, LinkManager linkManager) {
        super(repositoryService, linkManager);
    }

    public String cleanName(String name) {
        int extIndex = name.lastIndexOf(46);
        String fileName = extIndex >= 0 ? name.substring(0, extIndex) : name;
        String jcrName = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)fileName));
        if (extIndex >= 0) {
            jcrName = jcrName + name.substring(extIndex);
        }
        return jcrName;
    }

    public Item findItem(Session session, String absPath) throws PathNotFoundException, RepositoryException {
        return this.getItem(session, absPath, true);
    }

    public Collection<Node> findLinked(Session session, String uuid) throws PathNotFoundException, RepositoryException {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        try {
            Node target = session.getNodeByUUID(uuid);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery("SELECT * FROM exo:symlink WHERE exo:uuid='" + target.getUUID() + "'", "sql");
            QueryResult qr = q.execute();
            NodeIterator niter = qr.getNodes();
            while (niter.hasNext()) {
                res.add(niter.nextNode());
            }
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        return res;
    }
}

