/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.symlink;

import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlink;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlinkException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.MoveNodeManageComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;

@ComponentConfig(events={@EventConfig(listeners={MoveNodeActionListener.class}, confirm="UIWorkingArea.msg.confirm-move")})
public class CloudDriveMoveNodeManageComponent
extends MoveNodeManageComponent {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveMoveNodeManageComponent.class);

    public static class MoveNodeActionListener
    extends MoveNodeManageComponent.MoveNodeActionListener {
        public void processEvent(Event<MoveNodeManageComponent> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            String destInfo = event.getRequestContext().getRequestParameter("destInfo");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((MoveNodeManageComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            CloudFileSymlink symlinks = new CloudFileSymlink(uiExplorer);
            try {
                symlinks.setDestination(destInfo);
                if (srcPath.indexOf(";") > -1) {
                    String[] srcPaths;
                    for (String srcp : srcPaths = srcPath.split(";")) {
                        symlinks.addSource(srcp);
                    }
                } else {
                    symlinks.addSource(srcPath);
                }
                if (symlinks.move().create()) {
                    symlinks.getDestinationNode().getSession().save();
                    uiExplorer.updateAjax(event);
                    return;
                }
            }
            catch (CloudFileSymlinkException e) {
                LOG.warn((Object)e.getMessage());
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(e.getUIMessage());
                symlinks.getDestinationNode().getSession().refresh(false);
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)"Error creating link of cloud file. Default behaviour will be applied (file move).", (Throwable)e);
            }
            super.processEvent(event);
        }
    }
}

