/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudDriveStorage;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.ecms.BaseCloudDriveManagerComponent;
import org.exoplatform.clouddrive.ecms.filters.LocalNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={PushCloudFileActionListener.class})})
public class PushCloudFileManagerComponent
extends BaseCloudDriveManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(PushCloudFileManagerComponent.class);
    public static final String EVENT_NAME = "PushCloudFile";
    protected static final List<UIExtensionFilter> FILTERS = Arrays.asList(new LocalNodeFilter());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        if (EVENT_NAME.equals(name)) {
            this.initContext();
        }
        return super.renderEventURL(ajax, name, beanId, params);
    }

    public static class PushCloudFileActionListener
    extends EventListener<PushCloudFileManagerComponent> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(Event<PushCloudFileManagerComponent> event) throws Exception {
            UIAddressBar addressBar;
            String nodePath;
            String wsName;
            UIJCRExplorer explorer = (UIJCRExplorer)((PushCloudFileManagerComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.startsWith(wsName = explorer.getCurrentWorkspace())) {
                try {
                    nodePath = objectId.substring(wsName.length() + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    nodePath = null;
                }
            } else {
                nodePath = objectId.startsWith("/") ? objectId : null;
            }
            if (nodePath == null) throw new IllegalArgumentException("Cannot extract node path from objectId " + objectId);
            Item item = explorer.getSession().getItem(nodePath);
            if (!item.isNode()) throw new IllegalArgumentException("Not node " + nodePath);
            Node node = (Node)item;
            CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            CloudDrive drive = driveService.findDrive(node);
            if (drive != null) {
                CloudDriveStorage storage = (CloudDriveStorage)drive;
                try {
                    storage.create(node);
                }
                catch (DriveRemovedException e) {
                    LOG.warn((Object)e.getMessage());
                }
                catch (NotCloudDriveException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            explorer.refreshExplorer();
            UIWorkingArea workingArea = (UIWorkingArea)explorer.getChild(UIWorkingArea.class);
            UIActionBar actionBar = (UIActionBar)workingArea.getChild(UIActionBar.class);
            UIControl control = (UIControl)explorer.getChild(UIControl.class);
            if (control == null || (addressBar = (UIAddressBar)control.getChild(UIAddressBar.class)) == null) return;
            actionBar.setTabOptions(addressBar.getSelectedViewName());
        }
    }
}

