/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.clipboard;

import javax.jcr.Node;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlink;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlinkException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIClipboard;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;

@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UIClipboard.gtmpl", events={@EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={UIClipboard.DeleteActionListener.class}), @EventConfig(listeners={UIClipboard.ClearAllActionListener.class})})
public class CloudDriveClipboard
extends UIClipboard {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveClipboard.class);

    public static class PasteActionListener
    extends UIClipboard.PasteActionListener {
        public void execute(Event<UIClipboard> event) throws Exception {
            UIClipboard uiClipboard = (UIClipboard)event.getSource();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiClipboard.getAncestorOfType(UIJCRExplorer.class);
            String indexParam = event.getRequestContext().getRequestParameter("objectId");
            int index = Integer.parseInt(indexParam);
            ClipboardCommand selectedClipboard = (ClipboardCommand)uiClipboard.getClipboardData().get(index - 1);
            Node destNode = uiExplorer.getCurrentNode();
            CloudFileSymlink symlinks = new CloudFileSymlink(uiExplorer);
            try {
                symlinks.setDestination(destNode);
                symlinks.addSource(selectedClipboard.getWorkspace(), selectedClipboard.getSrcPath());
                boolean isCut = "cut".equals(selectedClipboard.getType());
                if (isCut) {
                    symlinks.move();
                }
                if (symlinks.create()) {
                    destNode.getSession().save();
                    if (isCut) {
                        uiClipboard.getClipboardData().remove(selectedClipboard);
                    }
                    uiExplorer.updateAjax(event);
                    return;
                }
            }
            catch (CloudFileSymlinkException e) {
                LOG.warn((Object)e.getMessage());
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(e.getUIMessage());
                destNode.getSession().refresh(false);
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)"Error creating link of cloud file. Default behaviour will be applied (file Paste).", (Throwable)e);
            }
            super.execute(event);
        }
    }
}

