/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.cmis.CMISConnector;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.sharepoint.SharepointAPI;
import org.exoplatform.clouddrive.sharepoint.SharepointConnector;
import org.exoplatform.clouddrive.sharepoint.SharepointException;
import org.exoplatform.clouddrive.sharepoint.SharepointUser;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalSharepointDrive
extends JCRLocalCMISDrive {
    protected JCRLocalSharepointDrive(SharepointUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws CloudDriveException, RepositoryException {
        super((CMISUser)user, driveNode, sessionProviders, finder, mimeTypes, exoURL);
        SharepointAPI api = user.api();
        this.saveAccess(driveNode, api.getPassword(), api.getServiceURL(), api.getRepositoryId());
    }

    protected JCRLocalSharepointDrive(SharepointConnector.API apiBuilder, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws RepositoryException, CloudDriveException {
        super((CMISUser)JCRLocalSharepointDrive.loadUser(apiBuilder, driveNode), driveNode, sessionProviders, finder, mimeTypes, exoURL);
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("sharepoint:siteURL", this.getUser().getSiteURL());
        driveNode.setProperty("sharepoint:siteTitle", this.getUser().getSiteTitle());
        driveNode.setProperty("sharepoint:userLogin", this.getUser().getSiteUser().getLoginName());
        driveNode.setProperty("sharepoint:userTitle", this.getUser().getSiteUser().getTitle());
    }

    protected static SharepointUser loadUser(SharepointConnector.API apiBuilder, Node driveNode) throws RepositoryException, SharepointException, CloudDriveException {
        SharepointUser user = (SharepointUser)JCRLocalCMISDrive.loadUser((CMISConnector.API)apiBuilder, (Node)driveNode);
        return user;
    }

    public SharepointUser getUser() {
        return (SharepointUser)this.user;
    }

    @Deprecated
    protected void readNodes_Old(Node parent, Map<String, List<Node>> nodes, boolean deep) throws RepositoryException {
        super.readNodes(parent, nodes, deep);
        SharepointAPI api = this.getUser().api();
        LinkedHashMap<String, List<Node>> newNodes = new LinkedHashMap<String, List<Node>>();
        for (Map.Entry<String, List<Node>> me : nodes.entrySet()) {
            if (me.getValue().size() <= 0) continue;
            if (this.fileAPI.isFile(me.getValue().get(0))) {
                newNodes.put(api.simpleId(me.getKey()), me.getValue());
                newNodes.put(api.documentId(me.getKey()), me.getValue());
                continue;
            }
            newNodes.put(me.getKey(), me.getValue());
        }
        nodes.clear();
        nodes.putAll(newNodes);
    }
}

