/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.cmis.CMISConnector;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.sharepoint.SharepointAPI;
import org.exoplatform.clouddrive.sharepoint.SharepointConnector;
import org.exoplatform.clouddrive.sharepoint.SharepointException;
import org.exoplatform.clouddrive.sharepoint.SharepointUser;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalSharepointDrive
extends JCRLocalCMISDrive {
    protected JCRLocalSharepointDrive(SharepointUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws CloudDriveException, RepositoryException {
        super((CMISUser)user, driveNode, sessionProviders, finder, mimeTypes, exoURL);
        SharepointAPI api = user.api();
        this.saveAccess(driveNode, api.getPassword(), api.getServiceURL(), api.getRepositoryId());
    }

    protected JCRLocalSharepointDrive(SharepointConnector.API apiBuilder, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws RepositoryException, CloudDriveException {
        super((CMISUser)JCRLocalSharepointDrive.loadUser(apiBuilder, driveNode), driveNode, sessionProviders, finder, mimeTypes, exoURL);
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("sharepoint:siteURL", this.getUser().getSiteURL());
        driveNode.setProperty("sharepoint:siteTitle", this.getUser().getSiteTitle());
        driveNode.setProperty("sharepoint:userLogin", this.getUser().getSiteUser().getLoginName());
        driveNode.setProperty("sharepoint:userTitle", this.getUser().getSiteUser().getTitle());
    }

    protected static SharepointUser loadUser(SharepointConnector.API apiBuilder, Node driveNode) throws RepositoryException, SharepointException, CloudDriveException {
        SharepointUser user = (SharepointUser)JCRLocalCMISDrive.loadUser((CMISConnector.API)apiBuilder, (Node)driveNode);
        return user;
    }

    public SharepointUser getUser() {
        return (SharepointUser)this.user;
    }

    protected String simpleFileId(String fileId) {
        String[] fidParts;
        if (fileId != null && (fidParts = fileId.split("-")).length > 1) {
            return fidParts[0];
        }
        return fileId;
    }

    protected void cleanUpdated(String fileId) throws RepositoryException, CloudDriveException {
        super.cleanUpdated(this.simpleFileId(fileId));
    }

    protected void cleanRemoved(String fileId) throws RepositoryException, CloudDriveException {
        super.cleanRemoved(this.simpleFileId(fileId));
    }

    protected synchronized void saveChanges(List<JCRLocalCloudDrive.FileChange> changes) throws RepositoryException, CloudDriveException {
        ArrayList<SharepointFileChange> fileChanges = new ArrayList<SharepointFileChange>();
        for (JCRLocalCloudDrive.FileChange ch : changes) {
            fileChanges.add(new SharepointFileChange(this.simpleFileId(ch.getFileId()), ch));
        }
        super.saveChanges(fileChanges);
    }

    protected synchronized void commitChanges(Collection<JCRLocalCloudDrive.FileChange> changes, Collection<JCRLocalCloudDrive.FileChange> skipped) throws RepositoryException, CloudDriveException {
        ArrayList<SharepointFileChange> filesChanged = new ArrayList<SharepointFileChange>();
        for (JCRLocalCloudDrive.FileChange ch : changes) {
            filesChanged.add(new SharepointFileChange(this.simpleFileId(ch.getFileId()), ch));
        }
        ArrayList<SharepointFileChange> filesSkipped = new ArrayList<SharepointFileChange>();
        for (JCRLocalCloudDrive.FileChange ch : skipped) {
            filesSkipped.add(new SharepointFileChange(this.simpleFileId(ch.getFileId()), ch));
        }
        super.commitChanges(filesChanged, filesSkipped);
    }

    class SharepointFileChange
    extends JCRLocalCloudDrive.FileChange {
        SharepointFileChange(String fileId, JCRLocalCloudDrive.FileChange orig) throws RepositoryException, CloudDriveException {
            super((JCRLocalCloudDrive)JCRLocalSharepointDrive.this, orig.getChangeId(), orig.getPath(), fileId, orig.isFolder(), orig.getChangeType(), orig.getSynchronizer());
            if (orig.getFileUUID() != null) {
                this.fileUUID = orig.getFileUUID();
            }
            if (orig.getFilePath() != null) {
                this.filePath = orig.getFilePath();
            }
            if (orig.getNode() != null) {
                this.node = orig.getNode();
            }
            if (orig.getFile() != null) {
                this.file = orig.getFile();
            }
            int i = 0;
            while ((long)i < orig.getApplied()) {
                this.applied.countDown();
                ++i;
            }
        }
    }
}

