/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.mapper.attachments.MapperAttachmentsPlugin;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugin.deletebyquery.DeleteByQueryPlugin;
import org.exoplatform.addons.es.EmbeddedNode;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EmbeddedESStartupServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(EmbeddedESStartupServlet.class);
    public static final String ES_EMBEDDED_ENABLED_PROPERTY_NAME = "exo.es.embedded.enabled";
    protected Node node;

    public void init() throws ServletException {
        String esEmbeddedEnabled = PropertyManager.getProperty((String)ES_EMBEDDED_ENABLED_PROPERTY_NAME);
        if (esEmbeddedEnabled != null && esEmbeddedEnabled.trim().equals("false")) {
            LOG.debug((Object)"ES Embedded node startup has been disabled");
            return;
        }
        LOG.info((Object)("Initializing elasticsearch Node '" + this.getServletName() + "'"));
        Settings.Builder settings = Settings.settingsBuilder();
        InputStream resourceAsStream = this.getServletContext().getResourceAsStream("/WEB-INF/elasticsearch.yml");
        if (resourceAsStream != null) {
            settings.loadFromStream("/WEB-INF/elasticsearch.yml", resourceAsStream);
            try {
                resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        settings.replacePropertyPlaceholders();
        if (settings.get("http.enabled") == null) {
            settings.put("http.enabled", false);
        }
        Environment environment = new Environment(settings.build());
        ArrayList plugins = new ArrayList();
        Collections.addAll(plugins, MapperAttachmentsPlugin.class, DeleteByQueryPlugin.class);
        this.node = new EmbeddedNode(environment, Version.CURRENT, plugins);
        this.node.start();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        if (this.node != null) {
            this.node.close();
        }
    }
}

