/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.ingest.attachment.IngestAttachmentPlugin;
import org.elasticsearch.ingest.common.IngestCommonPlugin;
import org.elasticsearch.mapper.attachments.MapperAttachmentsPlugin;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.transport.Netty4Plugin;
import org.exoplatform.addons.es.EmbeddedNode;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EmbeddedESStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = -7795035468127583905L;
    private static final Log LOG = ExoLogger.getLogger(EmbeddedESStartupServlet.class);
    public static final String ES_EMBEDDED_ENABLED_PROPERTY_NAME = "exo.es.embedded.enabled";
    public static final String ES_EMBEDDED_CONFIGURATION_FILE = "exo.es.embedded.configuration.file";
    protected Node node;

    public void init() throws ServletException {
        RootContainer.getInstance();
        String esEmbeddedEnabled = PropertyManager.getProperty((String)ES_EMBEDDED_ENABLED_PROPERTY_NAME);
        if (esEmbeddedEnabled != null && esEmbeddedEnabled.trim().equals("false")) {
            LOG.info((Object)"ES Embedded node startup has been disabled");
            return;
        }
        String esEmbeddedConfigurationPath = PropertyManager.getProperty((String)ES_EMBEDDED_CONFIGURATION_FILE);
        if (StringUtils.isBlank((String)esEmbeddedConfigurationPath)) {
            LOG.info((Object)"Use default ES Embedded configuration file location: /WEB-INF/elasticsearch.yml");
            esEmbeddedConfigurationPath = "/WEB-INF/elasticsearch.yml";
        } else {
            LOG.info((Object)("Loading ES Embedded configuration file from custom location : " + esEmbeddedConfigurationPath));
        }
        LOG.info((Object)("Initializing elasticsearch Node '" + this.getServletName() + "'"));
        Settings.Builder settings = Settings.builder();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = this.getServletContext().getResourceAsStream(esEmbeddedConfigurationPath);
            if (resourceAsStream == null) {
                resourceAsStream = new FileInputStream(esEmbeddedConfigurationPath);
            }
            settings.loadFromStream("/WEB-INF/elasticsearch.yml", resourceAsStream);
            settings.internalMap().forEach((key, value) -> {
                if (!StringUtils.isBlank((String)value)) {
                    while (value.contains("${")) {
                        String newValue = Deserializer.resolveString((String)value);
                        if (newValue.equals(value)) {
                            LOG.warn((Object)("can't resolve expression " + value));
                            break;
                        }
                        value = newValue;
                    }
                    settings.put(key, value);
                }
            });
        }
        catch (IOException e) {
            throw new ServletException("Error while initializing elasticsearch node '" + this.getServletName() + "'", (Throwable)e);
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Can't close Input Stream", (Throwable)e);
                }
            }
        }
        ArrayList plugins = new ArrayList();
        Collections.addAll(plugins, Netty4Plugin.class, IngestCommonPlugin.class, IngestAttachmentPlugin.class, ReindexPlugin.class, MapperAttachmentsPlugin.class);
        this.node = new EmbeddedNode(settings.build(), Version.CURRENT, plugins);
        try {
            this.node.start();
        }
        catch (NodeValidationException e) {
            LOG.error((Object)"Error when starting ES in embedded mode", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.node != null) {
            try {
                this.node.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error when stopping ES in embedded mode", (Throwable)e);
            }
        }
    }
}

