/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.exoinvitefriend.portlet.frontend;

import java.io.IOException;
import java.util.HashSet;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import juzu.Action;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.plugin.ajax.Ajax;
import juzu.request.RequestContext;
import juzu.request.SecurityContext;
import org.json.JSONObject;
import org.juzu.exoinvitefriend.portlet.commons.models.Invitation;
import org.juzu.exoinvitefriend.portlet.commons.services.IService;
import org.juzu.exoinvitefriend.portlet.frontend.JuZExoInviteFriendFrontendApplication_;
import org.juzu.exoinvitefriend.portlet.frontend.templates.editMode;
import org.juzu.exoinvitefriend.portlet.frontend.templates.index;

public class JuZExoInviteFriendFrontendApplication {
    @Inject
    PortletPreferences portletPreferences;
    @Inject
    IService iService;
    @Inject
    @Path(value="index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="editMode.gtmpl")
    editMode editModeTpl;
    private static final String ENABLE_STORE_DATA = "enableStoreData";
    private static final String INVITATION_URL = "invitationUrl";

    @View
    public Response index(RequestContext context) {
        if (PortletMode.EDIT.equals(context.getProperty(JuzuPortlet.PORTLET_MODE))) {
            Boolean enableStoreData = Boolean.valueOf(this.portletPreferences.getValue(ENABLE_STORE_DATA, "true"));
            String invitationUrl = this.portletPreferences.getValue(INVITATION_URL, "");
            return this.editModeTpl.with().set(ENABLE_STORE_DATA, (Object)enableStoreData).set(INVITATION_URL, (Object)invitationUrl).ok();
        }
        return this.indexTpl.ok();
    }

    @Ajax
    @Resource
    public Response sendInvitation(SecurityContext securityContext, String email) {
        String invitationUrl;
        String currentUserName = securityContext.getUserPrincipal().getName();
        JSONObject result = this.iService.sendInvitation(currentUserName, email, invitationUrl = this.portletPreferences.getValue(INVITATION_URL, ""));
        if (null != result) {
            return Response.ok((CharSequence)result.toString());
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response storeInvitation(SecurityContext securityContext, String email) {
        String currentUserName;
        Boolean enableStoreData = Boolean.valueOf(this.portletPreferences.getValue(ENABLE_STORE_DATA, "true"));
        if (enableStoreData.booleanValue() && null != this.iService.storeInvitation(this.valuateInvitation(currentUserName = securityContext.getUserPrincipal().getName(), email))) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response saveEditMode(String enableStoreData) {
        try {
            this.portletPreferences.setValue(ENABLE_STORE_DATA, enableStoreData);
            this.portletPreferences.store();
            return Response.ok((CharSequence)"ok");
        }
        catch (ReadOnlyException e) {
            e.printStackTrace();
        }
        catch (ValidatorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Response.ok((CharSequence)"nok");
    }

    private Invitation valuateInvitation(String inviter, String invitee) {
        Invitation invitation = new Invitation();
        invitation.setInviter(inviter);
        HashSet<String> invitee_emails = new HashSet<String>();
        invitee_emails.add(invitee);
        invitation.setInvitee_emails(invitee_emails);
        return invitation;
    }

    @Action
    public Response saveSettings(String enableStoreData, String invitationUrl) throws ReadOnlyException, IOException, ValidatorException {
        this.portletPreferences.setValue(ENABLE_STORE_DATA, enableStoreData);
        this.portletPreferences.setValue(INVITATION_URL, invitationUrl);
        this.portletPreferences.store();
        return JuZExoInviteFriendFrontendApplication_.index().with(JuzuPortlet.PORTLET_MODE, (Object)PortletMode.VIEW);
    }
}

