/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OAuthClientConfiguration
extends BaseComponentPlugin {
    public static final String CONFIG_CLIENT_ID = "client-id";
    public static final String CONFIG_CLIENT_SECRET = "client-secret";
    public static final String CONFIG_CLIENT_HOST = "client-host";
    public static final String CONFIG_CLIENT_SCHEMA = "client-schema";
    protected static final Log LOG = ExoLogger.getLogger(OAuthClientConfiguration.class);
    protected final Map<String, String> config;
    protected final String clientId;
    protected final String clientSecret;
    protected final String clientHost;
    protected final String clientSchema;

    public OAuthClientConfiguration(InitParams params) throws ConfigurationException {
        PropertiesParam param = params.getPropertiesParam("client-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters drive-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        String clientId = this.config.get(CONFIG_CLIENT_ID);
        if (clientId == null || (clientId = clientId.trim()).length() == 0) {
            throw new ConfigurationException("Property parameter client-id required.");
        }
        this.clientId = clientId;
        String clientSecret = this.config.get(CONFIG_CLIENT_SECRET);
        if (clientSecret == null || (clientSecret = clientSecret.trim()).length() == 0) {
            throw new ConfigurationException("Property parameter client-secret required.");
        }
        this.clientSecret = clientSecret;
        String schema = this.config.get(CONFIG_CLIENT_SCHEMA);
        if (schema == null || (schema = schema.trim()).length() == 0) {
            schema = "http";
        }
        this.clientSchema = schema;
        String host = this.config.get(CONFIG_CLIENT_HOST);
        if (host != null && (host = host.trim()).length() > 0) {
            this.clientHost = host;
        } else {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (host == null && interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (host == null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress()) continue;
                        host = address.getHostName();
                    }
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
            if (host == null) {
                try {
                    host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
            }
            this.clientHost = host;
            LOG.warn((Object)("Configuration of client-host is not set, will use " + host));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getClientSchema() {
        return this.clientSchema;
    }
}

