/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Moxtra {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private Moxtra() {
    }

    public static final Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static final Calendar getCalendar(Date time) {
        Calendar cal = Moxtra.getCalendar();
        cal.setTime(time);
        return cal;
    }

    public static final Calendar getCalendar(Long timeInMillis) {
        Calendar cal = Moxtra.getCalendar();
        cal.setTimeInMillis(timeInMillis);
        return cal;
    }

    public static final Date getDate(Long timeInMillis) {
        return Moxtra.getCalendar(timeInMillis).getTime();
    }

    public static final Date getDate(Date localDate) {
        return Moxtra.getCalendar(localDate).getTime();
    }

    public static final String formatDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    public static final Date parseDate(String dateStr) throws ParseException {
        return DATE_FORMAT.parse(dateStr);
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        DATE_FORMAT.setTimeZone(tz);
    }
}

