/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.moxtra.MoxtraClientStore;
import org.exoplatform.moxtra.MoxtraStoreException;
import org.exoplatform.moxtra.OAuthClientConfiguration;
import org.exoplatform.moxtra.client.MoxtraClient;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.picocontainer.Startable;

public class MoxtraService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger(MoxtraService.class);
    protected OAuthClientConfiguration oAuthConfig;
    protected MoxtraClientStore usersStore;
    protected ConcurrentHashMap<String, MoxtraClient> users = new ConcurrentHashMap();

    public void start() {
        if (this.oAuthConfig == null) {
            throw new RuntimeException(new MoxtraConfigurationException("OAuth2 configuration not defined"));
        }
    }

    public void stop() {
        this.users.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoxtraClient getClient() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        MoxtraClient client = this.users.get(currentUser);
        if (client == null) {
            String string = currentUser;
            synchronized (string) {
                client = this.users.get(currentUser);
                if (client == null) {
                    client = this.createOAuthClient();
                    this.users.put(currentUser, client);
                }
            }
        }
        return client;
    }

    protected MoxtraClient createOAuthClient() {
        MoxtraClient client = new MoxtraClient(this.oAuthConfig.getClientId(), this.oAuthConfig.getClientSecret(), this.oAuthConfig.getClientSchema(), this.oAuthConfig.getClientHost());
        if (this.usersStore != null) {
            try {
                if (!this.usersStore.load(client)) {
                    this.usersStore.save(client);
                }
            }
            catch (MoxtraStoreException e) {
                LOG.error((Object)("Error processing client store operation: " + e.getMessage()), (Throwable)e);
            }
        }
        return client;
    }

    public OAuthClientConfiguration getOAuthConfig() {
        return this.oAuthConfig;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof OAuthClientConfiguration) {
            this.oAuthConfig = (OAuthClientConfiguration)plugin;
            LOG.info((Object)("OAuth2 client configuration set to " + plugin));
        } else if (plugin instanceof MoxtraClientStore) {
            this.usersStore = (MoxtraClientStore)plugin;
            LOG.info((Object)("Client store set to " + plugin));
        } else {
            LOG.warn((Object)("Unrecognized plugin ignored " + plugin));
        }
    }
}

