/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.oauth.client.httpclient4.OAuthCredentials;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponseFactory;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthRuntimeException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.moxtra.Moxtra;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.NotFoundException;
import org.exoplatform.moxtra.client.MeetDeletedException;
import org.exoplatform.moxtra.client.MoxtraAccessException;
import org.exoplatform.moxtra.client.MoxtraAuthenticationException;
import org.exoplatform.moxtra.client.MoxtraBinder;
import org.exoplatform.moxtra.client.MoxtraClientException;
import org.exoplatform.moxtra.client.MoxtraConfigurationException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraMeetRecording;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.oauth2.AccessToken;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class MoxtraClient {
    public static final String MOXTRA_USER_ME = "me";
    public static final String MOXTRA_URL = "https://www.moxtra.com/";
    public static final String API_V1 = "https://api.moxtra.com/";
    public static final String API_OAUTH_AUTHORIZE = "https://api.moxtra.com/oauth/authorize";
    public static final String API_USER = "https://api.moxtra.com/{user_id}";
    public static final String API_USER_CONTACTS = "https://api.moxtra.com/{user_id}/contacts";
    public static final String API_USER_MEETS = "https://api.moxtra.com/{user_id}/meets";
    public static final String API_MEETS_SCHEDULE = "https://api.moxtra.com/meets/schedule";
    public static final String API_MEETS_SESSION = "https://api.moxtra.com/meets/{session_key}";
    public static final String API_MEETS_INVITEUSER = "https://api.moxtra.com/meets/inviteuser";
    public static final String API_MEETS_RECORDINGS = "https://api.moxtra.com/meets/recordings/{session_key}";
    public static final String API_MEETS_STATUS = "https://api.moxtra.com/meets/status/{session_key}";
    public static final String API_BINDER = "https://api.moxtra.com/{binder_id}";
    public static final String API_BINDER_INVITEUSER = "https://api.moxtra.com/{binder_id}/inviteuser";
    public static final String API_BINDER_REMOVEUSER = "https://api.moxtra.com/{binder_id}/removeuser";
    public static final String RESPONSE_SUCCESS = "RESPONSE_SUCCESS";
    public static final String REQUEST_CONTENT_TYPE_JSON = "application/json".intern();
    public static final String REQUEST_CONTENT_TYPE_BINARY = "application/octet-stream".intern();
    public static final String REQUEST_ACCEPT = "Accept".intern();
    public static final String RESPONSE_ALLOW = "Allow".intern();
    public static final int GET_MEETS_LIST_MAX_DAYS = 30;
    public static final int DAY_MILLISECONDS = 86400000;
    public static final String RESPONSE_ERROR_NOT_FOUND = "RESPONSE_ERROR_NOT_FOUND".intern();
    protected static final Pattern HTML_ERROR_EXTRACT = Pattern.compile("<u>(.+?)</u>");
    protected static final String EMPTY = "".intern();
    protected static final Log LOG = ExoLogger.getLogger(MoxtraClient.class);
    protected final org.apache.http.client.HttpClient httpClient;
    protected final OAuthClient oAuthClient;
    protected final HttpContext context;
    protected final String oAuthClientId;
    protected final String oAuthClientSecret;
    protected final String oAuthClientSchema;
    protected final String oAuthClientHost;
    protected final Lock authLock = new ReentrantLock();
    protected final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    protected AccessToken oAuthToken = AccessToken.newToken();
    protected OAuth2Authorizer authorizer;

    public MoxtraClient(String oauthClientId, String oauthClientSecret, String oauthClientSchema, String oauthClientHost) {
        SSLSocketFactory socketFactory;
        this.oAuthClientId = oauthClientId;
        this.oAuthClientSecret = oauthClientSecret;
        this.oAuthClientSchema = oauthClientSchema;
        this.oAuthClientHost = oauthClientHost;
        SchemeRegistry schemeReg = new SchemeRegistry();
        schemeReg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(null, null);
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init((KeyStore)null);
            TrustManager[] trustmanagers = tmfactory.getTrustManagers();
            sslContext.init(keymanagers, trustmanagers, null);
            socketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context for Moxtra REST client", ex);
        }
        schemeReg.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeReg);
        connectionManager.setDefaultMaxPerRoute(4);
        connectionManager.setMaxTotal(40);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        try {
            URI uri = new URI(API_V1);
            HttpHost moxtraHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            client.getCredentialsProvider().setCredentials(new AuthScope(moxtraHost.getHostName(), moxtraHost.getPort()), (Credentials)new OAuthCredentials(oauthClientId, oauthClientSecret));
            this.httpClient = client;
            this.context = new BasicHttpContext();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(new MoxtraConfigurationException("Wrong Moxtra service URL syntax. " + e.getMessage(), e));
        }
        this.oAuthClient = new OAuthClient((HttpClient)new RESTClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2Authorizer authorizer() {
        if (this.authorizer == null) {
            this.authLock.lock();
            try {
                if (this.authorizer == null) {
                    this.authorizer = new OAuth2Authorizer();
                }
            }
            finally {
                this.authLock.unlock();
            }
        }
        return this.authorizer;
    }

    public boolean isAuthorized() {
        return this.oAuthToken.isInitialized();
    }

    public MoxtraUser getCurrentUser() throws MoxtraAuthenticationException, MoxtraException {
        return this.getUser(MOXTRA_USER_ME);
    }

    public MoxtraUser getUser(String userId) throws MoxtraAuthenticationException, MoxtraException {
        if (this.isAuthorized()) {
            try {
                String url = API_USER.replace("{user_id}", userId);
                RESTResponse resp = this.restRequest(url, "GET");
                JsonValue json = resp.getValue();
                JsonValue dv = json.getElement("data");
                if (!this.isNull(dv)) {
                    JsonValue vid = dv.getElement("id");
                    if (this.isNull(vid)) {
                        throw new MoxtraException("User request doesn't return user id");
                    }
                    JsonValue vname = dv.getElement("name");
                    if (this.isNull(vname)) {
                        throw new MoxtraException("User request doesn't return user name");
                    }
                    JsonValue vemail = dv.getElement("email");
                    if (this.isNull(vemail)) {
                        throw new MoxtraException("User request doesn't return user email");
                    }
                    JsonValue vFirstName = dv.getElement("first_name");
                    if (this.isNull(vFirstName)) {
                        throw new MoxtraException("User request doesn't return user first name");
                    }
                    JsonValue vLastName = dv.getElement("last_name");
                    if (this.isNull(vLastName)) {
                        throw new MoxtraException("User request doesn't return user last name");
                    }
                    JsonValue vtype = dv.getElement("type");
                    if (this.isNull(vtype)) {
                        throw new MoxtraException("User request doesn't return user type");
                    }
                    JsonValue vCreatedTime = dv.getElement("created_time");
                    if (this.isNull(vCreatedTime)) {
                        throw new MoxtraException("User request doesn't return user created time");
                    }
                    JsonValue vUpdatedTime = dv.getElement("updated_time");
                    if (this.isNull(vUpdatedTime)) {
                        throw new MoxtraException("User request doesn't return user updated time");
                    }
                    MoxtraUser user = new MoxtraUser(vid.getStringValue(), vname.getStringValue(), vemail.getStringValue(), vFirstName.getStringValue(), vLastName.getStringValue(), vtype.getStringValue(), "USER_TYPE_NORMAL", new Date(vCreatedTime.getLongValue()), new Date(vUpdatedTime.getLongValue()));
                    return user;
                }
                throw new MoxtraException("User request doesn't return an expected body (data)");
            }
            catch (OAuthSystemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
            catch (OAuthProblemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    public List<MoxtraUser> getContacts(MoxtraUser user) throws MoxtraAuthenticationException, MoxtraException {
        return this.getContacts(user.getId());
    }

    protected List<MoxtraUser> getContacts(String userId) throws MoxtraAuthenticationException, MoxtraException {
        if (this.isAuthorized()) {
            try {
                String url = API_USER_CONTACTS.replace("{user_id}", userId);
                RESTResponse resp = this.restRequest(url, "GET");
                JsonValue json = resp.getValue();
                JsonValue dv = json.getElement("data");
                if (!this.isNull(dv)) {
                    JsonValue csv = dv.getElement("contacts");
                    if (!this.isNull(csv) && csv.isArray()) {
                        ArrayList<MoxtraUser> contacts = new ArrayList<MoxtraUser>();
                        Iterator citer = csv.getElements();
                        while (citer.hasNext()) {
                            JsonValue cv = (JsonValue)citer.next();
                            JsonValue vemail = cv.getElement("email");
                            if (this.isNull(vemail)) {
                                throw new MoxtraException("User request doesn't return user email");
                            }
                            JsonValue vid = cv.getElement("id");
                            if (this.isNull(vid)) {
                                throw new MoxtraException("User request doesn't return user id");
                            }
                            JsonValue vname = cv.getElement("name");
                            if (this.isNull(vname)) {
                                throw new MoxtraException("User request doesn't return user name");
                            }
                            MoxtraUser contact = new MoxtraUser(vid.getStringValue(), vname.getStringValue(), vemail.getStringValue());
                            contacts.add(contact);
                        }
                        return contacts;
                    }
                    throw new MoxtraException("User request doesn't return an expected body (contacts)");
                }
                throw new MoxtraException("User request doesn't return an expected body (data)");
            }
            catch (OAuthSystemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
            catch (OAuthProblemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    @Deprecated
    public MoxtraMeet getMeetBinder(String binderId) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            String url = API_BINDER.replace("{binder_id}", binderId);
            RESTResponse resp = this.restRequest(url, "GET");
            JsonValue json = resp.getValue();
            JsonValue dv = json.getElement("data");
            if (!this.isNull(dv)) {
                JsonValue vbid = dv.getElement("id");
                if (this.isNull(vbid)) {
                    throw new MoxtraException("Binder request doesn't return id");
                }
                JsonValue vbname = dv.getElement("name");
                if (this.isNull(vbname)) {
                    throw new MoxtraException("Binder request doesn't return name");
                }
                JsonValue vrevision = dv.getElement("revision");
                if (this.isNull(vrevision)) {
                    throw new MoxtraException("Binder request doesn't return revision");
                }
                JsonValue vcreated = dv.getElement("created_time");
                if (this.isNull(vcreated)) {
                    throw new MoxtraException("Binder request doesn't return created_time");
                }
                JsonValue vupdated = dv.getElement("updated_time");
                if (this.isNull(vupdated)) {
                    throw new MoxtraException("Binder request doesn't return updated_time");
                }
                JsonValue vusers = dv.getElement("users");
                if (this.isNull(vusers) || !vusers.isArray()) {
                    throw new MoxtraException("Binder request doesn't return users array");
                }
                ArrayList<MoxtraUser> participants = new ArrayList<MoxtraUser>();
                Iterator vuiter = vusers.getElements();
                while (vuiter.hasNext()) {
                    JsonValue vue = (JsonValue)vuiter.next();
                    JsonValue vtype = vue.getElement("type");
                    if (this.isNull(vtype)) {
                        throw new MoxtraException("Binder request doesn't return user type");
                    }
                    JsonValue vstatus = vue.getElement("status");
                    if (this.isNull(vstatus)) {
                        throw new MoxtraException("Binder request doesn't return user status");
                    }
                    JsonValue vCreatedTime = vue.getElement("created_time");
                    if (this.isNull(vCreatedTime)) {
                        throw new MoxtraException("Binder request doesn't return user created time");
                    }
                    JsonValue vUpdatedTime = vue.getElement("updated_time");
                    if (this.isNull(vUpdatedTime)) {
                        throw new MoxtraException("Binder request doesn't return user updated time");
                    }
                    JsonValue vu = vue.getElement("user");
                    if (this.isNull(vu)) {
                        throw new MoxtraException("Binder request doesn't return user in users");
                    }
                    JsonValue vemail = vu.getElement("email");
                    if (this.isNull(vemail)) {
                        throw new MoxtraException("Binder request doesn't return user email");
                    }
                    String userEmail = vemail.getStringValue();
                    JsonValue vid = vu.getElement("id");
                    String userId = this.isNull(vid) ? userEmail : vid.getStringValue();
                    JsonValue vname = vu.getElement("name");
                    String userName = this.isNull(vname) ? userEmail : vname.getStringValue();
                    MoxtraUser user = new MoxtraUser(userId, userName, userEmail, null, null, vtype.getStringValue(), vstatus.getStringValue(), new Date(vCreatedTime.getLongValue()), new Date(vUpdatedTime.getLongValue()));
                    participants.add(user);
                }
                MoxtraMeet meet = new MoxtraMeet(vbid.getStringValue(), vbname.getStringValue(), vrevision.getLongValue(), new Date(vcreated.getLongValue()), new Date(vupdated.getLongValue()));
                meet.setUsers(participants);
                return meet;
            }
            throw new MoxtraException("Binder request doesn't return an expected body (data)");
        }
        throw new MoxtraException("Authorization required");
    }

    @Deprecated
    public MoxtraMeet getUpdateMeet(String sessionKey) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
            HashMap params = new HashMap();
            try {
                String url = API_MEETS_SESSION.replace("{session_key}", sessionKey);
                RESTResponse resp = this.restRequest(url, "POST", jsonGen.createJsonObjectFromMap(params).toString());
                JsonValue json = resp.getValue();
                JsonValue vcode = json.getElement("code");
                if (!this.isNull(vcode) && vcode.getStringValue().equals(RESPONSE_SUCCESS)) {
                    JsonValue vdata = json.getElement("data");
                    if (!this.isNull(vdata)) {
                        Date endTime;
                        Date startTime;
                        JsonValue vkey = vdata.getElement("session_key");
                        if (this.isNull(vkey)) {
                            throw new MoxtraException("Meet reading request doesn't return session_key");
                        }
                        sessionKey = vkey.getStringValue();
                        JsonValue vbid = vdata.getElement("schedule_binder_id");
                        if (this.isNull(vbid)) {
                            throw new MoxtraException("Meet reading request doesn't return schedule_binder_id");
                        }
                        JsonValue vbname = vdata.getElement("binder_name");
                        if (this.isNull(vbname)) {
                            throw new MoxtraException("Meet reading request doesn't return binder_name");
                        }
                        JsonValue vrevision = vdata.getElement("revision");
                        if (this.isNull(vrevision)) {
                            throw new MoxtraException("Meet reading request doesn't return revision");
                        }
                        JsonValue vurl = vdata.getElement("startmeet_url");
                        if (this.isNull(vurl)) {
                            throw new MoxtraException("Meet reading request doesn't return startmeet_url");
                        }
                        JsonValue vcreated = vdata.getElement("created_time");
                        if (this.isNull(vcreated)) {
                            throw new MoxtraException("Meet reading request doesn't return created_time");
                        }
                        JsonValue vupdated = vdata.getElement("updated_time");
                        if (this.isNull(vupdated)) {
                            throw new MoxtraException("Meet reading request doesn't return updated_time");
                        }
                        JsonValue vstarts = vdata.getElement("starts");
                        if (this.isNull(vstarts)) {
                            vstarts = vdata.getElement("scheduled_starts");
                            if (this.isNull(vstarts)) {
                                throw new MoxtraException("Meet reading request doesn't return starts time");
                            }
                            startTime = Moxtra.parseDate(vstarts.getStringValue());
                        } else {
                            startTime = new Date(vstarts.getLongValue());
                        }
                        JsonValue vends = vdata.getElement("ends");
                        if (this.isNull(vends)) {
                            vends = vdata.getElement("scheduled_ends");
                            if (this.isNull(vends)) {
                                throw new MoxtraException("Meet reading request doesn't return ends time");
                            }
                            endTime = Moxtra.parseDate(vends.getStringValue());
                        } else {
                            endTime = new Date(vends.getLongValue());
                        }
                        JsonValue vagenda = vdata.getElement("agenda");
                        if (this.isNull(vagenda)) {
                            throw new MoxtraException("Meet reading request doesn't return agenda");
                        }
                        JsonValue vautorec = vdata.getElement("auto_recording");
                        if (this.isNull(vautorec)) {
                            throw new MoxtraException("Meet reading request doesn't return auto_recording");
                        }
                        String status = this.getMeetStatus(sessionKey);
                        return new MoxtraMeet(vkey.getStringValue(), null, vbid.getStringValue(), vbname.getStringValue(), vagenda.getStringValue(), vrevision.getLongValue(), vurl.getStringValue(), Moxtra.getDate(vcreated.getLongValue()), Moxtra.getDate(vupdated.getLongValue()), startTime, endTime, vautorec.getBooleanValue(), status);
                    }
                    throw new MoxtraException("Meet schedule request doesn't return an expected body (data)");
                }
                throw new MoxtraException("Meet schedule request doesn't return an expected body (code)");
            }
            catch (JsonException e) {
                throw new MoxtraClientException("Error creating JSON request from meet parameters", e);
            }
            catch (ParseException e) {
                throw new MoxtraException("Error parsing meet time " + e.getMessage(), e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    public MoxtraMeet getMeet(String sessionKey) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            try {
                String url = API_MEETS_SESSION.replace("{session_key}", sessionKey);
                RESTResponse resp = this.restRequest(url.toString(), "GET");
                JsonValue json = resp.getValue();
                JsonValue vd = json.getElement("data");
                if (!this.isNull(vd)) {
                    MoxtraMeet meet = this.readMeet(vd);
                    return meet;
                }
                throw new MoxtraException("Meets request doesn't return an expected body (data)");
            }
            catch (NotFoundException e) {
                throw new MeetDeletedException("Meet session " + sessionKey + " was deleted", e);
            }
            catch (ParseException e) {
                throw new MoxtraException("Error parsing meet time " + e.getMessage(), e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    public void refreshMeet(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        Date endTime;
        Date startTime;
        Boolean autorec;
        String startLink;
        String agenda;
        String sessionKey;
        String sessionId;
        String name;
        MoxtraMeet remoteMeet = this.getMeet(meet.getSessionKey());
        String bid = remoteMeet.getBinderId();
        if (bid != null && bid.length() > 0) {
            meet.setBinderId(remoteMeet.getBinderId());
        }
        if ((name = remoteMeet.getName()) != null) {
            meet.setName(name);
        }
        if ((sessionId = remoteMeet.getSessionId()) != null) {
            meet.setSessionId(sessionId);
        }
        if ((sessionKey = remoteMeet.getSessionKey()) != null) {
            meet.setSessionId(sessionKey);
        }
        if ((agenda = remoteMeet.getAgenda()) != null) {
            meet.setAgenda(agenda);
        }
        if ((startLink = remoteMeet.getStartMeetUrl()) != null) {
            meet.setStartMeetUrl(startLink);
        }
        if ((autorec = remoteMeet.getAutoRecording()) != null) {
            meet.setAutoRecording(autorec);
        }
        if ((startTime = remoteMeet.getStartTime()) != null) {
            meet.setStartTime(startTime);
        }
        if ((endTime = remoteMeet.getEndTime()) != null) {
            meet.setEndTime(endTime);
        }
        try {
            meet.setHostUser(remoteMeet.getHostUser());
        }
        catch (MoxtraException e) {
            // empty catch block
        }
        meet.setStatus(remoteMeet.getStatus());
        meet.setCreatedTime(remoteMeet.getCreatedTime());
        meet.setUpdatedTime(remoteMeet.getUpdatedTime());
        meet.setRevision(remoteMeet.getRevision());
        meet.setThumbnailUrl(remoteMeet.getThumbnailUrl());
        meet.setUsers(remoteMeet.getUsers());
    }

    public List<MoxtraMeet> getMeets(String moxtraUserId, Date startsFrom, Integer days) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            if (days > 30) {
                LOG.warn((Object)"Meets search time period too large. Period cut to maximum 30 days");
                days = 30;
            }
            String starts = Moxtra.formatDate(startsFrom);
            try {
                RESTResponse resp;
                JsonValue json;
                JsonValue dv;
                StringBuilder url = new StringBuilder();
                url.append(API_USER_MEETS.replace("{user_id}", moxtraUserId));
                url.append("?starts=");
                url.append(URLEncoder.encode(starts, "UTF-8"));
                if (days != null && days > 0) {
                    url.append("&days=");
                    url.append(days);
                }
                if (!this.isNull(dv = (json = (resp = this.restRequest(url.toString(), "GET")).getValue()).getElement("data"))) {
                    JsonValue vmeets = dv.getElement("meets");
                    if (this.isNull(vmeets) || !vmeets.isArray()) {
                        throw new MoxtraException("Meets request doesn't return meets array");
                    }
                    ArrayList<MoxtraMeet> meets = new ArrayList<MoxtraMeet>();
                    Iterator vmiter = vmeets.getElements();
                    while (vmiter.hasNext()) {
                        JsonValue vmeet = (JsonValue)vmiter.next();
                        meets.add(this.readMeet(vmeet));
                    }
                    return meets;
                }
                throw new MoxtraException("Meets request doesn't return an expected body (data)");
            }
            catch (UnsupportedEncodingException e) {
                throw new MoxtraException("Error encoding meet search start date '" + starts + "'", e);
            }
            catch (ParseException e) {
                throw new MoxtraException("Error parsing meet time " + e.getMessage(), e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    public List<MoxtraMeet> getMeets(Date from, Integer toDays) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        return this.getMeets(MOXTRA_USER_ME, from, toDays);
    }

    @Deprecated
    public MoxtraMeet findMeet(String binderId, Date date) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        MoxtraMeet meet2;
        Calendar from = Moxtra.getCalendar(date);
        from.add(11, -168);
        int toDays = 23;
        for (MoxtraMeet meet2 : this.getMeets(MOXTRA_USER_ME, from.getTime(), toDays)) {
            if (!binderId.equals(meet2.getBinderId())) continue;
            return meet2;
        }
        MoxtraBinder meetBinder = this.getBinder(binderId);
        meet2 = new MoxtraMeet(null, null, meetBinder.getBinderId(), meetBinder.getName(), null, meetBinder.getRevision(), null, meetBinder.getCreatedTime(), meetBinder.getUpdatedTime(), null, null, null, null);
        ArrayList<MoxtraUser> participants = new ArrayList<MoxtraUser>();
        for (MoxtraUser bu : meetBinder.getUsers()) {
            String userId = bu.getId();
            if (userId != null && userId.length() > 0) {
                try {
                    MoxtraUser u = this.getUser(userId);
                    participants.add(new MoxtraUser(u.getId(), u.getName(), bu.getEmail(), u.getFirstName(), u.getLastName(), bu.getType(), bu.getStatus(), bu.getCreatedTime(), bu.getUpdatedTime()));
                }
                catch (MoxtraClientException e) {
                    LOG.warn((Object)("Error reading moxtra user " + bu.getId() + " (" + bu.getEmail() + ")"));
                    participants.add(bu);
                }
                continue;
            }
            participants.add(bu);
        }
        meet2.setUsers(participants);
        return meet2;
    }

    public MoxtraBinder getBinder(String binderId) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            String url = API_BINDER.replace("{binder_id}", binderId);
            RESTResponse resp = this.restRequest(url, "GET");
            JsonValue json = resp.getValue();
            JsonValue dv = json.getElement("data");
            if (!this.isNull(dv)) {
                JsonValue vbid = dv.getElement("id");
                if (this.isNull(vbid)) {
                    throw new MoxtraException("Binder request doesn't return id");
                }
                JsonValue vbname = dv.getElement("name");
                if (this.isNull(vbname)) {
                    throw new MoxtraException("Binder request doesn't return name");
                }
                JsonValue vrevision = dv.getElement("revision");
                if (this.isNull(vrevision)) {
                    throw new MoxtraException("Binder request doesn't return revision");
                }
                JsonValue vcreated = dv.getElement("created_time");
                if (this.isNull(vcreated)) {
                    throw new MoxtraException("Binder request doesn't return created_time");
                }
                JsonValue vupdated = dv.getElement("updated_time");
                if (this.isNull(vupdated)) {
                    throw new MoxtraException("Binder request doesn't return updated_time");
                }
                JsonValue vusers = dv.getElement("users");
                if (this.isNull(vusers) || !vusers.isArray()) {
                    throw new MoxtraException("Binder request doesn't return users array");
                }
                ArrayList<MoxtraUser> users = new ArrayList<MoxtraUser>();
                Iterator vuiter = vusers.getElements();
                while (vuiter.hasNext()) {
                    JsonValue vue = (JsonValue)vuiter.next();
                    JsonValue vutype = vue.getElement("type");
                    if (this.isNull(vutype)) {
                        throw new MoxtraException("Binder request doesn't return user type");
                    }
                    JsonValue vustatus = vue.getElement("status");
                    if (this.isNull(vustatus)) {
                        throw new MoxtraException("Binder request doesn't return user status");
                    }
                    JsonValue vucreated = vue.getElement("created_time");
                    if (this.isNull(vucreated)) {
                        throw new MoxtraException("Binder request doesn't return user created time");
                    }
                    JsonValue vuupdated = vue.getElement("updated_time");
                    if (this.isNull(vuupdated)) {
                        throw new MoxtraException("Binder request doesn't return user updated time");
                    }
                    JsonValue vu = vue.getElement("user");
                    if (this.isNull(vu)) {
                        throw new MoxtraException("Binder request doesn't return user in users");
                    }
                    JsonValue vuemail = vu.getElement("email");
                    if (this.isNull(vuemail)) {
                        throw new MoxtraException("Binder request doesn't return user email");
                    }
                    String userEmail = vuemail.getStringValue();
                    JsonValue vuid = vu.getElement("id");
                    String userId = this.isNull(vuid) ? userEmail : vuid.getStringValue();
                    JsonValue vuname = vu.getElement("name");
                    String userName = this.isNull(vuname) ? userEmail : vuname.getStringValue();
                    MoxtraUser user = new MoxtraUser(userId, userName, userEmail, null, null, vutype.getStringValue(), vustatus.getStringValue(), new Date(vucreated.getLongValue()), new Date(vuupdated.getLongValue()));
                    users.add(user);
                }
                MoxtraBinder binder = new MoxtraBinder(vbid.getStringValue(), vbname.getStringValue(), vrevision.getLongValue(), new Date(vcreated.getLongValue()), new Date(vupdated.getLongValue()));
                binder.setUsers(users);
                return binder;
            }
            throw new MoxtraException("Binder request doesn't return an expected body (data)");
        }
        throw new MoxtraException("Authorization required");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createMeet(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (!this.isAuthorized()) throw new MoxtraException("Authorization required");
        JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", meet.getName());
        params.put("agenda", meet.getAgenda());
        meet.checkTime();
        params.put("starts", Moxtra.formatDate(meet.getStartTime()));
        params.put("ends", Moxtra.formatDate(meet.getEndTime()));
        params.put("auto_recording", meet.isAutoRecording());
        try {
            RESTResponse resp = this.restRequest(API_MEETS_SCHEDULE, "POST", jsonGen.createJsonObjectFromMap(params).toString());
            JsonValue json = resp.getValue();
            JsonValue vcode = json.getElement("code");
            if (this.isNull(vcode) || !vcode.getStringValue().equals(RESPONSE_SUCCESS)) throw new MoxtraException("Meet schedule request doesn't return an expected body (code)");
            JsonValue vdata = json.getElement("data");
            if (this.isNull(vdata)) throw new MoxtraException("Meet schedule request doesn't return an expected body (data)");
            JsonValue vkey = vdata.getElement("session_key");
            if (this.isNull(vkey)) {
                throw new MoxtraException("Meet schedule request doesn't return session_key");
            }
            JsonValue vbid = vdata.getElement("schedule_binder_id");
            if (this.isNull(vbid)) {
                throw new MoxtraException("Meet schedule request doesn't return schedule_binder_id");
            }
            JsonValue vbname = vdata.getElement("binder_name");
            if (this.isNull(vbname)) {
                throw new MoxtraException("Meet schedule request doesn't return binder_name");
            }
            JsonValue vrevision = vdata.getElement("revision");
            if (this.isNull(vrevision)) {
                throw new MoxtraException("Meet schedule request doesn't return revision");
            }
            JsonValue vurl = vdata.getElement("startmeet_url");
            if (this.isNull(vurl)) {
                throw new MoxtraException("Meet schedule request doesn't return startmeet_url");
            }
            JsonValue vcreated = vdata.getElement("created_time");
            if (this.isNull(vcreated)) {
                throw new MoxtraException("Meet schedule request doesn't return created_time");
            }
            JsonValue vupdated = vdata.getElement("updated_time");
            if (this.isNull(vupdated)) {
                throw new MoxtraException("Meet schedule request doesn't return updated_time");
            }
            meet.setSessionKey(vkey.getStringValue());
            meet.setBinderId(vbid.getStringValue());
            meet.setName(vbname.getStringValue());
            meet.setRevision(vrevision.getLongValue());
            meet.setStartMeetUrl(vurl.getStringValue());
            meet.setCreatedTime(Moxtra.getDate(vcreated.getLongValue()));
            meet.setUpdatedTime(Moxtra.getDate(vupdated.getLongValue()));
            this.inviteMeetUsers(meet);
            return;
        }
        catch (JsonException e) {
            throw new MoxtraClientException("Error creating JSON request from meet parameters", e);
        }
    }

    public List<MoxtraMeetRecording> getMeetRecordings(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            try {
                String url = API_MEETS_RECORDINGS.replace("{session_key}", meet.getSessionKey());
                RESTResponse resp = this.restRequest(url, "GET");
                JsonValue json = resp.getValue();
                JsonValue vd = json.getElement("data");
                if (!this.isNull(vd)) {
                    JsonValue vrec = vd.getElement("recordings");
                    if (!this.isNull(vrec) && vrec.isArray()) {
                        ArrayList<MoxtraMeetRecording> recs = new ArrayList<MoxtraMeetRecording>();
                        Iterator riter = vrec.getElements();
                        while (riter.hasNext()) {
                            JsonValue vr = (JsonValue)riter.next();
                            JsonValue vlink = vr.getElement("download_url");
                            if (this.isNull(vlink)) {
                                throw new MoxtraException("Recordings request doesn't return download link");
                            }
                            JsonValue vtype = vr.getElement("content_type");
                            if (this.isNull(vtype)) {
                                throw new MoxtraException("Recordings request doesn't return content type");
                            }
                            JsonValue vlen = vr.getElement("content_length");
                            if (this.isNull(vlen)) {
                                throw new MoxtraException("Recordings request doesn't return content length");
                            }
                            JsonValue vcreated = vr.getElement("created_time");
                            if (this.isNull(vcreated)) {
                                throw new MoxtraException("Recordings request doesn't return created time");
                            }
                            MoxtraMeetRecording rec = new MoxtraMeetRecording(vtype.getStringValue(), vlen.getLongValue(), Moxtra.getDate(vcreated.getLongValue()), vlink.getStringValue());
                            recs.add(rec);
                        }
                        return recs;
                    }
                    throw new MoxtraException("User request doesn't return an expected body (recordings)");
                }
                throw new MoxtraException("User request doesn't return an expected body (data)");
            }
            catch (OAuthSystemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
            catch (OAuthProblemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    protected String getMeetStatus(String sessionKey) throws MoxtraException, MoxtraClientException, MoxtraAuthenticationException {
        if (this.isAuthorized()) {
            try {
                String url = API_MEETS_STATUS.replace("{session_key}", sessionKey);
                RESTResponse resp = this.restRequest(url, "GET");
                JsonValue json = resp.getValue();
                JsonValue vd = json.getElement("data");
                if (!this.isNull(vd)) {
                    JsonValue vstatus = vd.getElement("status");
                    if (this.isNull(vstatus)) {
                        throw new MoxtraException("Meet status request doesn't return status");
                    }
                    return vstatus.getStringValue();
                }
                throw new MoxtraException("Meet status request doesn't return an expected body (data)");
            }
            catch (OAuthSystemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
            catch (OAuthProblemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    public InputStream requestGet(String url, String contentType) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            try {
                RESTResponse resp = this.restRequest(url, "GET", contentType, null);
                InputStream res = resp.getInputStream();
                return res;
            }
            catch (OAuthSystemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
            catch (OAuthProblemException e) {
                throw new MoxtraAuthenticationException("Authentication error", e);
            }
        }
        throw new MoxtraException("Authorization required");
    }

    @Deprecated
    public void renameMeet(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (meet.hasNameChanged()) {
            this.renameBinder(meet);
        }
        if (meet.hasUsersAdded()) {
            this.inviteMeetUsers(meet);
        }
        if (meet.hasUsersRemoved()) {
            this.removeUsers(meet);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateMeet(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (!this.isAuthorized()) throw new MoxtraException("Authorization required");
        String meetStatus = this.getMeetStatus(meet.getSessionKey());
        if (MoxtraMeet.SESSION_SCHEDULED.equals(meetStatus)) {
            boolean haveUpdates = false;
            JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (meet.hasNameChanged()) {
                params.put("name", meet.getName());
                haveUpdates = true;
            }
            if (meet.hasAgendaChanged()) {
                params.put("agenda", meet.getAgenda());
                haveUpdates = true;
            }
            if (meet.hasStartTimeChanged() || meet.hasEndTimeChanged()) {
                meet.checkTime();
                params.put("starts", Moxtra.formatDate(meet.getStartTime()));
                params.put("ends", Moxtra.formatDate(meet.getEndTime()));
                haveUpdates = true;
            }
            if (meet.hasAutoRecordingChanged()) {
                params.put("auto_recording", meet.isAutoRecording());
                haveUpdates = true;
            }
            if (haveUpdates) {
                try {
                    String url = API_MEETS_SESSION.replace("{session_key}", meet.getSessionKey());
                    RESTResponse resp = this.restRequest(url, "POST", jsonGen.createJsonObjectFromMap(params).toString());
                    JsonValue json = resp.getValue();
                    JsonValue vcode = json.getElement("code");
                    if (this.isNull(vcode) || !vcode.getStringValue().equals(RESPONSE_SUCCESS)) throw new MoxtraException("Meet update request doesn't return an expected body (code)");
                    JsonValue vdata = json.getElement("data");
                    if (this.isNull(vdata)) throw new MoxtraException("Meet update request doesn't return an expected body (data)");
                    JsonValue vkey = vdata.getElement("session_key");
                    if (this.isNull(vkey)) {
                        throw new MoxtraException("Meet update request doesn't return session_key");
                    }
                    JsonValue vbid = vdata.getElement("schedule_binder_id");
                    if (this.isNull(vbid)) {
                        throw new MoxtraException("Meet update request doesn't return schedule_binder_id");
                    }
                    JsonValue vbname = vdata.getElement("binder_name");
                    if (this.isNull(vbname)) {
                        throw new MoxtraException("Meet update request doesn't return binder_name");
                    }
                    JsonValue vrevision = vdata.getElement("revision");
                    if (this.isNull(vrevision)) {
                        throw new MoxtraException("Meet update request doesn't return revision");
                    }
                    JsonValue vurl = vdata.getElement("startmeet_url");
                    if (this.isNull(vurl)) {
                        throw new MoxtraException("Meet update request doesn't return startmeet_url");
                    }
                    JsonValue vcreated = vdata.getElement("created_time");
                    if (this.isNull(vcreated)) {
                        throw new MoxtraException("Meet update request doesn't return created_time");
                    }
                    JsonValue vupdated = vdata.getElement("updated_time");
                    if (this.isNull(vupdated)) {
                        throw new MoxtraException("Meet update request doesn't return updated_time");
                    }
                    meet.setSessionKey(vkey.getStringValue());
                    meet.setBinderId(vbid.getStringValue());
                    meet.setName(vbname.getStringValue());
                    meet.setRevision(vrevision.getLongValue());
                    meet.setStartMeetUrl(vurl.getStringValue());
                    meet.setCreatedTime(Moxtra.getDate(vcreated.getLongValue()));
                    meet.setUpdatedTime(Moxtra.getDate(vupdated.getLongValue()));
                }
                catch (JsonException e) {
                    throw new MoxtraClientException("Error creating JSON request from meet update", e);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Meet has not changes " + meet.getBinderId() + " " + meet.getName()));
            }
        }
        meet.setStatus(meetStatus);
        if (meet.hasUsersAdded()) {
            this.inviteMeetUsers(meet);
        }
        if (!meet.hasUsersRemoved()) return;
        this.removeUsers(meet);
    }

    public void deleteMeet(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (!this.isAuthorized()) {
            throw new MoxtraException("Authorization required");
        }
        String url = API_MEETS_SESSION.replace("{session_key}", meet.getSessionKey());
        this.restRequest(url, "DELETE");
        meet.setStatus(MoxtraMeet.SESSION_DELETED);
    }

    public void deleteBinder(MoxtraBinder binder) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (!this.isAuthorized()) {
            throw new MoxtraException("Authorization required");
        }
        String url = API_BINDER.replace("{binder_id}", binder.getBinderId());
        this.restRequest(url, "DELETE");
    }

    public void renameBinder(MoxtraBinder binder) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", binder.getName());
            try {
                String url = API_BINDER.replace("{binder_id}", binder.getBinderId());
                this.restRequest(url, "POST", jsonGen.createJsonObjectFromMap(params).toString());
            }
            catch (JsonException e) {
                throw new MoxtraClientException("Error creating JSON request from binder parameters", e);
            }
        } else {
            throw new MoxtraException("Authorization required");
        }
    }

    public boolean inviteMeetUsers(MoxtraMeet meet) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        List<MoxtraUser> users = meet.isNew() ? meet.getUsers() : (meet.hasUsersAdded() ? meet.getAddedUsers() : null);
        if (users != null && users.size() > 0) {
            if (this.isAuthorized()) {
                JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("session_key", meet.getSessionKey());
                ArrayList usersList = new ArrayList();
                for (MoxtraUser user : users) {
                    HashMap<String, String> emailMap = new HashMap<String, String>();
                    emailMap.put("email", user.getEmail());
                    HashMap<String, HashMap<String, String>> userMap = new HashMap<String, HashMap<String, String>>();
                    userMap.put("user", emailMap);
                    usersList.add(userMap);
                }
                params.put("users", usersList);
                params.put("message", "Please join the " + meet.getName());
                try {
                    this.restRequest(API_MEETS_INVITEUSER, "POST", jsonGen.createJsonObjectFromMap(params).toString());
                    return true;
                }
                catch (JsonException e) {
                    throw new MoxtraClientException("Error creating JSON request from binder parameters", e);
                }
            }
            throw new MoxtraException("Authorization required");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("inviteMeetUsers: empty users list for " + meet.getName() + " " + (meet.isNew() ? "" : "(" + meet.getBinderId() + ")")));
        }
        return false;
    }

    public boolean inviteUsers(MoxtraBinder binder) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        List<MoxtraUser> users = binder.isNew() ? binder.getUsers() : (binder.hasUsersAdded() ? binder.getAddedUsers() : null);
        if (users != null && users.size() > 0) {
            if (this.isAuthorized()) {
                JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList usersList = new ArrayList();
                for (MoxtraUser user : users) {
                    HashMap<String, String> emailMap = new HashMap<String, String>();
                    emailMap.put("email", user.getEmail());
                    HashMap<String, HashMap<String, String>> userMap = new HashMap<String, HashMap<String, String>>();
                    userMap.put("user", emailMap);
                    usersList.add(userMap);
                }
                params.put("users", usersList);
                params.put("message", "Please join the " + binder.getName());
                try {
                    String url = API_BINDER_INVITEUSER.replace("{binder_id}", binder.getBinderId());
                    this.restRequest(url, "POST", jsonGen.createJsonObjectFromMap(params).toString());
                    return true;
                }
                catch (JsonException e) {
                    throw new MoxtraClientException("Error creating JSON request from binder parameters", e);
                }
            }
            throw new MoxtraException("Authorization required");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("inviteUsers: empty users list for " + binder.getName() + " " + (binder.isNew() ? "" : "(" + binder.getBinderId() + ")")));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeUsers(MoxtraBinder binder) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        List<MoxtraUser> users = binder.hasUsersRemoved() ? binder.getRemovedUsers() : null;
        if (users != null && users.size() > 0) {
            if (!this.isAuthorized()) throw new MoxtraException("Authorization required");
            for (MoxtraUser user : users) {
                JsonGeneratorImpl jsonGen = new JsonGeneratorImpl();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("email", user.getEmail());
                try {
                    String url = API_BINDER_REMOVEUSER.replace("{binder_id}", binder.getBinderId());
                    this.restRequest(url, "POST", jsonGen.createJsonObjectFromMap(params).toString());
                }
                catch (JsonException e) {
                    throw new MoxtraClientException("Error creating JSON request from binder user removal " + user.getEmail(), e);
                }
                catch (NotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("removeUsers: user " + user + " not found in " + binder.getBinderId() + " \"" + binder.getName() + "\""));
                }
            }
            return;
        } else {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("removeUsers: empty users list for " + binder.getBinderId() + " " + binder.getName()));
        }
    }

    protected RESTError readError(RESTResponse resp) {
        String code;
        String message;
        JsonValue json = resp.getValue();
        if (!this.isNull(json)) {
            JsonValue c;
            JsonValue msg;
            JsonValue error = json.getElement("error");
            if (!this.isNull(error)) {
                msg = error.getElement("message");
                if (!this.isNull(msg)) {
                    JsonValue emv = msg.getElement("value");
                    message = !this.isNull(msg) ? emv.getStringValue() : EMPTY;
                } else {
                    message = error.getStringValue();
                }
                JsonValue c2 = json.getElement("code");
                code = !this.isNull(c2) ? c2.getStringValue() : null;
            } else {
                message = EMPTY;
                code = null;
            }
            if (message == EMPTY && !this.isNull(msg = json.getElement("message"))) {
                message = msg.getStringValue();
            }
            if (code == null && !this.isNull(c = json.getElement("code"))) {
                code = c.getStringValue();
            }
        } else {
            String text = resp.getText();
            if (text != null) {
                if (resp.getContentType().startsWith("text")) {
                    Matcher matcher = HTML_ERROR_EXTRACT.matcher(text);
                    message = matcher.find() ? matcher.group(1) : EMPTY;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Moxtra response (" + resp.getResponseCode() + "): =======================\r\n" + resp.getText() + "\r\n======================="));
                    }
                } else {
                    message = EMPTY;
                }
            } else {
                message = EMPTY;
            }
            code = null;
        }
        return new RESTError(code, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initOAuthToken(AccessToken newToken) {
        this.accessLock.writeLock().lock();
        try {
            this.oAuthToken.merge(newToken);
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessToken getOAuthToken() {
        this.accessLock.readLock().lock();
        try {
            AccessToken accessToken = this.oAuthToken;
            return accessToken;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String accessToken() {
        this.accessLock.readLock().lock();
        try {
            String string = this.oAuthToken.getAccessToken();
            return string;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    protected void checkError(RESTResponse resp) throws MoxtraException {
        if (resp.getResponseCode() == 401) {
            RESTError e = this.readError(resp);
            throw new MoxtraAccessException("Unauthorized, " + e.message);
        }
        if (resp.getResponseCode() == 403) {
            RESTError e = this.readError(resp);
            throw new MoxtraAccessException("Forbidden, " + e.message);
        }
        if (resp.getResponseCode() == 404) {
            RESTError e = this.readError(resp);
            if (RESPONSE_ERROR_NOT_FOUND.equals(e.code)) {
                throw new NotFoundException(e.message);
            }
            throw new MoxtraClientException("Not found, " + e.message);
        }
        if (resp.getResponseCode() == 405) {
            RESTError e = this.readError(resp);
            if (e.message != EMPTY) {
                throw new MoxtraClientException("Method not allowed, " + e.message);
            }
            Header allowHeader = resp.getHeader(RESPONSE_ALLOW);
            if (allowHeader != null) {
                throw new MoxtraClientException("Method not allowed. Allowed by server: " + allowHeader.getValue());
            }
            throw new MoxtraClientException("Method not allowed");
        }
        if (resp.getResponseCode() == 409) {
            RESTError e = this.readError(resp);
            throw new MoxtraClientException("Conflict " + e.message);
        }
        if (resp.getResponseCode() == 413) {
            RESTError e = this.readError(resp);
            throw new MoxtraClientException("Data too larger, " + e.message);
        }
        if (resp.getResponseCode() == 429) {
            RESTError e = this.readError(resp);
            throw new MoxtraException("Too many requests, " + e.message);
        }
        if (resp.getResponseCode() >= 400) {
            RESTError e = this.readError(resp);
            if (e.message != EMPTY) {
                throw new MoxtraClientException("Client error, " + e.message);
            }
            throw new MoxtraClientException("Service not found or invalid parameters. Response type was " + resp.getContentType());
        }
        if (resp.getResponseCode() >= 500) {
            RESTError e = this.readError(resp);
            throw new MoxtraException("Moxtra service error, " + e.message);
        }
        if (resp.getResponseCode() <= 0) {
            throw new MoxtraException("No response code");
        }
    }

    protected RESTResponse restRequest(String url, String method) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        return this.restRequest(url, method, null);
    }

    protected RESTResponse restRequest(String url, String method, String body) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        return this.restRequest(url, method, REQUEST_CONTENT_TYPE_JSON, body);
    }

    protected RESTResponse restRequest(String url, String method, String contentType, String body) throws OAuthSystemException, OAuthProblemException, MoxtraException, MoxtraClientException {
        if (this.isAuthorized()) {
            RESTResponse resp = null;
            boolean wasRetry = false;
            while (true) {
                try {
                    OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(url).setAccessToken(this.accessToken()).buildQueryMessage();
                    if (contentType != null) {
                        bearerClientRequest.setHeader("Content-Type", contentType);
                    }
                    if (body != null) {
                        bearerClientRequest.setBody(body);
                    }
                    resp = (RESTResponse)this.oAuthClient.resource(bearerClientRequest, method, RESTResponse.class);
                    this.checkError(resp);
                    return resp;
                }
                catch (MoxtraAccessException e) {
                    if (resp != null && !wasRetry && resp.getResponseCode() == 401) {
                        if (resp.getValue().toString().indexOf("invalid_token") < 0) continue;
                        this.authorizer().refresh();
                        wasRetry = true;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        throw new MoxtraException("Authorization required");
    }

    protected boolean isNull(JsonValue json) {
        return json == null || json.isNull();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MoxtraMeet readMeet(JsonValue vmeet) throws MoxtraException, OAuthSystemException, OAuthProblemException, ParseException {
        JsonValue vparticipants;
        JsonValue vtotalParticipants;
        JsonValue vinvitees;
        Date endTime;
        Date startTime;
        JsonValue vsession = vmeet.getElement("session_key");
        if (this.isNull(vsession)) {
            throw new MoxtraException("Meet request doesn't return meet session key");
        }
        String sessionKey = vsession.getStringValue();
        JsonValue vbid = vmeet.getElement("binder_id");
        if (this.isNull(vbid)) {
            throw new MoxtraException("Meet request doesn't return meet binder id");
        }
        JsonValue vtopic = vmeet.getElement("topic");
        if (this.isNull(vtopic)) {
            throw new MoxtraException("Meet request doesn't return meet topic");
        }
        JsonValue vstatus = vmeet.getElement("status");
        if (this.isNull(vstatus)) {
            throw new MoxtraException("Meet request doesn't return meet status");
        }
        String status = vstatus.getStringValue();
        boolean meetStarted = MoxtraMeet.SESSION_STARTED.equals(status);
        JsonValue vstarts = vmeet.getElement("starts");
        if (this.isNull(vstarts)) {
            vstarts = vmeet.getElement("scheduled_starts");
            if (this.isNull(vstarts)) {
                throw new MoxtraException("Meet request doesn't return starts time");
            }
            startTime = Moxtra.parseDate(vstarts.getStringValue());
        } else {
            startTime = new Date(vstarts.getLongValue());
        }
        JsonValue vends = vmeet.getElement("ends");
        if (this.isNull(vends)) {
            vends = vmeet.getElement("scheduled_ends");
            if (this.isNull(vends)) {
                if (!meetStarted) throw new MoxtraException("Meet request doesn't return ends time");
                endTime = null;
            } else {
                endTime = Moxtra.parseDate(vends.getStringValue());
            }
        } else {
            endTime = new Date(vends.getLongValue());
        }
        String binderId = vbid.getStringValue();
        MoxtraBinder meetBinder = this.getBinder(binderId);
        ArrayList vusers = new ArrayList();
        JsonValue vtotalInvites = vmeet.getElement("total_invitees");
        if (!this.isNull(vtotalInvites) && vtotalInvites.getIntValue() > 0 && !this.isNull(vinvitees = vmeet.getElement("invitees")) && vinvitees.isArray()) {
            Iterator vuiter = vinvitees.getElements();
            while (vuiter.hasNext()) {
                vusers.add(vuiter.next());
            }
        }
        if (!this.isNull(vtotalParticipants = vmeet.getElement("total_participants")) && vtotalParticipants.getIntValue() > 0 && !this.isNull(vparticipants = vmeet.getElement("participants")) && vparticipants.isArray()) {
            Iterator vuiter = vparticipants.getElements();
            while (vuiter.hasNext()) {
                vusers.add(vuiter.next());
            }
        }
        if (vusers.isEmpty() && !meetStarted) {
            throw new MoxtraException("Meet request doesn't return invitees/participants array");
        }
        MoxtraUser hostUser = null;
        ArrayList<MoxtraUser> participants = new ArrayList<MoxtraUser>();
        for (JsonValue vu : vusers) {
            JsonValue vemail = vu.getElement("email");
            if (this.isNull(vemail)) {
                throw new MoxtraException("Meet request doesn't return user email");
            }
            String userEmail = vemail.getStringValue();
            JsonValue vname = vu.getElement("name");
            String userName = this.isNull(vname) ? null : vname.getStringValue();
            JsonValue vhost = vu.getElement("host");
            if (this.isNull(vhost)) {
                throw new MoxtraException("Meet request doesn't return user host flag");
            }
            MoxtraUser binderUser = null;
            for (MoxtraUser bu : meetBinder.getUsers()) {
                if (!userEmail.equals(bu.getEmail())) continue;
                binderUser = bu;
                break;
            }
            MoxtraUser user = binderUser == null ? new MoxtraUser(userEmail) : new MoxtraUser(binderUser.getId(), userName != null ? userName : binderUser.getName(), userEmail, binderUser.getFirstName(), binderUser.getLastName(), binderUser.getType(), binderUser.getStatus(), binderUser.getCreatedTime(), binderUser.getUpdatedTime());
            participants.add(user);
            if (!vhost.getBooleanValue()) continue;
            hostUser = user;
        }
        JsonValue vagenda = vmeet.getElement("agenda");
        String agenda = this.isNull(vagenda) ? null : vagenda.getStringValue();
        JsonValue vlink = vmeet.getElement("startmeet_url");
        String startMeetUrl = this.isNull(vlink) ? MOXTRA_URL + sessionKey : vlink.getStringValue();
        JsonValue vautorec = vmeet.getElement("auto_recording");
        Boolean autorec = this.isNull(vautorec) ? null : Boolean.valueOf(vautorec.getBooleanValue());
        MoxtraMeet meet = new MoxtraMeet(sessionKey, null, binderId, vtopic.getStringValue(), agenda, meetBinder.getRevision(), startMeetUrl, meetBinder.getCreatedTime(), meetBinder.getUpdatedTime(), startTime, endTime, autorec, status);
        meet.setUsers(participants);
        meet.setHostUser(hostUser);
        return meet;
    }

    public class OAuth2Authorizer {
        protected String redirectLink;

        public String authorizationLink() throws OAuthSystemException {
            StringBuilder redirectLink = new StringBuilder();
            redirectLink.append(MoxtraClient.this.oAuthClientSchema);
            redirectLink.append("://");
            redirectLink.append(MoxtraClient.this.oAuthClientHost);
            redirectLink.append('/');
            redirectLink.append(PortalContainer.getCurrentRestContextName());
            redirectLink.append("/moxtra/login");
            return this.authorizationLink(redirectLink.toString());
        }

        public String authorizationLink(String redirectLink) throws OAuthSystemException {
            this.redirectLink = redirectLink;
            OAuthClientRequest request = OAuthClientRequest.authorizationLocation((String)MoxtraClient.API_OAUTH_AUTHORIZE).setClientId(MoxtraClient.this.oAuthClientId).setResponseType("code").setRedirectURI(redirectLink).buildQueryMessage();
            return request.getLocationUri();
        }

        public MoxtraClient authorize(String code) throws OAuthSystemException, OAuthProblemException {
            if (this.redirectLink != null) {
                OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)"https://api.moxtra.com/oauth/token").setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(MoxtraClient.this.oAuthClientId).setClientSecret(MoxtraClient.this.oAuthClientSecret).setRedirectURI(this.redirectLink).setCode(code).buildQueryMessage();
                request.setHeader(REQUEST_ACCEPT, REQUEST_CONTENT_TYPE_JSON + "; q=1.0, text/*; q=0.9");
                OAuthJSONAccessTokenResponse resp = MoxtraClient.this.oAuthClient.accessToken(request, "POST");
                MoxtraClient.this.initOAuthToken(AccessToken.createToken(resp.getAccessToken(), resp.getRefreshToken(), resp.getExpiresIn(), resp.getScope()));
                return MoxtraClient.this;
            }
            throw new OAuthSystemException("Redirect link required");
        }

        public MoxtraClient refresh() throws OAuthSystemException, OAuthProblemException {
            String refreshToken = MoxtraClient.this.getOAuthToken().getRefreshToken();
            if (refreshToken != null) {
                OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)"https://api.moxtra.com/oauth/token").setGrantType(GrantType.REFRESH_TOKEN).setClientId(MoxtraClient.this.oAuthClientId).setClientSecret(MoxtraClient.this.oAuthClientSecret).setRefreshToken(refreshToken).buildQueryMessage();
                request.setHeader(REQUEST_ACCEPT, REQUEST_CONTENT_TYPE_JSON + "; q=1.0, text/*; q=0.9");
                OAuthJSONAccessTokenResponse resp = MoxtraClient.this.oAuthClient.accessToken(request, "POST");
                MoxtraClient.this.initOAuthToken(AccessToken.createToken(resp.getAccessToken(), resp.getRefreshToken(), resp.getExpiresIn(), resp.getScope()));
                return MoxtraClient.this;
            }
            throw new OAuthSystemException("Refresh token required");
        }

        public String getRedirectLink() {
            return this.redirectLink;
        }
    }

    protected class RESTClient
    implements HttpClient {
        protected RESTClient() {
        }

        public void shutdown() {
            ClientConnectionManager connectionManager;
            if (MoxtraClient.this.httpClient != null && (connectionManager = MoxtraClient.this.httpClient.getConnectionManager()) != null) {
                connectionManager.shutdown();
            }
        }

        public <T extends OAuthClientResponse> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
            try {
                OAuthClientResponse clientResp;
                HttpResponse response;
                HttpEntity httpEntity;
                Header contentTypeHeader;
                Object req;
                URI location = new URI(request.getLocationUri());
                if (!OAuthUtils.isEmpty((String)requestMethod)) {
                    if ("POST".equals(requestMethod)) {
                        HttpPost post = new HttpPost(location);
                        StringEntity stringEntity = new StringEntity(request.getBody() == null ? EMPTY : request.getBody());
                        post.setEntity((HttpEntity)stringEntity);
                        req = post;
                    } else if ("PUT".equals(requestMethod)) {
                        HttpPut put = new HttpPut(location);
                        StringEntity stringEntity = new StringEntity(request.getBody() == null ? EMPTY : request.getBody());
                        put.setEntity((HttpEntity)stringEntity);
                        req = put;
                    } else {
                        req = "DELETE".equals(requestMethod) ? new HttpDelete(location) : ("HEAD".equals(requestMethod) ? new HttpHead(location) : ("OPTIONS".equals(requestMethod) ? new HttpOptions(location) : new HttpGet(location)));
                    }
                } else {
                    req = new HttpGet(location);
                }
                if (headers != null && !headers.isEmpty()) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        req.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (request.getHeaders() != null) {
                    for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                        req.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                String contentType = (contentTypeHeader = (httpEntity = (response = MoxtraClient.this.httpClient.execute((HttpUriRequest)req)).getEntity()).getContentType()) != null ? contentTypeHeader.getValue() : REQUEST_CONTENT_TYPE_BINARY;
                int responseCode = response.getStatusLine().getStatusCode();
                boolean isRestReponse = RESTResponse.class.isAssignableFrom(responseClass);
                if (LOG.isDebugEnabled()) {
                    String url = location.toASCIIString();
                    int i = url.indexOf("?access_token=");
                    if (i < 0) {
                        i = url.indexOf("access_token=");
                    }
                    if (i > 0) {
                        url = url.substring(0, i);
                    }
                    LOG.debug((Object)("Moxtra " + requestMethod + " " + url + " > " + responseCode + " " + contentType + " " + httpEntity.getContentLength() + "bytes REST:" + isRestReponse));
                }
                if (isRestReponse) {
                    RESTResponse restResp = new RESTResponse();
                    restResp.setResponseCode(responseCode);
                    restResp.setHeaders(response.getAllHeaders());
                    restResp.setContentType(contentType);
                    if (httpEntity != null) {
                        if (contentType.startsWith(REQUEST_CONTENT_TYPE_JSON)) {
                            restResp.setBody(this.readJson(response));
                        } else if (contentType.startsWith("text/")) {
                            restResp.setBody(EntityUtils.toString((HttpEntity)httpEntity));
                        } else {
                            restResp.setBody(httpEntity.getContent());
                        }
                    }
                    clientResp = restResp;
                } else {
                    String responseBody;
                    responseBody = httpEntity != null ? (responseBody = EntityUtils.toString((HttpEntity)httpEntity)) : EMPTY;
                    responseBody = responseBody != null ? responseBody : EMPTY;
                    try {
                        clientResp = OAuthClientResponseFactory.createCustomResponse((String)responseBody, (String)contentType, (int)responseCode, responseClass);
                    }
                    catch (OAuthProblemException e) {
                        block33: {
                            if (responseBody != EMPTY && contentType.startsWith("application/json")) {
                                try {
                                    JsonParserImpl jsonParser = new JsonParserImpl();
                                    JsonDefaultHandler handler = new JsonDefaultHandler();
                                    jsonParser.parse((Reader)new StringReader(responseBody), (JsonHandler)handler);
                                    JsonValue responseJson = handler.getJsonObject();
                                    String details = this.readOAuthProblem(responseJson);
                                    if (details != null) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Authorization problem (" + details + ")\r\n====== Moxtra response JSON ======\r\n" + responseJson.toString() + "\r\n=========================\r\n"), (Throwable)e);
                                        }
                                        AuthProblemException cause = new AuthProblemException(details);
                                        AuthProblemException newE = new AuthProblemException(e.getMessage(), (Throwable)((Object)cause));
                                        newE.setStackTrace(e.getStackTrace());
                                        newE.setRedirectUri(e.getRedirectUri());
                                        newE.scope(e.getScope());
                                        newE.state(e.getState());
                                        for (Map.Entry pe : e.getParameters().entrySet()) {
                                            newE.setParameter((String)pe.getKey(), (String)pe.getValue());
                                        }
                                        throw newE;
                                    }
                                }
                                catch (JsonException jsone) {
                                    if (!LOG.isDebugEnabled()) break block33;
                                    LOG.debug((Object)"Cannot read errouneus response as JSON", (Throwable)e);
                                }
                            }
                        }
                        throw e;
                    }
                }
                return (T)clientResp;
            }
            catch (IOException e) {
                throw new OAuthSystemException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new OAuthSystemException((Throwable)e);
            }
            catch (JsonException e) {
                throw new OAuthSystemException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new OAuthRuntimeException((Throwable)e);
            }
        }

        protected JsonValue readJson(HttpResponse resp) throws JsonException, IllegalStateException, IOException {
            HttpEntity entity = resp.getEntity();
            Header contentType = entity.getContentType();
            if (contentType != null && contentType.getValue() != null && contentType.getValue().startsWith("application/json")) {
                InputStream content = entity.getContent();
                JsonParserImpl jsonParser = new JsonParserImpl();
                JsonDefaultHandler handler = new JsonDefaultHandler();
                jsonParser.parse((Reader)new InputStreamReader(content), (JsonHandler)handler);
                return handler.getJsonObject();
            }
            throw new JsonException("Not JSON content");
        }

        protected String readOAuthProblem(JsonValue json) {
            JsonValue errorMsg;
            JsonValue stackTrace = json.getElement("stackTrace");
            if (stackTrace != null && (errorMsg = json.getElement("message")) != null) {
                return errorMsg.getStringValue();
            }
            return null;
        }
    }

    protected class RESTResponse
    extends OAuthClientResponse {
        protected JsonValue jsonValue;
        protected String stringValue;
        protected InputStream streamValue;
        protected Header[] headers;

        protected RESTResponse() {
        }

        protected void setContentType(String contentType) {
            this.contentType = contentType;
        }

        protected void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public JsonValue getValue() {
            return this.jsonValue;
        }

        public String getText() {
            return this.stringValue;
        }

        public InputStream getInputStream() {
            return this.streamValue;
        }

        protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
            this.setContentType(contentType);
            this.setResponseCode(responseCode);
        }

        protected void setBody(JsonValue value) {
            if (this.stringValue != null || this.streamValue != null) {
                throw new IllegalStateException("Body already set");
            }
            this.jsonValue = value;
        }

        protected void setBody(String value) {
            if (this.jsonValue != null || this.streamValue != null) {
                throw new IllegalStateException("Body already set");
            }
            this.stringValue = value;
        }

        protected void setBody(InputStream value) {
            if (this.jsonValue != null || this.stringValue != null) {
                throw new IllegalStateException("Body already set");
            }
            this.streamValue = value;
        }

        protected void setHeaders(Header[] headers) {
            this.headers = headers;
        }

        public String getParam(String param) {
            for (Header h : this.headers) {
                if (!h.getName().equals(param)) continue;
                String hv = h.getValue();
                if (hv != null) {
                    return hv;
                }
                StringBuilder pv = new StringBuilder();
                HeaderElement[] elems = h.getElements();
                for (int i = 0; i < elems.length; ++i) {
                    HeaderElement elem = elems[i];
                    pv.append(elem.getName());
                    pv.append('=');
                    pv.append(elem.getValue());
                    if (elem.getParameterCount() > 0) {
                        pv.append(';');
                        NameValuePair[] params = elem.getParameters();
                        for (int pi = 0; pi < params.length; ++pi) {
                            NameValuePair nvp = params[pi];
                            pv.append(nvp.getName());
                            pv.append("=\"");
                            pv.append(nvp.getValue());
                            pv.append('\"');
                            if (pi >= params.length - 1) continue;
                            pv.append(';');
                        }
                    }
                    if (i >= elems.length - 1) continue;
                    pv.append(',');
                }
                if (pv.length() <= 0) continue;
                return pv.toString();
            }
            return super.getParam(param);
        }

        Header getHeader(String name) {
            for (Header h : this.headers) {
                if (!h.getName().equals(name)) continue;
                return h;
            }
            return null;
        }
    }

    protected class AuthProblemException
    extends OAuthProblemException {
        private static final long serialVersionUID = 4030969137768681190L;
        protected final Throwable cause;

        protected AuthProblemException(String error, Throwable cause) {
            super(error);
            this.cause = cause;
        }

        protected AuthProblemException(String error) {
            this(error, null);
        }

        public synchronized Throwable getCause() {
            return this.cause != null ? this.cause : super.getCause();
        }
    }

    protected class HeaderValue {
        protected final String value;
        protected final Map<String, String> values;

        protected HeaderValue(String value) {
            this.value = value;
            this.values = null;
        }

        protected HeaderValue(Map<String, String> values) {
            this.values = values;
            this.value = null;
        }

        protected boolean isSingleValue() {
            return this.value != null;
        }
    }

    protected class RESTError {
        final String code;
        final String message;

        protected RESTError(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

