/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.client;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.moxtra.Moxtra;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.client.MoxtraBinder;
import org.exoplatform.moxtra.client.MoxtraUser;

public class MoxtraMeet
extends MoxtraBinder {
    public static final String SESSION_SCHEDULED = "SESSION_SCHEDULED".intern();
    public static final String SESSION_STARTED = "SESSION_STARTED".intern();
    public static final String SESSION_ENDED = "SESSION_ENDED".intern();
    public static final String SESSION_DELETED = "SESSION_DELETED".intern();
    public static final int SESSION_START_BEFORE_MINUTES = 30;
    protected String sessionKey;
    protected String sessionId;
    protected String agenda;
    protected String startMeetUrl;
    protected Boolean autoRecording;
    protected Date startTime;
    protected Date endTime;
    protected String status;
    private transient MoxtraUser hostUser;
    private final transient MoxtraMeet original;
    private transient MoxtraMeet editor;
    private transient String videoWorkspace;
    private transient String videoPath;

    public static MoxtraMeet create(String sessionKey, String sessionId, String binderId, String name, String agenda, Long revision, String startMeetUrl, Date createdTime, Date updatedTime, Date startTime, Date endTime, Boolean autoRecording, List<MoxtraUser> users) {
        MoxtraMeet meet = new MoxtraMeet(sessionKey, sessionId, binderId, name, agenda, revision, startMeetUrl, createdTime, updatedTime, startTime, endTime, autoRecording, null);
        meet.setUsers(users);
        return meet;
    }

    protected MoxtraMeet(String sessionKey, String sessionId, String binderId, String name, String agenda, Long revision, String startMeetUrl, Date createdTime, Date updatedTime, Date startTime, Date endTime, Boolean autoRecording, String status) {
        super(binderId, name, revision, createdTime, updatedTime);
        this.sessionKey = sessionKey;
        this.sessionId = sessionId;
        this.agenda = agenda;
        this.startMeetUrl = startMeetUrl;
        this.startTime = startTime;
        this.endTime = endTime;
        this.autoRecording = autoRecording;
        this.status = status;
        this.original = null;
    }

    public MoxtraMeet(String sessionKey, String sessionId, String binderId, String name, Long revision, String startMeetUrl, Date createdTime, Date updatedTime) {
        this(sessionKey, sessionId, binderId, name, revision, startMeetUrl, createdTime, updatedTime, null, null, false);
    }

    @Deprecated
    public MoxtraMeet(String binderId, String name, Long revision, Date createdTime, Date updatedTime) {
        this(null, null, binderId, name, null, revision, null, createdTime, updatedTime, null, null, false, null);
    }

    @Deprecated
    public MoxtraMeet(String sessionKey, String scheduleBinderId, String name, String agenda, Long revision, String startMeetUrl, Date createdTime, Date updatedTime, Date startTime, Date endTime, Boolean autoRecording) {
        this(sessionKey, null, scheduleBinderId, name, agenda, revision, startMeetUrl, createdTime, updatedTime, startTime, endTime, autoRecording, null);
    }

    public MoxtraMeet() {
        this.original = null;
    }

    @Deprecated
    public MoxtraMeet(String name, String agenda, Date startTime, Date endTime, Boolean autoRecording) {
        this(null, null, null, name, agenda, null, null, null, null, startTime, endTime, autoRecording, null);
    }

    protected MoxtraMeet(MoxtraMeet otherMeet) {
        super(otherMeet);
        this.sessionKey = null;
        this.sessionId = null;
        this.agenda = null;
        this.startMeetUrl = null;
        this.startTime = null;
        this.endTime = null;
        this.autoRecording = null;
        this.original = otherMeet;
    }

    @Override
    public String toString() {
        String id;
        StringBuilder str = new StringBuilder();
        String bid = this.getBinderId();
        if (bid != null) {
            str.append(bid);
        }
        if ((id = this.getSessionKey()) != null) {
            str.append('[');
            str.append(id);
            str.append(']');
        }
        if (str.length() > 0) {
            str.append(' ');
        }
        str.append(this.getName());
        return str.toString();
    }

    @Override
    public MoxtraMeet editor() {
        if (this.editor != null) {
            return this.editor;
        }
        if (this.isEditor()) {
            return this;
        }
        this.editor = new MoxtraMeet(this);
        return this.editor;
    }

    public MoxtraUser getHostUser() throws MoxtraException {
        if (this.hostUser != null) {
            return this.hostUser;
        }
        for (MoxtraUser user : this.getUsers()) {
            if (!"BOARD_OWNER".equals(user.getType())) continue;
            return user;
        }
        throw new MoxtraException("Cannot find meet owner in participants");
    }

    public boolean hasUser(MoxtraUser user) {
        for (MoxtraUser mu : this.getUsers()) {
            if (!mu.equals(user)) continue;
            return true;
        }
        return false;
    }

    public String getSessionKey() {
        return this.sessionKey != null ? this.sessionKey : (this.isEditor() ? this.original.getSessionKey() : null);
    }

    public String getSessionId() {
        return this.sessionId != null ? this.sessionId : (this.isEditor() ? this.original.getSessionId() : null);
    }

    public String getAgenda() {
        return this.agenda != null ? this.agenda : (this.isEditor() ? this.original.getAgenda() : null);
    }

    public String getStartMeetUrl() {
        return this.startMeetUrl != null ? this.startMeetUrl : (this.isEditor() ? this.original.getStartMeetUrl() : null);
    }

    public String getStatus() {
        return this.status != null ? this.status : (this.isEditor() ? this.original.getStatus() : null);
    }

    public boolean isStarted() {
        return SESSION_STARTED.equals(this.getStatus());
    }

    public boolean isEnded() {
        return SESSION_ENDED.equals(this.getStatus());
    }

    public boolean isScheduled() {
        return SESSION_SCHEDULED.equals(this.getStatus());
    }

    public boolean isDeleted() {
        return SESSION_DELETED.equals(this.getStatus());
    }

    public boolean isExpired() {
        if (this.isScheduled()) {
            Calendar now = Moxtra.getCalendar();
            Date et = this.getEndTime();
            if (et != null) {
                Calendar endTime = Moxtra.getCalendar(et);
                endTime.add(12, 4);
                return now.after(endTime);
            }
        }
        return false;
    }

    public boolean canStart() {
        if (this.getStartMeetUrl() != null) {
            if (this.isStarted()) {
                return true;
            }
            if (this.isEnded() || this.isDeleted()) {
                return false;
            }
            Calendar now = Moxtra.getCalendar();
            Date st = this.getStartTime();
            if (st != null) {
                Calendar startTime = Moxtra.getCalendar(st);
                startTime.add(12, -30);
                return (startTime.equals(now) || now.after(startTime)) && !this.isExpired();
            }
        }
        return false;
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        if (this.isEditor()) {
            return this.original.getStartTime();
        }
        return null;
    }

    public Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime;
        }
        if (this.isEditor()) {
            return this.original.getEndTime();
        }
        return null;
    }

    public Boolean getAutoRecording() {
        return this.autoRecording != null ? this.autoRecording : (this.isEditor() ? this.original.getAutoRecording() : null);
    }

    public boolean isAutoRecording() {
        Boolean autorec = this.getAutoRecording();
        return autorec != null ? autorec : false;
    }

    public void editAutoRecording(Boolean newAutoRecording) {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.autoRecording = newAutoRecording;
    }

    public boolean hasAutoRecordingChanged() {
        if (this.isEditor() && this.autoRecording != null) {
            return !this.autoRecording.equals(this.original.getAutoRecording());
        }
        return false;
    }

    public void editStartTime(Date newStartTime) {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.startTime = newStartTime;
    }

    public boolean hasStartTimeChanged() {
        if (this.isEditor() && this.startTime != null) {
            return !this.startTime.equals(this.original.getStartTime());
        }
        return false;
    }

    public void editEndTime(Date newEndTime) {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.endTime = newEndTime;
    }

    public boolean hasEndTimeChanged() {
        if (this.isEditor() && this.endTime != null) {
            return !this.endTime.equals(this.original.getEndTime());
        }
        return false;
    }

    public void editAgenda(String newAgenda) {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.agenda = newAgenda;
    }

    public boolean hasAgendaChanged() {
        if (this.isEditor() && this.agenda != null) {
            return !this.agenda.equals(this.original.getAgenda());
        }
        return false;
    }

    public void setVideoWorkspace(String videoWorkspace) {
        this.videoWorkspace = videoWorkspace;
    }

    public void setVideoPath(String videoPath) {
        this.videoPath = videoPath;
    }

    public String getVideoWorkspace() {
        return this.videoWorkspace;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    protected void setHostUser(MoxtraUser hostUser) {
        this.hostUser = hostUser;
    }

    protected void setAutoRecording(Boolean autoRecording) {
        if (this.isEditor()) {
            this.original.setAutoRecording(autoRecording);
            this.autoRecording = null;
        } else {
            this.autoRecording = autoRecording;
        }
    }

    protected void setStartTime(Date startTime) {
        if (this.isEditor()) {
            this.original.setStartTime(startTime);
            this.startTime = null;
        } else {
            this.startTime = startTime;
        }
    }

    protected void setEndTime(Date endTime) {
        if (this.isEditor()) {
            this.original.setEndTime(endTime);
            this.endTime = null;
        } else {
            this.endTime = endTime;
        }
    }

    protected void setAgenda(String agenda) {
        if (this.isEditor()) {
            this.original.setAgenda(agenda);
            this.agenda = null;
        } else {
            this.agenda = agenda;
        }
    }

    protected void setSessionKey(String sessionKey) {
        if (this.isEditor()) {
            this.original.setSessionKey(sessionKey);
            this.sessionKey = null;
        } else {
            this.sessionKey = sessionKey;
        }
    }

    protected void setSessionId(String sessionId) {
        if (this.isEditor()) {
            this.original.setSessionId(sessionId);
            this.sessionId = null;
        } else {
            this.sessionId = sessionId;
        }
    }

    protected void setStartMeetUrl(String startMeetUrl) {
        if (this.isEditor()) {
            this.original.setStartMeetUrl(startMeetUrl);
            this.startMeetUrl = null;
        } else {
            this.startMeetUrl = startMeetUrl;
        }
    }

    protected void setStatus(String status) {
        if (this.isEditor()) {
            this.original.setStatus(status);
            this.status = null;
        } else {
            this.status = status;
        }
    }

    protected void checkTime() {
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        if (startTime == null && endTime != null) {
            Calendar start = Moxtra.getCalendar();
            start.setTime(endTime);
            start.add(12, -30);
            this.startTime = start.getTime();
        } else if (startTime != null && (endTime == null || endTime.before(startTime) || endTime.equals(startTime))) {
            Calendar end = Moxtra.getCalendar();
            end.setTime(startTime);
            end.add(12, 30);
            this.endTime = end.getTime();
        }
    }
}

